-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with ANSI_Console;
use ANSI_Console;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Wide_Fixed;
use Ada.Strings;

package body El.Classe.Activities_class is

   function Raison_Value(Line : in Wide_String) return Wstring_38 is
      
      Raison : Wstring_38 := (others => ' ');
      
      
      Index : Natural := Wide_Fixed.Index(Line, """");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), """");
   begin
      
      if Next /= 0 then
	 Wide_Fixed.Move( (Line(index+1..Next-1)), Raison);
	 return Raison;
      end if;
      return raison;
   exception
      when others =>
	 return raison;
   end Raison_Value;
   
   
   function Full_address_Value(Line : in Wide_String) return Wstring_38 is
      
      
      Address : Wstring_38 := (others => ' ');
      
      Index : Natural := Wide_Fixed.Index(Line, """", backward);
      Next  : Natural := Wide_Fixed.Index(Line(Line'first..Index-1), """", backward);
      
      
   begin
      
      if Next /= 0 then
	 Wide_Fixed.Move((Line(Next+1..index-1)), Address);
	 return Address;
      end if;
      return address;
   exception
      when others =>
	 return address;
   end Full_address_Value;
   
   function Ste_Type_Value(Line : in Wide_String) return Wstring_24 is
      
      Ste_Type : Wstring_24 := (others => ' ');
      
      Last  : Natural := Wide_Fixed.Index(Line, " ", backward);
      Index : Natural := Wide_Fixed.Index(Line(Line'First..Last-1), " ", backward);
      Next  : Natural := Wide_Fixed.Index(Line(Line'first..Index-1), " ", backward);
      
   begin
      
      if Next /= 0 then
	 Wide_Fixed.Move( (Line(next+1..index-1)), Ste_Type);
	 return Ste_Type;
      end if;
      return Ste_type;
   exception
      when others =>
	 return Ste_type;
   end Ste_Type_Value;
   
   function Fiscal_Value(Line : in Wide_String) return Wstring_24 is
      
      
      Fiscal : Wstring_24 := (others => ' ');
      
      Last  : Natural := Wide_Fixed.Index(Line, " ", backward);
      Index : Natural := Wide_Fixed.Index(Line(Line'First..Last-1), " ", backward);
      
      
   begin
      
      if last /= 0 then
	 Wide_Fixed.Move( (Line(index+1..last-1)), Fiscal);
	 return Fiscal;
      end if;
      return fiscal;
   exception
      when others =>
	 return fiscal;
   end Fiscal_Value;
   
   
   function Affilia_Value(Line : in Wide_String) return Wstring_24 is
      
      
      Affilia : Wstring_24 := (others => ' ');
      
      Last  : Natural := Wide_Fixed.Index(Line, " ", backward);      
      
      
   begin
      
      if last /= 0 then
	 Wide_Fixed.Move((Line(Last+1..Line'last)), Affilia);
	 return Affilia;
      end if;
      return Affilia;
   exception
      when others =>
	 return affilia;
   end Affilia_Value;

   
   -----------------------------------------------------------------------------
   --                  Activity                                                 --
   
   procedure Help(Activity    : in out Activity_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Red, "create Activity : help");
      
      Draw(Win, Win_Index+2, 3, Cyan, "Name is string.");
      Draw(Win, Win_Index+3, 3, Cyan,
	   "create Activity NAME ""Rais"" ""Addr"" St_Type Fisc Aff");
      Win_Index := Win_Index + 4;
      Wide_Fixed.Move("help", Name, Error, Left, ' ');
   end Help;
   
   
   procedure Print (Object : Activity_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Cyan, "Index    : " &
	     To_Wide_String(Abstracted_Index'Image(Object.Index)));
      Draw(Win, Win_Index+2, 3, Cyan, "Created  : "
	     & To_Wide_String(Image(Object.Create_Date)));            
      Draw(Win, Win_Index+3, 3, Cyan, "Name     : " & Object.Name);
      Draw(Win, Win_Index+4, 3, Cyan, "Raison   : " & Object.Raison);
      Draw(Win, Win_Index+5, 3, Cyan, "Address  : " & Object.Address);
      Draw(Win, Win_Index+6, 3, Cyan, "Affilia  : " & Object.Affilia);
      Draw(Win, Win_Index+7, 3, Cyan, "Ste_Type : " & Object.Ste_Type);
      Draw(Win, Win_Index+8, 3, Cyan, "Fiscal   : " & Object.Fiscal);
      
      
      
      Win_Index := Win_Index + 9;
      
      Draw(Win, Win_Index+1, 3, Cyan, "Definition " & Object.Name);
      Win_Index := Win_Index + 1;
      for I in 1..Object.Def.Index loop
	 Draw(Win, Win_Index+1, 3, Cyan, "Attr " & To_Wide_String(Natural'Image(I)) & " : " &
		To_Wide_String(Object.Def.List(I).Names) & '=' & To_Wide_String(Object.Def.List(I).Image));
	 Win_Index := Win_Index + 1;
      end loop;
      
      
      Name := Object.Name;
   end Print;
   
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Name      : in Name_Type;
		   Raison    : in Wide_String;
		   Address   : in Wide_String;
		   Ste_Type  : in Wide_String;
		   Affilia   : in Wide_String;
		   Fiscal    : in Wide_String) return Abstracted_Access is
      
      O : Abstracted_Access := new Activity_Class;
      Label   : Name_Type;
   begin
      if O /= null then
	 Wide_Fixed.Move(Name, O.Name, Error, Left, ' ');
	 Activity_Class(O.all).Name := Name;
	 Activity_Class(O.all).Raison := Raison;
	 Activity_Class(O.all).Address := Address;
	 Activity_Class(O.all).Ste_Type := Ste_Type;
	 Activity_Class(O.all).Fiscal := Fiscal;
	 Activity_Class(O.all).Affilia := Affilia;
	 
	 Activity_Class(O.all).Print(Win, Win_Index, Label);	 
	 return O;
      else
	 return null;
      end if;
   end Create;
   procedure Write (O : in Activity_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Tag_Name'Image(Abstracted_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstracted_Index'Image(O.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Create_Date)));      
      W_Io.Put_Line(File, O.Name);
      W_Io.Put_Line(File, O.Raison);
      W_Io.Put_Line(File, O.Address);
      W_Io.Put_Line(File, O.Ste_Type);
      W_Io.Put_Line(File, O.Affilia);
      W_Io.Put_Line(File, O.Fiscal);
      
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Def.Index)));
      for I in 1..O.Def.Index loop
	 W_Io.Put_Line(File, To_Wide_String(O.Def.List(I).Names) & '=' & To_Wide_String(O.Def.List(I).Image));
      end loop;
      
   end Write;
   procedure Read (O : in out Activity_Class;File : in W_Io.File_Type) is
      Name_Last : Natural := 0;
      Empty : Wide_String(1..80);
      Empty_Last : Natural := 0;
      Att_Index : Natural := 0;      
   begin
      -- obscure blank line
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
	 Empty_2 : Wide_String := W_Io.Get_Line(File);
	 
      begin
	 
	 O.Index := Integer'Value(To_String(Empty_2));
      end;
      
      O.Create_Date := Value(To_String(W_Io.Get_Line(File)));
      
      W_Io.Get_Line(File, O.Name, Name_last);
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
            
      W_Io.Get_Line(File, O.Raison, Name_last);
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
      
      W_Io.Get_Line(File, O.Address, Name_last);
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
      
      W_Io.Get_Line(File, O.Ste_Type, Name_last);
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
	 
      begin
	 null;
      end;
      
      
      W_Io.Get_Line(File, O.Affilia, Name_last);
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
	 
      begin
	 null;
      end;
      
      W_Io.Get_Line(File, O.Fiscal, Name_last);            
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
	 
      begin
	 null;
      end;
      
      
      Att_Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      for I in 1..Att_Index loop
	 declare
	    Tags      : String_Access;
	    Image     : String_Access;
	 begin
	    Parse(W_Io.Get_Line(File), Tags, Image);
	    O.Def.List(I) := Make (Tags.all, Image.all);
	    O.Def.Index := O.Def.Index + 1;
	 end;
      end loop;

      
   end Read;
   
   procedure Random (O : in out Activity_Class) is
   begin
      null;
   end Random;

end El.Classe.Activities_class ; 
