-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with Ada.Calendar;
use Ada.Calendar;
with El.Classe.Accoun;
with El.Strings;
generic
   with package Account is new El.Classe.Accoun (<>);

package El.Classe.Account_lines_class is
   use Account;
   use Strings;
   function Designation_Value(Line : in Wide_String) return Designation_Line;
   function Line_Name_Value(Line : in Wide_String) return Name_Type;
   function Delays_Value(Line : in Wide_String) return Days_Delay;
   function sum_Value(Line : in Wide_String) return Fixed_Sum;
   --------------------------------------------------------------------------
   --                     Account line
   
   type Acc_Line_Class is new Abstracted_Class(Acc_Line) with
      record	 
	 No       : Natural := 0;
	 Design   : Designation_Line := (others => Wide_Character'Val(32));
	 Sum      : Fixed_Sum := 0.0;
	 Delays   : Days_Delay := 0;	 
	 Date_Opp : Time := Clock;
	 Date_Val : Time := Clock;
      end record;
   
   procedure Print (Object    : in Acc_Line_Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type);
   
   procedure Help(Acc_Line   : in out Acc_Line_Class'class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type);
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;		   
		   Name      : in Name_Type;
		   Design    : in Designation_Line;
		   Sum       : in Fixed_Sum;
		   Delays     : in Days_Delay) return Abstracted_Access;
   
   procedure Write (O : in Acc_Line_Class; File : in W_Io.File_Type);
   procedure Read (O : in out Acc_Line_Class; File : in W_Io.File_Type);
   procedure Random (O : in out Acc_Line_Class);
   --                      Account line
   --------------------------------------------------------------------------

end El.Classe.Account_lines_class ; 
