-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-03 13:14:19"
-- Version := "1.0.0b"
generic
   
package El.Classe.Accoun is
   subtype Wstring_16 is Wide_String(1..16);
   subtype Designation_Line is Wide_String(1..24);
   
   type Fixed_Sum is delta 0.01 digits 12 range -9_9999_999.00..9_999_999.00;
   
   subtype Days_Delay is Integer range -150 .. 150;
   
   
   type Fixed_Out is delta 0.01 digits 13 ;
   type Fixed_In is delta 0.01 digits 13 ;   
   type Fixed_Account is delta 0.01 digits 13 ;
   type Fixed_Factor is delta 0.01 digits 6 range 0.0 .. 49.99;
   
   
   subtype Account_Num_Range is Positive range 10..899_999;
   type Fixed_Unit_Ht is delta 0.01 digits 8 range -99_999.99 .. 99_999.99;
   type Fixed_Unit_TTC is delta 0.01 digits 9 range -999_999.99 .. 999_999.99;
   subtype Quantity_Range is Positive range 1..100_000;
   type Fixed_Total is delta 0.01 digits 10 range -9_999_999.99 .. 9_999_999.99;
   
   subtype Payment_Delay is Integer range -120..120;
   
   
   
   type Account_Line_Type is tagged
      record
	 Date          : Time := Clock;
	 Elaps         : Time := Clock;
	 Description   : Wstring_16 := (others => ' ');
	 Account_num   : Account_Num_Range := 10;
	 Unit_Ht_Price : Fixed_Unit_Ht := 0.0;	 
	 TVA_Factor    : Fixed_Factor := 0.0;
	 Quantity      : Quantity_Range := 1;
	 Total_Ht      : Fixed_Total := 0.0;
	 Total_Ttc     : Fixed_Total := 0.0;
	 Delays        : Payment_Delay := 0;
	 Peer_name     : Wstring_32 := (others => ' ');	 
      end record;
   
   
   
   
   type Account_State_Type is tagged
      record	 
	 Date         : Time := Clock;
	 Ht_Deal_In   : Fixed_Out := 0.0;
	 TTC_Deal_In  : Fixed_Out := 0.0;
	 TVA_In       : Fixed_in := 0.0;
	 Ht_Deal_Out  : Fixed_In := 0.0;
	 TTC_Deal_Out : Fixed_In := 0.0;
	 TVA_out      : Fixed_out := 0.0;
	 Result       : Fixed_Account := 0.0;
      end record;		
   
   
   procedure Adjust (State        : in out Account_State_Type;
		     Date         : in Time;		     
		     Ht_Deal_In   : in Fixed_out;
		     TTC_Deal_In  : in Fixed_Out;
		     TVA_In       : in Fixed_in;
		     Ht_Deal_Out  : in Fixed_in;
		     TTC_Deal_Out : in Fixed_in;
		     TVA_Out      : in Fixed_Out;
		     Result       : in Fixed_Account);

   
   
end El.Classe.Accoun ; 
