-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with Ada.Strings.Wide_Fixed;
use Ada.Strings;
with Ada.Characters.Handling;
use Ada.Characters;

package body El.Attrib is
   
      procedure Parse (Line : in Wide_String; Name : out String_Access; Image : out String_Access) is
      Index : Natural := Wide_Fixed.Index(Line, "=");
      Top   : Natural := Wide_Fixed.Index(Line(Line'First..Index), " ", backward)+ 1;
      Bot   : Natural := Wide_Fixed.Index_Non_Blank(Line, Backward);
   begin
      if (Index = 0) or (Top = 0) or (Bot = 0) then
	 return;
      end if;	      
      Name := new String ' (Handling.To_String(Line(Top..Index-1)));
      Image := new String ' (Handling.To_String(Line(Index+1..Bot)));
   end Parse;
   
   
   
   
   function Make (Names : in String; Value : in String) return Attribut_Record is
      Att : Attribut_Record;
   begin
      Att.Tags := new String ' (Names);
      begin
	 Att.boo := Boolean'Value(Value);
	 Att.Enum := Boo;
      exception
	 when Constraint_Error =>
	    begin
	       Att.Int := Integer'Value(Value);
	       Att.Enum := Int;
	    exception
	       when Constraint_Error =>
		  begin
		     Att.Flt := float'Value(Value);
		     Att.Enum := Flt;
		  exception
		     when Constraint_Error =>
			begin
			   Att.str := new String ' (Value);
			   Att.Enum := Str;
			end;
		  end;
	    end;
      end;
      return Att;
   end Make;
   
   function names (Att : in Attribut_Record) return String is
   begin
      return Att.Tags.all;
   end Names;
   function image (Att : in Attribut_Record) return String is
   begin
      case Att.Enum is
	 when Nil =>
	    return "";
	 when Boo =>
	    return Boolean'Image(Att.Boo);
	 when Int =>
	    return Integer'Image(Att.Int);
	 when Flt =>
	    return Float'Image(Att.Flt);
	 when Str =>
	    return Att.Str.all;
      end case;
   end Image;

end El.Attrib ; 
