

with Aws;
use Aws;

with Ada.Strings.UTF_Encoding.Strings;
use Ada.Strings.UTF_Encoding.Strings;
with Ada.Characters.Handling;
use Ada.Characters;

with AWS.Response;
with AWS.URL;
with AWS.Utils;

with Aws.Client;
with AWS.Headers;
with AWS.Headers.Set;


package body Adam.Web is
   
  procedure Web_Search(From_Domain_Name : in     String;
		       With_Address     : in     String;
		       Timeouts         : in     Duration;
		       Result           :    out Search_Result_Type) is
     
      
      Data : Response.Data;
      Host_Header : AWS.Client.Header_List;
      
      

  begin     
     AWS.Headers.Set.Add(Host_Header, "Host", From_Domain_Name);
     
     begin
	
	Data := Aws.Client.Get(With_Address,
			       Timeouts => AWS.Client.Timeouts
				 (Each => Timeouts), 
			       Follow_Redirection => True,
			       Headers => Host_Header);
	
	if not Response.Is_Empty(Data) then
	   Free(Result.Doc_Name);
	   Result.Doc_Name := new Wide_String ' (Handling.To_Wide_String(Response.Header(Data, "Content-Location", 1)));
	   
	   
	   declare
	      
	      Data_Body : constant Wide_String := Handling.To_Wide_String(Decode(Response.Message_Body(Data)));
	      
	      End_Of_Line : Natural := 0;
	      Top         : Natural := 1;
	      Bot         : constant Natural := Data_Body'Last;
	      
	      Content_Index : Natural := 0;
	      
	      Content_Buffer : Variadic_Access := new Variadic_Array(1..1);
	      
	   begin
	      
	      loop
		 End_Of_Line := 0;
		 for I in Top..Bot loop
		    declare
		       Char : constant Wide_Character := Data_Body(I);
		    begin
		       if Handling.Is_Line_terminator(Handling.To_Character(Char)) then
			  End_Of_Line := I;
			  Exit;
		       end if;
		    end;
		 end loop;		  		  
		 
		 if End_Of_Line > 0 then
		    Free(Content_Buffer);
		    Content_Buffer := new Variadic_Array(1..Content_Index + 1);			
		    if Content_Index > 0 then
		       Content_Buffer(1..Content_Index) := Result.File_Content.all;
		    end if;
		    Content_Buffer(Content_Index+1) := "+"(Data_Body(Top..End_Of_Line-1));
		    Free(Result.File_Content);
		    Result.File_Content := new Variadic_Array ' (Content_Buffer.all);
		    Content_Index := Content_Index + 1;
		    Top := End_Of_Line + 1;
		    Free(Content_Buffer);
		 else		     
		    Free(Content_Buffer);
		    Content_Buffer := new Variadic_Array(1..Content_Index + 1);
		    if Content_Index > 0 then
		       Content_Buffer(1..Content_Index) := Result.File_Content.all;
		    end if;
		    Content_Buffer(Content_Index+1) := "+"(Data_Body(Top..bot));
		    Free(Result.File_Content);
		    Result.File_Content := new Variadic_Array ' (Content_Buffer.all);
		    Free(Content_Buffer);
		    exit;
		 end if;
		 
	      end loop;
	      
	      
	   end;
	else
	   Free(Result.File_Content);
	   Result.File_Content := new Variadic_Array ' (1 => +("No Data in Web page."));
	   
	end if;

	
     end;
     
  end Web_Search;
  
      
   
end Adam.Web;
