
with Gnat.Os_Lib;
use Gnat.Os_Lib;
with Adam.Results;
use Adam.Results;
--with Adam.Options;
--use Adam.Options;
with Adam.Abstracts;
use Adam.Abstracts;
--with Adam.Accounting;
--use Adam.Accounting;
with System.Address_To_Access_Conversions;
package Adam.Interfaces is      
   
   type Main_Interface_Type is
     new Adam_Interface_Type with
      record
	 --Options_Kit   : Options_Kit_Array_Type;
	 Spawn_Result  : aliased Spawn_Result_Type;
         Search_Result : aliased Search_Result_Type;	 
	 Pattern       : String_Access;
	 Interfaces    : Interfaces_Array_Type(Human_Class..Human_Class);
	 --Zbank : Bank_Type;
      end record;      
   
   --  function Get_Parameter
   --    (From : in Main_Interface_Type;
   --     Flag : in Parameters_Flags_Enum_Type)
   --    return Parameter_Tagged_Record_Type;   
   
   
   --  procedure Parameters_Descriptions
   --    (From : in Main_Interface_Type);
   
   package Main_Conversions is new System.Address_To_Access_Conversions(Main_Interface_Type'class);
   subtype Main_Interface_access is Main_Conversions.Object_Pointer;   
   
   
   
   function New_Interface return Main_Interface_Access;
   
   procedure Initialize (Main_Interface : in out Main_Interface_Type'Class);
   
   procedure Print_Parameters (Main_Interface : in Main_Interface_Type'Class);      
         
   procedure Finalize (Main_Interface : in out Main_Interface_Type'Class);
   
   type Textual_Interface_Type;
   task type Textual_Thread_Type (Machine : access Textual_Interface_Type) is
      --entry Initialize (Errno : out Integer);
      entry Halt;
   end Textual_Thread_Type;
   
   type Textual_Interface_Type is
     new Main_Interface_Type with
      record
	 Textual_Thread : Textual_Thread_Type(Textual_Interface_Type'access);
      end record;
      
   type Graphical_Interface_Type;
   task type Graphical_Thread_Type (Machine : access Graphical_Interface_Type) is
      --entry Initialize (Errno : out Integer);
      entry Receive(Text : in String);
      entry Send(Text : out String_Access);
      entry Exhauste(Text : out String_Access);
      entry Halt;
   end Graphical_Thread_Type;

   type Graphical_Interface_Type is
     new Main_Interface_Type with
      record
	 Graphical_Thread : Graphical_Thread_Type(Graphical_Interface_Type'access);
      end record;
      
   procedure Shell_Halt;
   
   
   
--  private
   
--     procedure Set_Parameters
--       (Parameters : out Parameters_Kit_Record_Type;			    
--        Options_Kit : in Options_Kit_Array_Type);
   
--     function Set_Parameters_From
     
--       (Filename : in Wide_String) 
     
--       return access Parameters_Kit_Record_Type;      
----     not implemented.

end Adam.Interfaces;
