with Gnat.Sockets;
with Ada.Unchecked_Deallocation;
package Adam.Common is
   
   
   type String_Access is access all Wide_String;
   
   type String_Array_Type is array (Positive range <>) of String_Access;
   
   Response_Max : constant Positive := 24;
   
   subtype Response_Type is String_Array_Type (1..Response_Max);      
   
   
   procedure Free is
      new Ada.Unchecked_Deallocation(Wide_String, String_Access);              
   
   type Socket_Access is access all Gnat.Sockets.Socket_Type;
         
end Adam.Common;
