with Ada.Wide_Text_Io;
use Ada.Wide_Text_Io;
with Gnat.Sockets;
use Gnat.Sockets;

with Gnat.Cgi;
use Gnat.Cgi;
with Gnat.Os_Lib;
use Gnat.Os_Lib;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with M;
use M;
with M.Strings;
use M.Strings;
with M.Main_Game;
use M.Main_Game;
with Sky;
use Sky;
procedure Webi is
   
   
   Add  : Gnat.sockets.Sock_Addr_Type;
   Socket   : Socket_Type;
   Channel  : Gnat.sockets.Stream_Access;
   Count : Natural := 0;
   The_Game : M.Main_Game.Main_Game(10);
   
   
   
begin     
   if not Ok then
      raise Program_Error;
   end if;
   Put_Header;
   Put_Line("<!DOCTYPE html>");
   Put_Line("<html>");
   
   Put_Line(" <head>");
   
   Put_Line("   <meta charset=""UTF-8"">");
   Put_Line("   <title>webi</title>");
   
   Put_Line(" </head>");
   Put_Line(" <body>");
   
   
   begin
      Add.Addr :=
	Gnat.Sockets.Addresses (Gnat.Sockets.Get_Host_By_Name ("localhost"), 1);
      
      Add.Port := 1988;
      Gnat.sockets.Create_Socket (Socket);
      delay 0.1;
      --  Gnat.Sockets.Set_Socket_Option
      --  	(Socket,
      --  	 Gnat.Sockets.Socket_Level,
      --  	 (Gnat.Sockets.Reuse_Address, True));      
      --  delay 0.1;      
      Gnat.sockets.Connect_Socket (Socket, Add);
      delay 0.1;
      Channel := Gnat.sockets.Stream (Socket);
      String'Output (Channel, "Products");
      Count := natural'Input(Channel);
      
      if Count /= 0 then
	 
	 
	 begin
	    
	    the_Game.Count := Count;
	    if the_Game.Count /= 0 then
	       for I in 1..Count loop
		  declare
		     Product : constant Product_Access := new Product_Class;
		  begin
		     the_Game.Products(I) := Product;
		     Product.Name := new String ' (To_String(Wide_String'Input(Channel)));
		     Product.Description := new Wide_String ' (Wide_String'Input(Channel));
		     Product.Documentation := new String ' (To_String(Wide_String'Input(Channel)));
		     Product.Unit_Ht := Fixed_Unit_Ht'Input(Channel);
		     Product.TVA_Rate := Fixed_Factor'Input(Channel);
		     Product.TVA := Fixed_Total'Input(Channel);
		     Product.Unit_TTC := Fixed_Unit_Ttc'Input(Channel);
		     
		     

		  exception
		     when others =>
			raise;
		  end;
	       end loop;
	    end if;

	 end;
      end if;
      
   end;

   if Count /= 0 then
      
      
      Put_Line(" <table align=""center"" width=""66%"">");
      
      Put_Line("  <tr>");
      Put_Line("   <td>");
      Put_Line("    <table align=""Left"" width=""100%"">");
      Put_Line("     <tr>");
      Put_Line("      <td>");
      Put_Line("        <table align=""left"" width=""100%"">");
      Put_Line("         <tr>");
      Put_Line("          <td>");
      Put_Line("           <h1>web Engineer</h1>");
      Put_Line("           <h2>Abstract</h2>");
      Put_Line("           Ingéniérie du logiciel avec Ada");
      Put_Line("           <h3>Bonjour !</h3>");
      Put_Line("           <p>");
      
      Put_Line("            Nous sommes impliqués dans l&#39évolution et le progrès de chacun au sein de notre environnement social et culturel.");
      Put_Line("           </p>");
      Put_Line("           <p>");
      Put_Line("            Avec vous, nous espérons répondre à votre attente ; Alors ce jour, chacun mient en contact afin d&#39exposer nos intérêts communs.");
      Put_Line("           </p>");
      Put_Line("<p>");
      Put_Line("Nous sommes une équipe de programmeur ayant pour objectif de mener ou d&#39aider chacun à atteindre leurs propres objectifs.");
      Put_Line("</p>");
      Put_Line("<p>");
      Put_Line("Afin de répondre à votre demande, nous vous prions de répondre à un ensemble de questions.");
      Put_Line("</p>");
      Put_Line("<form action=""/cgi-bin/saiweb"" method=""POST"">");
      Put_Line("<h2>Informations</h2>");
      Put_Line("<p>");
      
      Put_Line("Vos réponses serons enregistrées dans notre entreprise et afin de vous répondre personnellemant, nous vous demanderons de bien vouloir nous informer de votre nom et adresse email ainsi que votre adresse et votre numéro de téléphone :<br>");
      Put_Line("- nom : <textarea rows=""1"" cols=""32"" maxlength=""256"" value="""" id=""name"" name=""name""></textarea><br>");
      Put_Line("- email : <textarea rows=""1"" cols=""48"" maxlength=""256"" value="""" id=""email"" name=""email""></textarea><br>");
      Put_Line("- adresse : <textarea rows=""1"" cols=""64"" maxlength=""256"" value="""" id=""address"" name=""address""></textarea><br>");
      Put_Line("- téléphone : <textarea rows=""1"" cols=""16"" maxlength=""256"" value="""" id=""phone"" name=""phone""></textarea>");
      Put_Line("</p>");
      Put_Line("<p>");
      Put_Line("Merci de remplir le formulaire prévu à cet effet.");
      Put_Line("</p>");
      Put_Line("<p>");
      Put_Line("Si toutesfois vous désirer acquerir un de nos service en ligne, veuillez vous munir de votre carte de paiement.");
      Put_Line("</p>");
      Put_Line("<p>");
      Put_Line("Notre équipe à d&#39hors et déjà développé 4 types de programme et application.");
      Put_Line("<br>");
      Put_Line("Parmis les plus important nous vous communiquons les documentations de quelques un d&#39entre eux :");
      Put_Line("</p>");
      Put_Line("<table border=""1"">");
      for I in 1..the_Game.Count loop
   	 declare
   	    Product : constant Product_Access := the_Game.Products(I);
   	 begin
	    if Product /= null then
	       Put_Line("<tr><td>");
	       if Product.Name /= null then
		  Put_Line("<h3>" & To_Wide_String(Product.Name.all) & "</h3>");
	       end if;
	       Put_Line("<p>");
	       if Product.Description /= null then
		  Put_Line(Product.Description.all);
	       end if;
	       Put_Line("</p>");
	       Put_Line("<h4>Documentation</h4>");
	       if Product.Name /= null and Product.Documentation /= null then
		  Put_Line(To_Wide_String(Product.name.all) & " : " & "<a href=""/" & To_Wide_String(Product.Documentation.all) & """>" & To_Wide_String(Product.Documentation.all) & "</a>");
	       end if;
	       Put_Line("</td></tr>");
	    end if;
   	 end;
      end loop;

      Put_Line("</table>");
      Put_Line("<h1>Commandes</h1>");
      Put_Line("<h2>Programmes</h2>");
      Put_Line("<p>");
      Put_Line("Si vous êtes intéressé par l&#39un ou plusieurs de ces programmes, nous vous invitons à cocher les cases à cocher correspondante :");
      Put_Line("</p>");
      Put_Line("<p>");
      for I in 1..the_Game.Count loop
   	 declare
   	    Product : constant Product_Access := the_Game.Products(I);
   	 begin
   	    Put("- " & To_Wide_String(Product.Name.all) & " : Prix : ");
   	    Put(To_Wide_String(Fixed_Unit_Ht'Image(Product.Unit_Ht)) & "€ HT ; TVA : ");
   	    Put(To_Wide_String(Fixed_Factor'Image(Product.TVA_Rate)) & "% ; Montant TVA : ");
   	    Put(To_Wide_String(Fixed_Total'Image(Product.TVA)) & "€ ; Prix TTC : ");
   	    Put(To_Wide_String(Fixed_Unit_Ttc'Image(Product.Unit_TTC)) & "€.");
   	    Put_Line("<input type=""checkbox"" name=""" & To_Wide_String(Product.Name.all) & """ id=""" & To_Wide_String(Product.Name.all) & """ value=""" & To_Wide_String(Product.Name.all) & """ /><br>");
   	 end;
      end loop;
      Put_Line("</p>");
      Put_Line("<p>");
      Put_Line("Votre adresse de résidence est requise.");
      Put_Line("</p>");
      Put_Line("<h1>Communication</h1>");
      Put_Line("<h2>Audits</h2>");
      Put_Line("<p>");
      Put_Line("Notre equipe est formées de professionnels de la communication et du commerce.");
      Put_Line("</p>");
      Put_Line("<p>");
      Put_Line("Dans le cadre de votre action de communication, nous sommes aussi impliqués dans votre réussite selon votre objectif.");
      Put_Line("</p>");
      Put_Line("<p>");
      Put_Line("Riches de notre usage francophone des expressions et locutions du langage de France, nous pouvons éventuellement concevoir ou améliorer vos messages.");
      Put_Line("</p>");
      Put_Line("<p>");
      Put_Line("Dans le cas où vous seriez intéressé par une prestation concerant une étude de marché ou un audit auprès de vos prospects ou fournisseurs, nous pouvons également concevoir les dîtes études et audits avec vous.<br>");
      Put_Line("</p>");
      Put_Line("<p>");
      Put_Line("Nous vous invitons alors à nous contacter à l&#39adresse email suivante : <a href=""mailto:degirardi.manuel@gmail.com"">contact</a>");
      Put_Line("</p>");
      
      Put_Line("<h2>Logiciel</h2>");
      Put_Line("<p>");
      Put_Line("Pour toutes commandes de logiciel, nous vous demandons de bien vouloir préciser votre objectif, l&#39objet de celui - ci, vos motivations ainsi que les arguments ayants motivés votre commande :");
      Put_Line("</p>");
      Put_Line("<h4>Objectif</h4>");
      Put_Line("<p>");
      
      Put_Line("Il est important ici de préciser les détails du résultat attendu : <br>");
      Put_Line("<br>");
      Put_Line("<textarea rows=""2"" cols=""120"" maxlength=""240"" value="""" id=""objectif"" name=""objectif""></textarea>");
      Put_Line("</p>");
      Put_Line("<h4>Motivations</h4>");
      Put_Line("<p>");
      
      Put_Line("Nous vous demandons de nous informer des avantagess escomptés : <br>");
      Put_Line("<br>");
      Put_Line("<textarea rows=""2"" cols=""120"" maxlength=""240"" value="""" id=""motivations"" name=""motivations""></textarea>");
      Put_Line("</p>");
      Put_Line("<h4>Objet</h4>");
      Put_Line("<p>");
      
      Put_Line("Veuillez préciser le but du dit logiciel : <br>");
      Put_Line("<br>");
      Put_Line("<textarea rows=""2"" cols=""120"" maxlength=""240"" value="""" id=""objet"" name=""objet""></textarea>");
      Put_Line("</p>");
      Put_Line("<h4>Arguments</h4>");
      Put_Line("<p>");
      
      Put_Line("Décrivez les relations de l&#39utilisateur avec l&#39objet évoqué ci - dessus : <br>");
      Put_Line("<br>");
      Put_Line("<textarea rows=""2"" cols=""120"" maxlength=""240"" value="""" id=""arguments"" name=""arguments""></textarea>");
      Put_Line("</p>");
      Put_Line("<p>");
      Put_Line("Votre adresse de résidence ansi que votre adresse email sont requises.");
      Put_Line("</p>");
      Put_Line("<h2>Tarifs</h2>");
      Put_Line("Consuler <a href=""/tarifs.html"">les tarifs</a>");
      Put_Line("<h3>Validation</h3>");
      Put_Line("<p>");
      Put_Line("Notre objectif est de vous fournir un contact et un service à la hauteur de votre ambition ; Afin de véiller à nos relations, nous vous invitions à relire les informations saisient dans ce formulaire avant de valider celui - ci avec le bouton ""Envoyer"".");
      Put_Line("</p>");
      
      Put_Line("<input type=""submit"" value=""Envoyer""> <input type=""reset"" value=""Annuler"">");
      Put_Line("</form>");
      
      
      Put_Line("</td></tr>");
      Put_Line("</table>");
      Put_Line("<a href=""/cgi-bin/webmain"">Retour</a>");
      Put_Line("</body>");

      Put_Line("</html>");
      
   else
      Put_Line("No product"); 
      Put_Line("</body>");
      Put_Line("</html>");
   end if;
	 
   
   
exception
   when Program_Error =>
      Put_Header;
      Put_Line("<!Doctype html>");
      Put_Line("<html>");
      Put_Line("<head>");
      Put_Line("<title>HTTP Error ?</title>");
      Put_Line("</head>");
      Put_Line("<body>");
      Put_Line("This program is an CGI"); 
      Put_Line("</body>");
      Put_Line("</html>");
      Gnat.Sockets.Close_Socket(Socket);
   when others =>
      Gnat.Sockets.Close_Socket(Socket);
end Webi;
