-- procgi is CGI client of proserver written with Ada.
-- Procgi is Copyright (C) 2024  ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-04-30 12:01:15"
-- Version := "0.0.0r"
with Pro ; 
with Pro.Errors ; 
with Pro.Versions ; 
with Pro.Versions.Version_io ; 
with Pro.Parameters ; 
with Pro.Options ; 
with Pro.Interfaces ; 
with Pro.Strings ; 
with Pro.Strings.Buffers ; 
with Pro.Users ; 

with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Fixed;
use Ada.Strings.Fixed;
with Ada.Wide_Text_Io;
with Gnat.Sockets;
use Gnat.Sockets;
with Gnat.MD5;
use Ada;
use Gnat;


with Ada.Text_Io;
use Ada.Text_Io;


with Gnat.Cgi.Cookie;
use Gnat.Cgi;
with Ada.Wide_Text_Io;


with Gnat.Directory_operations;
use Gnat.Directory_operations;
with Gnat.Directory_Operations.Iteration;
use Gnat.Directory_Operations.Iteration;
with gnat.os_lib;
use gnat.os_lib;

with Gnat.Sha1;
use Gnat.Sha1;
with Ada.Streams.Stream_Io;
use Ada.Streams;

with Ada.Characters.Handling;
use Ada.Characters;

procedure Procgi is
   
   
   package Users_Manager is
      
      
      
      function Add_User(Logname : in String;
			Passwd : in Sha1.Message_Digest) return Boolean;
      

      
      function Check_passwd(Logname : in String;
			    Passwd : in Sha1.Message_Digest) return Boolean;
      
      
   private
      
      
      -- User define --
      
      subtype Logname_Type is String (1..64);
      
      
      
      type User_Type is tagged
	 record
	    Logname : Logname_Type := (others => Character ' Val (32)) ;
	    Passwd : Sha1.Message_Digest;
	 end record;                  
      
      procedure Initialize(User : out User_Type;
			   Name : in String);
      -- Get player named "Name".
      
      
      
      procedure Set_Pass(User : in out User_Type;
			 Pass : in Sha1.Message_Digest);
      -- Set password for player.
      
      function Check_Pass(User : in User_Type;
			  Pass : in Sha1.Message_Digest) return Boolean;
      -- Return True is getted password is valid. False else.      
      
      
      
      
   end Users_Manager;
   
   package body Users_Manager is
      
      -- User define --
      procedure Initialize(User : out User_Type;
			   Name : in String) is
	 
      begin
	 User.Logname(1..Name'Length) := Name;
      end Initialize;
      -- Get player named "Name".
      
      procedure Set_Pass(User : in out User_Type;
			 Pass : in Sha1.Message_Digest) is
      begin
	 User.Passwd := Pass;
      end Set_Pass;
      -- Set password for player.
      
      function Check_Pass(User : in User_Type;
			  Pass : in Sha1.Message_Digest) return Boolean is
      begin
	 return User.Passwd = Pass;
      end Check_Pass;
      -- Return True is getted password is valid. False else.      

      
      Users_Filename : constant String_Access := new String ' (".users");
      
      
      function Add_User(Logname : in String;
			Passwd : in Sha1.Message_Digest) return Boolean is

	 Users_File : Stream_Io.File_Type;
	 Users_Stream : Stream_Io.Stream_Access;

	 Old, Current : User_Type;

      begin
	 
	 Initialize(Current, Logname);

	 Set_Pass(Current, Passwd);
	 
	 begin
	    Stream_IO.open(users_File, Stream_Io.In_File, Users_Filename.all);
	    
	    users_stream := Stream_IO.Stream(users_File);
	    while not Stream_Io.End_Of_File(Users_File) loop
	       User_Type'read(Users_Stream, old);
	       if Current.Logname = Old.Logname then
		  Stream_IO.Close(Users_File);
		  return False;
	       end if;
	    end loop;
	    Stream_IO.Close(Users_File);
	 exception
	    when Stream_Io.Name_Error =>
	       Stream_IO.create(users_File, Stream_Io.out_File, Users_Filename.all);
	       Stream_IO.Close(Users_File);
	 end;

	 Stream_IO.open(users_File, Stream_Io.append_File, Users_Filename.all);
	 users_stream := Stream_IO.Stream(users_File);
	 User_Type'write(Users_Stream, Current);
	 Stream_IO.Close(Users_File);
	 return True;
      end add_user;


      function Check_passwd(Logname : in String;
			    Passwd : in Sha1.Message_Digest) return Boolean is
	 Users_File : Stream_Io.File_Type;
	 Users_Stream : Stream_Io.Stream_Access;
	 

	 Old, Current : User_Type;

      begin
	 
	 
	 Initialize(Current, Logname);
	 Set_Pass(Current, Passwd);
	 
	 Stream_IO.open(users_File, Stream_Io.In_File, Users_Filename.all);
	 
	 users_stream := Stream_IO.Stream(users_File);
	 
	 while not Stream_Io.End_Of_File(Users_file) loop
	    User_Type'read(Users_Stream, old);
	    
	    if Current.Logname = Old.Logname then
	       
	       if Check_Pass(Old, passwd) then
		  

		  Stream_IO.Close(Users_File);

		  return True;

	       else

		  Stream_IO.Close(Users_File);
		  return False;
	       end if;
	    end if;
	 end loop;
	 
	 Stream_IO.Close(Users_File);
	 return False;
      exception
	 when others =>
	    return False;
      end Check_passwd;

      
   end Users_Manager;
   
   use Users_Manager;
   
   package W_Io renames Ada.Wide_Text_Io;
   function System(Line : in String) return Integer;
   pragma Import (C, System, "system");
   
   
   Filename : access String;
   Href : access String;
   
   File : File_Type;
   
   Errno : Integer := 0;

   type socket_access is access all socket_type;


   Address  : Gnat.sockets.Sock_Addr_Type;
   Socket   : constant Socket_Access := new Socket_Type;
   Channel  : Gnat.sockets.Stream_Access;
   
   
   
   
   procedure create_htaccess (path : in string; logname : in string) is
      file : file_type;
   begin
      create(file, out_file, path & '/' & ".htaccess");
      put_line(file, "AuthType Basic");
      put_line(file, "AuthName ""Restricted Files""");
      put_line(file, "AuthBasicProvider file");
      put_line(file, "AuthUserFile " & path & "/.htpasswd");
      put_line(file, "Require user " & logname);
   end create_htaccess;
   
   
   
begin
   
   
   if Argument_Count = 2 and then
     Value("logname")'Length /= 0 and then
     Value("password")'Length /= 0 then
      

      if Add_User(Value("logname"),
		  Digest(Value("password"))) or
	Check_Passwd(Value("logname"),
		     Digest(Value("password"))) then
	 
	 
	 begin
	    
	    Change_Dir("/var/www/html/" & Value("logname"));
	    
	    
	 exception
	    when Directory_Error =>
	       Make_Dir("/var/www/html/" & Value("logname"));
	       Errno := System("chmod a+w " & "/var/www/html/" & Value("logname") & Character'Val(0));
	       Change_Dir("/var/www/html/" & Value("logname"));
	       -- create html dir

	       create_htaccess("/var/www/html/" & Value("logname"), Value("logname"));
	       -- add dir/htaccess
	       
	       errno := system("sh -c ""echo " & Value("password") & " | " & "/usr/bin/htpasswd -c -i " & ".htpasswd" & " " & Value("logname") & """" & character'val(0));
	       if Errno /= 0 then
		  Gnat.Cgi.Cookie.Put_Header;
		  W_Io.Put_Line("<!DOCTYPE html>");
	 W_Io.Put_Line("<html>");
	 W_Io.Put_Line("<head>");
	 W_Io.Put_Line("<meta charset=""utf-8"">");
	 W_Io.Put_Line("<title>Program_Error</title>");
	 W_Io.Put_Line("</head>");
	 W_Io.Put_Line("<body>");
	 
	 Put_Line("htpasswd : errno : " & Integer'Image(Errno));
	 W_Io.Put_Line("</body>");
	 W_Io.Put_Line("</html>");
	 raise Program_Error;
	       end if;
	       -- create .htpasswd
	 end;
	 
	 
	 Gnat.Cgi.Cookie.Set(Key     => "logname",
			     Value   => Value("logname"),
			     Domain  => "inconito.net");
	 
	 
	 
	 
	 
	 Gnat.Cgi.Cookie.Put_Header;
	 
	 
	 
	 
	 
	 W_Io.Put_Line("          <table align=""center"" width=""66%"">");
	 W_Io.Put_Line("      ");
	 W_Io.Put_Line("      <tr>");
	 W_Io.Put_Line("<td>");
	 W_Io.Put_Line("  <table align=""left"" width=""22%"">");
	 W_Io.Put_Line(""); 
	 W_Io.Put_Line("    <tr><td>");
	 W_Io.Put_Line("<form action=""/cgi-bin/procgi"" method=""post"">");
	 W_Io.Put_Line("   <table border=""1"">");
	 W_Io.Put_Line("   <tr><td>Name</td><td>Path</td><td>Delete</td></tr>");
	 

	 declare
	    
	    procedure Table_Action
	      (Item  :        String;
	       Index :        Positive;
	       Quit  : in out Boolean) is
	    begin
	       if Base_Name(Item) /= Value("logname") then
		  if Is_Directory(Item) then
		     W_Io.Put_Line("   <tr><td>" & Handling.To_Wide_String(Base_Name(Item)) & "</td><td><a href=""/" & Handling.To_Wide_String(Value("logname")) & '/' & Handling.To_Wide_String(Base_Name(Item)) & '/' & Handling.To_Wide_String(Base_Name(Item)) & ".tgz"">" & 
				     Handling.To_Wide_String(Base_Name(Item)) & ".tgz</a></td><td><input type=""checkbox"" value=""" & Handling.To_Wide_String(Base_Name(Item)) & """ id=""" & 
				     Handling.To_Wide_String(Base_Name(Item)) & """ name=""" & Handling.To_Wide_String(Base_Name(Item)) & """></td></tr>   ");
		  end if;
	       end if;
	    end Table_Action;
	    
	    procedure Iterator is new Wildcard_Iterator (Table_Action);
	 begin
	    Iterator("/var/www/html/" & Value("logname") & "/*");
	 end;

	 
	 
	 W_Io.Put_Line("   </table>");
	 W_Io.Put_Line("   <input type=""reset"" value=""Reset""><input type=""submit"" value=""Submit"">");
	 W_Io.Put_Line("   </form>");
	 W_Io.Put_Line("");   
	 W_Io.Put_Line("    </td></tr>");
	 W_Io.Put_Line("    ");
	 
	 W_Io.Put_Line("    <tr><td>");
	 W_Io.Put_Line("<h1>Quick Start Online</h1>");
	 W_Io.Put_Line("Create your project with GPL hearder.");
	 W_Io.Put_Line("    </td></tr>");
	 W_Io.Put_Line("    <tr><td>");
	 W_Io.Put_Line("<ul>");
	 W_Io.Put_Line("  <li>include GPL header in all files with Copyright.</li>  ");
	 W_Io.Put_Line("  <li>include version.</li>");
	 W_Io.Put_Line("  <li>include date</li>  ");
	 W_Io.Put_Line("  <li>Include line : package PACKAGE_NAME is</li>  ");
	 W_Io.Put_Line("  <li>Include line : end PACKAGE_NAME ;</li>  ");
	 W_Io.Put_Line("</ul>");
	 W_Io.Put_Line("<hr>");
	 W_Io.Put_Line("    </td></tr>");
	 W_Io.Put_Line("    <tr><td>");
	 W_Io.Put_Line("<form action=""/cgi-bin/procgi"" method=""POST"">");
	 W_Io.Put_Line("  <h2>Abstract of program</h2>");
	 W_Io.Put_Line("  Short description of your program.");
	 W_Io.Put_Line("  <textarea rows=""2"" cols=""80"" id=""abstract"" name=""abstract""></textarea>");
	 W_Io.Put_Line("  <h2>Program Name</h2>");
	 W_Io.Put_Line("  The name of your program.<br>");
	 W_Io.Put_Line("  <input type=""text"" minlength=""1"" maxlength=""42"" id=""project_name"" name=""project_name"">");
	 W_Io.Put_Line("  <br>");
	 W_Io.Put_Line("  <h2>Libraries</h2>");
	 W_Io.Put_Line("  Libraries list.");
	 W_Io.Put_Line("  <textarea rows=""8"" cols=""80"" id=""sublist"" name=""sublist""></textarea>");
	 W_Io.Put_Line("  <h2>Version</h2>");	 
	 W_Io.Put_Line("  The version of project<br>");
	 W_Io.Put_Line("  The version is alway 0.0.0r<br>");
	 W_Io.Put_Line("  <input type=""text"" minlength=""5"" maxlength=""12"" id=""version"" name=""version"">");
	 W_Io.Put_Line("  <h2>Authors</h2>");
	 W_Io.Put_Line("  The authors of project<br>");
	 W_Io.Put_Line("  <input type=""text"" minlength=""1"" maxlength=""48"" id=""authors"" name=""authors"">");
	 W_Io.Put_Line("  <input type=""reset"" value=""Reset"">");
	 W_Io.Put_Line("  <input type=""submit"" value=""Send"">");
	 
	 W_Io.Put_Line("  ");
	 W_Io.Put_Line("</form>");
	 W_Io.Put_Line("    </td></tr>    ");
	 W_Io.Put_Line("  </table>");
	 W_Io.Put_Line("</td>");
	 W_Io.Put_Line("      </tr>");
	 W_Io.Put_Line("      <tr><td>End of document</td></tr>");
	 W_Io.Put_Line("    </table>");
	 W_Io.Put_Line("</body>");
	 W_Io.Put_Line("</html>");

	 
	 


	 
      else
	 Put_Header;
	 W_Io.Put_Line("<!DOCTYPE html>");
	 W_Io.Put_Line("<html>");
	 W_Io.Put_Line("<head>");
	 W_Io.Put_Line("<meta charset=""utf-8"">");
	 W_Io.Put_Line("<title>procgi</title>");
	 W_Io.Put_Line("</head>");
	 W_Io.Put_Line("<body>");
	 W_Io.Put_Line("Access denied");
	 W_Io.Put_Line("</body>");
	 W_Io.Put_Line("</html>");
      end if;
      
      
   elsif Argument_Count >= 5 then 
      if Cookie.Count = 1 then
	 if Cookie.Value(Key => "logname")'Length /= 0 then
	    
	    
	    Address.addr := Addresses(Get_Host_By_Name (Host_Name), 1);
	    Address.Port := 7947;
	    
	    
	    
	    if Value("abstract")'Length /= 0 and
	      Value("project_name")'Length /= 0 and
	      Value("sublist")'Length /= 0 and
	      Value("version")'Length /= 0 and
	      Value("authors")'Length /= 0 then
	       
	       
	       
	       
	       
	       Filename := new String ' (Value("project_name") & '-' & Value("version"));
	       --      Put_Line("Ok 1");
	       Href := new String ' (Filename.all & ".tgz");
	       --            Put_Line("Ok 2");
	       Create(File, Out_File, "/var/www/html/" & Cgi.Cookie.Value("logname") &"/" & Filename.all & ".txt");
	       --            Put_Line("Ok 3");
	       Put_Line(File, Value("abstract"));
	       Put(File, Character'Val(10));
	       Put_Line(File, Value("project_name"));
	       Put_Line(File, Value("project_name"));

	       --      Put_Line("Ok 4");
	       declare
		  sublist : constant string := Value("sublist");
	       begin
		  for i in sublist'range loop
		     declare
			char : character := sublist(i);
		     begin
			if char /= character'val(13) then
			   put(file, sublist(i));
			end if;
		     end;
		  end loop;
	       end;
	       --            Put_Line("Ok 5");
	       Put(File, Character'Val(10));
	       Put_Line(File, Value("version"));
	       Put_Line(File, Value("authors"));
	       --            Put_Line("Ok 6");
	       Close(File);
	       CGI.Put_Header;
	       begin
		  Gnat.sockets.Create_Socket (Socket.all);
		  delay 0.2;
		  Gnat.Sockets.Set_Socket_Option
		    (Socket.all,
		     Gnat.Sockets.Socket_Level,
		     (Gnat.Sockets.Reuse_Address, True));
		  --            Put_Line("Ok 7");
		  Gnat.sockets.Connect_Socket (Socket.all, Address);
		  delay 0.2;
		  Channel := Gnat.sockets.Stream (Socket.all);

	       exception
		  when others =>
		     Put_Header;
		     Text_IO.Put_Line ("<html><body>< ... Server error... >");
	       end;
	       --      Put_Line("Ok 8");
	       Wide_String'Output(Channel, "hello");
	       --      Put_Line("Ok 9");
	       String'output(Channel, filename.all);
	       String'output(Channel, Value("project_name"));
	       String'output(Channel, Value("version"));
	       String'output(Channel, Cgi.Cookie.Value("logname"));
	       --            Put_Line("Ok 10");
	       

	       declare
		  line : wide_string := Wide_String'Input(Channel);
	       begin
		  null;
	       end;
	       delay 5.0;
	       Put_Header;
	       W_Io.Put_Line("<!DOCTYPE html>");
	       W_Io.Put_Line("<html>");
	       W_Io.Put_Line("<head>");
	       W_Io.Put_Line("<meta charset=""utf-8"">");
	       W_Io.Put_Line("<title>procgi</title>");
	       W_Io.Put_Line("</head>");
	       W_Io.Put_Line("<body>");
	       
	       
	       
	       
	       
	       
	       
	       
	       W_Io.Put_Line("          <table align=""center"" width=""66%"">");
	       W_Io.Put_Line("      ");
	       W_Io.Put_Line("      <tr>");
	       W_Io.Put_Line("<td>");
	       W_Io.Put_Line("  <table align=""left"" width=""22%"">");
	       W_Io.Put_Line("    ");
	       W_Io.Put_Line(""); 
	       W_Io.Put_Line("    <tr><td>");
	       
	       W_Io.Put_Line("<form action=""/cgi-bin/procgi"" method=""post"">");
	       W_Io.Put_Line("   <table border=""1"">");
	       W_Io.Put_Line("   <tr><td>Name</td><td>Path</td><td>Delete</td></tr>");
	       
	       
	       declare
		  
		  procedure Table_Action
		    (Item  :        String;
		     Index :        Positive;
		     Quit  : in out Boolean) is
		  begin
		     if Base_Name(Item) /= Cgi.Cookie.Value("logname") then
			if Is_Directory(Item) then
			   W_Io.Put_Line("   <tr><td>" & Handling.To_Wide_String(Base_Name(Item)) & "</td><td><a href=""/" & Handling.To_Wide_String(Cgi.Cookie.Value("logname")) & '/' & Handling.To_Wide_String(Base_Name(Item)) & '/' & Handling.To_Wide_String(Base_Name(Item)) & ".tgz"">" & 
					   Handling.To_Wide_String(Base_Name(Item)) & ".tgz</a></td><td><input type=""checkbox"" value=""" & Handling.To_Wide_String(Base_Name(Item)) & """ id=""" & 
					   Handling.To_Wide_String(Base_Name(Item)) & """ name=""" & Handling.To_Wide_String(Base_Name(Item)) & """></td></tr>   ");
			end if;
		     end if;
		  end Table_Action;
		  
		  procedure Iterator is new Wildcard_Iterator (Table_Action);
	       begin
		  Iterator("/var/www/html/" & Cgi.Cookie.Value("logname") & "/*");
	       end;
	       
	       
	       W_Io.Put_Line("   </table>");
	       W_Io.Put_Line("   <input type=""reset"" value=""Reset""><input type=""submit"" value=""Submit"">");
	       W_Io.Put_Line("   </form>");
	       W_Io.Put_Line("");   
	       
	       
	       --  Put_Line("   <h1>Download</h1>");
	       --  Put_Line("   <a href=""/quickstart/" & filename.all & "/" & Href.all & """>"  & href.all & "</a> Click to download<br>");
	       Put_Line("   <h2>Extract files</h2>");
	       Put_Line("   mkdir PROJECT_NAME-VERSION<br>");
	       Put_Line("   cd PROJECT_NAME-VERSION<br>");
	       Put_Line("   tar -x -v -z -f PROJECT_NAME-VERSION.tgz");
	       Put_Line("   <h2>Archive project</h2>");
	       Put_Line("   make head tail arch<br>");
	       W_Io.Put_Line("    </td></tr>");
	       W_Io.Put_Line("    <tr><td>");
	       W_Io.Put_Line("<h1>Quick Start Online</h1>");
	       W_Io.Put_Line("Create your project with GPL hearder.");
	       W_Io.Put_Line("    </td></tr>");
	       W_Io.Put_Line("    <tr><td>");
	       W_Io.Put_Line("<ul>");
	       W_Io.Put_Line("  <li>include GPL header in all files with Copyright.</li>  ");
	       W_Io.Put_Line("  <li>include version.</li>");
	       W_Io.Put_Line("  <li>include date</li>  ");
	       W_Io.Put_Line("  <li>Include line : package PACKAGE_NAME is</li>  ");
	       W_Io.Put_Line("  <li>Include line : end PACKAGE_NAME ;</li>  ");

	       W_Io.Put_Line("</ul>");
	       W_Io.Put_Line("<hr>");
	       W_Io.Put_Line("    </td></tr>");
	       W_Io.Put_Line("    <tr><td>");
	       W_Io.Put_Line("<form action=""/cgi-bin/procgi"" method=""POST"">");
	       W_Io.Put_Line("  <h2>Abstract of program</h2>");
	       W_Io.Put_Line("  Short description of your program.");
	       W_Io.Put_Line("  <textarea rows=""2"" cols=""80"" id=""abstract"" name=""abstract""></textarea>");
	       W_Io.Put_Line("  <h2>Program Name</h2>");
	       W_Io.Put_Line("  The name of your program.<br>");
	       W_Io.Put_Line("  <input type=""text"" minlength=""1"" maxlength=""42"" id=""project_name"" name=""project_name"">");
	       W_Io.Put_Line("  <br>");
	       W_Io.Put_Line("  <h2>Libraries</h2>");
	       W_Io.Put_Line("  Libraries list.");
	       W_Io.Put_Line("  <textarea rows=""8"" cols=""80"" id=""sublist"" name=""sublist""></textarea>");
	       W_Io.Put_Line("  <h2>Version</h2>");
	       W_Io.Put_Line("  The version of project<br>");
	       W_Io.Put_Line("  <input type=""text"" minlength=""5"" maxlength=""12"" id=""version"" name=""version"">");
	       W_Io.Put_Line("  <h2>Authors</h2>");
	       W_Io.Put_Line("  The authors of project<br>");
	       W_Io.Put_Line("  <input type=""text"" minlength=""1"" maxlength=""48"" id=""authors"" name=""authors"">");
	       W_Io.Put_Line("  <input type=""reset"" value=""Reset"">");
	       W_Io.Put_Line("  <input type=""submit"" value=""Send"">");
	       
	       W_Io.Put_Line("  ");
	       W_Io.Put_Line("</form>");
	       W_Io.Put_Line("    </td></tr>    ");
	       W_Io.Put_Line("  </table>");
	       W_Io.Put_Line("</td>");
	       W_Io.Put_Line("      </tr>");
	       W_Io.Put_Line("      <tr><td>End of document</td></tr>");
	       W_Io.Put_Line("    </table>");

	       
	       
	             Put_Line(" </body>");
      Put_Line("</html>");	    
	       
	    end if;
	 end if;
      end if;
   elsif Value("abstract")'Length = 0 and
     Value("project_name")'Length = 0 and
     Value("sublist")'Length = 0 and
     Value("version")'Length = 0 and
     Value("authors")'Length = 0 then
      
      if Cookie.Count = 1 then
	 --  declare
	    
	 --     procedure Table_Action
	 --       (Item  :        String;
	 --        Index :        Positive;
	 --        Quit  : in out Boolean) is
	 --     begin
	       
	 --        if Base_Name(Item) /= Cookie.Value("logname") then
	 --  	  if Is_Directory(Item) then
	 --  	     Put_Line("Value =" & Value("value") & " et base name (item) = " & Base_Name(Item) & "<br>");
	 --  	     if Value("value") = Base_Name(Item) then
	 --  		Put_Line("match<br>");
	 --  		Errno := System("rm -rf " & Item & Character'Val(0));
	 --  		Errno := System("rm -f " & Item & ".txt" & Character'Val(0));
	 --  	     end if;
	 --  	  end if;
	 --        end if;
	 --     end Table_Action;
	    
	 --     procedure Iterator is new Wildcard_Iterator (Table_Action);
	 --  begin
	 --     Iterator("/var/www/html/" & Cookie.Value("logname") & "/*");
	    
	 --  end;
	 
	 declare
	    procedure Action     
	      (Key      : String;
	       Value    : String;
	       Position : Positive;
	       Quit     : in out Boolean) is
	    begin
	       
	       Errno := System("rm -r " & "/var/www/html/" & Cookie.Value("logname") & "/" & Cgi.Key(Position) & Character'Val(0));
	       Errno := System("rm -f " & "/var/www/html/" & Cookie.Value("logname") & "/" & Cgi.Key(Position)  & ".txt" & Character'Val(0));	    	       
	    end Action;
	    
	    procedure Iteration is new For_Every_Parameter(Action);
	    
	 begin
	    Iteration;
	    Put_Header;
	       W_Io.Put_Line("<!DOCTYPE html>");
	       W_Io.Put_Line("<html>");
	       W_Io.Put_Line("<head>");
	       W_Io.Put_Line("<meta charset=""utf-8"">");
	       W_Io.Put_Line("<title>procgi</title>");
	       W_Io.Put_Line("</head>");
	       W_Io.Put_Line("<body>");
	       
	       
	       
	       
	       
	       
	       
	       
	       W_Io.Put_Line("          <table align=""center"" width=""66%"">");
	       W_Io.Put_Line("      ");
	       W_Io.Put_Line("      <tr>");
	       W_Io.Put_Line("<td>");
	       W_Io.Put_Line("  <table align=""left"" width=""22%"">");
	       W_Io.Put_Line("    ");
	       W_Io.Put_Line(""); 
	       W_Io.Put_Line("    <tr><td>");

	       W_Io.Put_Line("<form action=""/cgi-bin/procgi"" method=""post"">");
	       W_Io.Put_Line("   <table border=""1"">");
	       W_Io.Put_Line("   <tr><td>Name</td><td>Path</td><td>Delete</td></tr>");
	       
	       
	       declare
		  
		  procedure Table_Action
		    (Item  :        String;
		     Index :        Positive;
		     Quit  : in out Boolean) is
		  begin
		     if Base_Name(Item) /= Cgi.Cookie.Value("logname") then
			if Is_Directory(Item) then
			   W_Io.Put_Line("   <tr><td>" & Handling.To_Wide_String(Base_Name(Item)) & "</td><td><a href=""/" & Handling.To_Wide_String(Cgi.Cookie.Value("logname")) & '/' & Handling.To_Wide_String(Base_Name(Item)) & '/' & Handling.To_Wide_String(Base_Name(Item)) & ".tgz"">" & 
					   Handling.To_Wide_String(Base_Name(Item)) & ".tgz</a></td><td><input type=""checkbox"" value=""" & Handling.To_Wide_String(Base_Name(Item)) & """ id=""" & 
					   Handling.To_Wide_String(Base_Name(Item)) & """ name=""" & Handling.To_Wide_String(Base_Name(Item)) & """></td></tr>   ");
			end if;
		     end if;
		  end Table_Action;
		  
		  procedure Iterator is new Wildcard_Iterator (Table_Action);
	       begin
		  Iterator("/var/www/html/" & Cgi.Cookie.Value("logname") & "/*");
	       end;
	       
	       
	       W_Io.Put_Line("   </table>");
	       W_Io.Put_Line("   <input type=""reset"" value=""Reset""><input type=""submit"" value=""Submit"">");
	       W_Io.Put_Line("   </form>");
	       W_Io.Put_Line("");   
	       
	       
	       --  Put_Line("   <h1>Download</h1>");
	       --  Put_Line("   <a href=""/quickstart/" & filename.all & "/" & Href.all & """>"  & href.all & "</a> Click to download<br>");
	       Put_Line("   <h2>Extract files</h2>");
	       Put_Line("   mkdir PROJECT_NAME-VERSION<br>");
	       Put_Line("   cd PROJECT_NAME-VERSION<br>");
	       Put_Line("   tar -x -v -z -f PROJECT_NAME-VERSION.tgz");
	       Put_Line("   <h2>Archive project</h2>");
	       Put_Line("   make head tail arch<br>");
	       W_Io.Put_Line("    </td></tr>");
	       W_Io.Put_Line("    <tr><td>");
	       W_Io.Put_Line("<h1>Quick Start Online</h1>");
	       W_Io.Put_Line("Create your project with GPL hearder.");
	       W_Io.Put_Line("    </td></tr>");
	       W_Io.Put_Line("    <tr><td>");
	       W_Io.Put_Line("<ul>");
	       W_Io.Put_Line("  <li>include GPL header in all files with Copyright.</li>  ");
	       W_Io.Put_Line("  <li>include version.</li>");
	       W_Io.Put_Line("  <li>include date</li>  ");
   	       W_Io.Put_Line("  <li>Include line : package PACKAGE_NAME is</li>  ");
	       W_Io.Put_Line("  <li>Include line : end PACKAGE_NAME ;</li>  ");

	       W_Io.Put_Line("</ul>");
	       W_Io.Put_Line("<hr>");
	       W_Io.Put_Line("    </td></tr>");
	       W_Io.Put_Line("    <tr><td>");
	       W_Io.Put_Line("<form action=""/cgi-bin/procgi"" method=""POST"">");
	       W_Io.Put_Line("  <h2>Abstract of program</h2>");
	       W_Io.Put_Line("  Short description of your program.");
	       W_Io.Put_Line("  <textarea rows=""2"" cols=""80"" id=""abstract"" name=""abstract""></textarea>");
	       W_Io.Put_Line("  <h2>Program Name</h2>");
	       W_Io.Put_Line("  The name of your program.<br>");
	       W_Io.Put_Line("  <input type=""text"" minlength=""1"" maxlength=""42"" id=""project_name"" name=""project_name"">");
	       W_Io.Put_Line("  <br>");
	       W_Io.Put_Line("  <h2>Libraries</h2>");
	       W_Io.Put_Line("  Libraries list.");
	       W_Io.Put_Line("  <textarea rows=""8"" cols=""80"" id=""sublist"" name=""sublist""></textarea>");
	       W_Io.Put_Line("  <h2>Version</h2>");
	       W_Io.Put_Line("  The version of project<br>");
	       W_Io.Put_Line("  <input type=""text"" minlength=""5"" maxlength=""12"" id=""version"" name=""version"">");
	       W_Io.Put_Line("  <h2>Authors</h2>");
	       W_Io.Put_Line("  The authors of project<br>");
	       W_Io.Put_Line("  <input type=""text"" minlength=""1"" maxlength=""48"" id=""authors"" name=""authors"">");
	       W_Io.Put_Line("  <input type=""reset"" value=""Reset"">");
	       W_Io.Put_Line("  <input type=""submit"" value=""Send"">");
	       
	       W_Io.Put_Line("  ");
	       W_Io.Put_Line("</form>");
	       W_Io.Put_Line("    </td></tr>    ");
	       W_Io.Put_Line("  </table>");
	       W_Io.Put_Line("</td>");
	       W_Io.Put_Line("      </tr>");
	       W_Io.Put_Line("      <tr><td>End of document</td></tr>");
	       W_Io.Put_Line("    </table>");
	             Put_Line(" </body>");
      Put_Line("</html>");
	 end ;
      else
	 
	 
	 W_Io.Put_Line("Cookie not found");
	 
	 
      end if;	    
      

      W_Io.Put_Line("</body>");
      W_Io.Put_Line("</html>");
   elsif Value("abstract")'Length = 0 then

      Put_Header;
      Put_Line("<!DOCTYPE html>");
      Put_Line("<html>");
      Put_Line(" <head>");
      Put_Line("  <title>");
      Put_Line("  Quickstart");
      Put_Line("  </title>");
      Put_Line(" </head>");
      Put_Line(" <body>");
      Put_Line("  Abstract is empty");
      Put_Line(" </body>");
      Put_Line("</html>");
   elsif Value("project_name")'Length = 0 then
      Put_Header;
      Put_Line("<!DOCTYPE html>");
      Put_Line("<html>");
      Put_Line(" <head>");
      Put_Line("  <title>");
      Put_Line("  Quickstart");
      Put_Line("  </title>");
      Put_Line(" </head>");
      Put_Line(" <body>");
      Put_Line("  Project Name is empty");
      Put_Line(" </body>");
      Put_Line("</html>");
   elsif Value("sublist")'Length = 0 then
      Put_Header;
      Put_Line("<!DOCTYPE html>");
      Put_Line("<html>");
      Put_Line(" <head>");
      Put_Line("  <title>");
      Put_Line("  Quickstart");
      Put_Line("  </title>");
      Put_Line(" </head>");
      Put_Line(" <body>");
      Put_Line("  Sublist is empty");
      Put_Line(" </body>");
      Put_Line("</html>");
   elsif Value("version")'Length = 0 then
      Put_Header;
      Put_Line("<!DOCTYPE html>");
      Put_Line("<html>");
      Put_Line(" <head>");
      Put_Line("  <title>");
      Put_Line("  Quickstart");
      Put_Line("  </title>");
      Put_Line(" </head>");
      Put_Line(" <body>");
      Put_Line("  Version is empty");
      Put_Line(" </body>");
      Put_Line("</html>");
   elsif Value("authors")'Length = 0 then
      Put_Header;
      Put_Line("<!DOCTYPE html>");
      Put_Line("<html>");
      Put_Line(" <head>");
      Put_Line("  <title>");
      Put_Line("  Quickstart");
      Put_Line("  </title>");
      Put_Line(" </head>");
      Put_Line(" <body>");
      Put_Line("  Authors is empty");
      Put_Line(" </body>");
      Put_Line("</html>");
      

   else
      Put_Header;
      W_Io.Put_Line("<!DOCTYPE html>");
      W_Io.Put_Line("<html>");
      W_Io.Put_Line("<head>");
      W_Io.Put_Line("<meta charset=""utf-8"">");
      W_Io.Put_Line("<title></title>");
      W_Io.Put_Line("</head>");
      W_Io.Put_Line("<body>");
      W_Io.Put_Line("<a href=""/procgi.html"">Retour</a>");      
      W_Io.Put_Line("</body>");
      W_Io.Put_Line("</html>");
   end if;
end Procgi ; 
