-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-09-28 00:37:02 ; 
-- Version := 0.18.0a ; 
with M ; 
with M.Errors ; 
with M.Parameters ; 
with M.Options ; 
with M.Versions;
with M.Versions.Version_Io;
with M.Enums ; 
with M.Types ; 
with M.Interfaces ; 
with M.Agence ;
with M.Ansi.Console ;
with M.Ansi.Windows ;
with M.Windows ;
with M.Shared ;
with M.Account;
with M.Accounts_Manager;
use M.Account;
use M.Accounts_Manager;
with Ada.Wide_Text_Io ;
with Ada.Characters.Handling ;
with Ada.Text_Io;
use Ada;
with Ada.Strings.Wide_Fixed;
use Ada.Strings.Wide_Fixed;
with Ada.Calendar;
with Ada.Calendar.Formatting;

use Ada.Calendar;
with Gnat.Os_Lib;
with Gnat.Directory_Operations;
use Gnat.Directory_Operations;
with M.Logs;
with M.Balance;
with Sky;
with M.Projects_Manager;
use M.Projects_Manager;
with M.Accountant;
with Sky.Stocks_Manager;
with M.Project;
with M.WOPR;
with M.Servers;

with El.Lexics;
with El.Hander;
use El;
with M.Engineering;

procedure Main is
   
   use M.Accounts_Manager.Operation_Vectors;
   
   use M ; 
   use M.Errors ; 
   use M.Parameters ; 
   
   use M.Versions;
   
   use M.Interfaces ; 
   use M.Shared ;
   use M.Ansi.Console ;
   
   
   
   use Ada.Characters ;
   use Gnat.Os_Lib;
   
   use M.Logs;
   use Sky;
   use M.Accountant;
   use Sky.Stocks_Manager;
   use M.Project;
   
   package W_Io renames Ada.Wide_Text_Io;
   
   
   File : Wide_Text_Io.File_Type;
   Last : Natural := 1;
   Next : Natural := 1;
   
   
   Lines : M.Line_Range := 67;
   Columns : M.Column_Range := 240;
   The_Style : M.Style_Enum := M.Color_And_Color;
   Mode : M.Mode_Enum := M.None;
   End_Of_Program : Boolean := False;
   Errno : Integer := 0;
   Int : Interface_Record;
   Max_Words : Natural := 1023;
begin
   
   Initialize(Int);

   declare
      
      Help_Parameter : constant Parameters.Parameter_Record :=
	Get_Parameter(Int, Help);
      Version_Parameter : constant Parameters.Parameter_Record :=
	Get_Parameter(Int, M.Version);
      
      Initialize_Parameter : constant Parameters.Parameter_Record :=
	Get_Parameter(Int, Initialize);
      
      Geometry_Parameter : constant Parameters.Parameter_Record :=
      	Get_Parameter(Int, Geometry);
      
      Style_Parameter : constant Parameters.Parameter_Record :=
      	Get_Parameter(Int, Style);
      
      Total_Parameter : constant Parameters.Parameter_Record :=
	Get_Parameter(Int, Total);
   begin
      
      Text_Io.Put_Line("Going to set parameters...");
      if Help_Parameter.Is_Setted then
	 Interfaces.Parameters_Descriptions(Int);

	 M.WOPR.Message_Box.Halt;



	 return;
      else
	 if Version_Parameter.Is_Setted then
	    Text_Io.Put_Line(Versions.Version_Io.To_String(Versions.Version));
	    M.WOPR.Message_Box.Halt;
	    


	    return;
	 end if;	    
      end if;
      Interfaces.Print_Parameters(Int);
      
      if Initialize_Parameter.Is_Setted then
	 Total_Sum := Total_Type'Value(Handling.To_String(Initialize_Parameter.Value.all));

      M.WOPR.Message_Box.Halt;


	 
	 return;
      end if;


      if Total_Parameter.Is_Setted then
	 Text_Io.Put_Line(Total_Type'Image(Total_Sum));

      M.WOPR.Message_Box.Halt;


	 
	 return;
      end if;

      if Geometry_Parameter.Is_Setted then
	 Lines := Lines_Number(Geometry_Parameter.Value.all);
	 Columns := Columns_Number(Geometry_Parameter.Value.all);
      end if;

      if Style_Parameter.Is_Setted then
	 begin
	    The_style := Style_Enum'value(Handling.To_String(Style_Parameter.Value.all));
	 exception
	    when others =>
	       Text_Io.Put_Line("Style error : not an style");
	       raise;
	 end;
      end if;

      
      
      
   end;
   
   Text_Io.Put_Line("Going to make Agence...");
   
   declare
      
      subtype Word_Type is Lexical_Range range 0..Max_words;
      
      package Words_Glossary is new Lexics.Glossary(Word_Type);
      use Words_Glossary;
      Words            : Glossary_Type;
   begin
      
      declare
      
	 package hander is new El.hander 
	   (
	    Glossary_Filename => "glossary.txt",
	    Width_Line => 80,
	    Max_Words => Max_words,
	    Samples_Max => 144,
	    Network_Filename => "elhoim",
	    Word_Type => Word_Type,
	    Glossary => Words_Glossary
	   );
	 
	 
	 use Projects_Manager.Projects_Dll;
	 package Ansi_Windows is new M.Ansi.Windows (Lines, Columns);
	 package Windows is new M.Windows (Lines, Columns, The_Style, Ansi_Windows);	 
	 package Main_Agence is new M.Agence (Ansi_Windows, Windows, Hander, Words_Glossary);
	 use Main_Agence;
	 use M;
	 use Hander;
	 use Main_Agence.Servers;
	 
	 
      begin
	 Game_Restore;
	 delay 2.0;
	 Server.Initialize;
	 
	 Server.Start;
      
	 
	 App.Started := True;
	 App.Lines := Lines;
	 App.Columns := Columns;
	 
	 Functions := (0 => new None_Record(App'Access),
		       1 => new Organizer_Record(App'Access),
		       2 => new Vbrain_Record(App'Access),
		       3 => new Planning_Record(App'Access),
		       4 => new Manager_Record(App'Access),
		       5 => new Moneybox_Record(App'Access),
		       6 => new Activity_Record(App'Access),
		       7 => new Stocks_Record(App'Access),
		       8 => new Bank_Record(App'Access),
		       9 => new Logs_Record(App'Access),
		       10 => new Menu_Record(App'Access),
		       11 => new Contacts_Record(App'Access),
		       12 => new Library_Record(App'Access), 
		       13 => new Master_Record(App'Access),
		       14 => new Engine_Record(App'Access),
		       15 => new Computer_Record(App'Access),
		       16 => new WOPR_Record(App'Access),
		       17 => new Workstation_Record(App'Access),
		       18 => new Space_Fighter_Record(App'Access),
		       19 => new Person_Record(App'Access),
		       20 => new World_Record(App'Access),
		       others => null);
	 
	 Text_Io.Put_Line("Going to Term initialization...");
	 begin

	    App.Term := M.Term_Enum'Value(Getenv("TERM").all);
	 exception
	    when Constraint_Error =>	 
	       App.Term := fvwm;
	 end;

	 begin
	    Make_Dir("Archives");
	 exception
	    when others =>
	       begin
	 	  Change_Dir("Archives");
	 	  Change_Dir("..");
	       exception
	 	  when others =>
	 	     raise Spec_Error;
	       end;
	       
	 end;

	 Text_Io.Put_Line("Going to restore Organizer...");
	 if Is_Regular_File(Organizer_Filename) then
	    Restore(App.Terminal, Organizer_Filename);
	 end if;

	 Text_Io.Put_Line("Going to set App.Initialized...");
	 if Balance.Initialized or (Balance.Balance.Capital > 0.0) then
	    App.Initialized := True;
	 end if;

	 Text_Io.Put_Line("initialized");
	 Text_Io.Put_Line("Going to restore Billed...");
	 if Is_Regular_File("billed.txt") then
	    Invoices_Restore(Accounts.Billed, Accounts.Invoice_Last, "billed.txt");
	 end if;

	 Text_Io.Put_Line("Going to restore Charged...");
	 if Is_Regular_File("charged.txt") then
	    Outvoices_Restore(Accounts.Charges, Accounts.Outvoice_Last, "charged.txt");
	 end if;


	 Text_Io.Put_Line("Going to set App.Initialized...");
	 if Balance.Created or (Balance.Main_Balance.Capital > 0.0) then
	    App.Created := True;
	 end if;
	 --Text_Io.Put_Line("initialized");
	 Text_Io.Put_Line("Going to restore Billed...");
	 if Is_Regular_File("main_billed.txt") then
	    Invoices_Restore(Main_Accounts.Billed, Main_Accounts.Invoice_Last, "main_billed.txt");
	 end if;

	 Text_Io.Put_Line("Going to restore Charged...");
	 if Is_Regular_File("main_charged.txt") then
	    Outvoices_Restore(Main_Accounts.Charges, Main_Accounts.Outvoice_Last, "main_charged.txt");
	 end if;

	 
	 
	 
	 Text_Io.Put_Line("Loading stocks...");
	 Stocks_Restore;
	 Text_Io.Put_Line("Done.");

	 ---------------------------------------------
	 --                Bank
	 Wide_Text_Io.Open(File, Wide_Text_Io.In_File, Bank_Filename, Form => "WCEM=8");
	 while not Wide_Text_Io.End_Of_File(File) loop
	    declare
	       Line : Wide_String := Wide_Text_Io.Get_Line(File);
	       Op   : Operation_Record;
	    begin
	       Next := Index(Line, "" & Wide_Character'Val(9));
	       Op.Label := new Wide_String ' (Line(Line'First..Next-1));
	       Last := Next + 1;
	       Next := Index(Line, "" & Wide_Character'Val(9), last);
	       Op.Date_Op := Formatting.Value(Handling.To_String(Line(Last..Next-1)));
	       Last := Next + 1;
	       Next := Index(Line, "" & Wide_Character'Val(9), Last);
	       Op.Date_Val := Formatting.Value(Handling.To_String(Line(Last..Next-1)));
	       Last := Next + 1;
	       Op.sum := Sum_Range'Value(Handling.To_String(Line(Last..Line'last)));
	       App.Bank.List := App.Bank.List & Op;
	       App.Bank.Total := App.Bank.Total + Op.Sum;
	    end;
	 end loop;
	 Wide_Text_Io.Close(File);
	 
	 if Is_Regular_File("Projects.lst") then
	    Text_Io.Put_Line("Loading Projects.lst..");
	    Projects_Manager.Manager_Load(App.Projects, "Projects.lst");
	    Text_Io.Put_Line("Done.");
	 end if;
	 if Is_Regular_File("Archives/Projects.lst") then
	    Text_Io.Put_Line("Loading Archives/Projects.lst..");
	    Projects_Manager.Archives_Load(App.Archives, "Archives/Projects.lst");      
	    Text_Io.Put_Line("Done.");
	 end if;
	 
	 ------------------------------------------------
	 --  Logs
	 if Is_Regular_File(M.Logs.Log_Filename) then
	    M.Logs.Restore(App.logs, M.Logs.Log_Filename);
	 end if;
	 
	 
	 
	 Append(App.Projects.List, new Project_Record ' (Null_Project));
	 Text_Io.Put_Line("Initialise CPU...");
	 Cpu_Process.Initialize;
	 
	 Text_Io.Put_Line("CPU ok!");
	 
	 App.Console.Initialize;
	 
	 Text_Io.Put_Line("Console ok!");
	 
	 App.Console.Switch(Manager);
	 App.Console.Switch(Menu);
	 
	 
	 
	 
	 loop
	    
	    declare
	       Wchar : Wide_Character := Wide_Character ' Val(0);
	    begin
	       case App.Term is
		  when M.Linux =>

		     begin
			App.Console.Mode(Mode);
			W_Io.Get_Immediate(Wchar);
			--Matrix_Saver.Suspend;
			case Wchar is
			   when Wide_Character'Val(27) =>                                       
			      App.Console.Set_On_Esc(True);
			      W_Io.Get_Immediate(Wchar);         
			      case Wchar is
				 when Wide_Character'Val(27) =>                             
				    
				    
				    case Mode is                                                            
				       when Organizer .. Log =>
					  
					  App.Console.Reset;      

				       when None =>
					  
					  App.Console.Set_On_Esc(False);

					  App.Console.Switch(Quit);  


					  End_Of_Program := True;
					  
					  
				       when Menu =>
					  
					  App.Console.Set_On_Esc(False);
					  M.Ansi.Console.Clear_Screen;
					  App.Console.Switch(none);


					  End_Of_Program := True;
					  
					  
				       when others =>
					  if End_Of_Program then         
					     
					     --App.Console.Switch(Quit);

					     App.Console.Halt;

					     exit;
					  end if;
				    end case;                          
				 when others =>
				    App.Console.Mode(Mode);
				    case Mode is
				       
				       when Quit =>
					  if End_Of_Program then         
					     
					     --App.Console.Switch(Quit);

					     App.Console.Halt;

					     exit;
					  end if;
					  
				       when others =>
					  
					  App.Console.Set_On_Esc(False);
					  
					  --App.Console.Switch(mode);
					  End_Of_Program := False;

				    end case;
			      end case;                     
			      
			      case Wchar is
				 when Wide_Character'Val(91) =>                           
				    W_Io.Get_Immediate(Wchar);                           
				    App.Console.Set_On_Esc(False);                           
				    case Wchar is
				       when Wide_Character'Val(49) =>
					  W_Io.Get_Immediate(Wchar);                
					  case Wchar is
					     when Wide_Character'Val(55) =>
						null;--  Text_Io.Put_Line(" -- F6");
						App.Console.Switch(Activity);
						W_Io.Get_Immediate(Wchar);                  
					     when Wide_Character'Val(56) =>
						null;--  Text_Io.Put_Line(" -- F7");
						App.Console.Switch(Stocks);
						W_Io.Get_Immediate(Wchar);                  
					     when Wide_Character'Val(57) =>
						null;--  Text_Io.Put_Line(" -- F8");
						App.Console.Switch(Bank);
						W_Io.Get_Immediate(Wchar);                  
					     when Wide_Character'Val(126) =>                     
						null;--  Text_Io.Put_Line(" -- begin");
						App.Console.Begin_Of;
					     when others =>
						null;
					  end case;                      
				       when Wide_Character'Val(50) =>                    
					  W_Io.Get_Immediate(Wchar);
					  case Wchar is
					     when Wide_Character'Val(48) =>
						null;--  Text_Io.Put_Line(" -- F9");
						App.Console.Switch(Log);
						W_Io.Get_Immediate(Wchar);
					     when Wide_Character'Val(49) =>
						null;--  Text_Io.Put_Line(" -- F10");
						App.Console.Switch(Menu);

						W_Io.Get_Immediate(Wchar);                                       
					     when Wide_Character'Val(51) =>                                  
						null;--  Text_Io.Put_Line(" -- F11");
						App.Console.Switch(Contacts);
						W_Io.Get_Immediate(Wchar);
					     when Wide_Character'Val(52) =>
						null;--  Text_Io.Put_Line(" -- F12");
						App.Console.Switch(Library);
						W_Io.Get_Immediate(Wchar);
					     when Wide_Character'Val(53) =>                            
						null;  W_Io.Put_Line(" -- Maj+F1");
						App.Console.Switch(Navigation);
						W_Io.Get_Immediate(Wchar);
					     when Wide_Character'Val(54) =>                            
						null;  W_Io.Put_Line(" -- Maj+F2");
						App.Console.Switch(Engineer);
						W_Io.Get_Immediate(Wchar);
					     when Wide_Character'Val(56) =>                            
						null;  W_Io.Put_Line(" -- Maj+F3");
						W_Io.Get_Immediate(Wchar);
						App.Console.Switch(Agent);
					     when Wide_Character'Val(57) =>
						null;  W_Io.Put_Line(" -- Maj+F4");
						W_Io.Get_Immediate(Wchar);
						App.Console.Switch(Admin);
					     when Wide_Character'Val(126) =>
						null;--  Text_Io.Put_Line(" -- insert");                                
					     when others =>
						null;                             
					  end case;                               
				       when Wide_Character'Val(51) =>                    					  
					  W_Io.Get_Immediate(Wchar);
					  case Wchar is
					     when Wide_Character'Val(49) => -- Maj+F5
						App.Console.Switch(Terminator);
						W_Io.Get_Immediate(Wchar);   
					     when Wide_Character'Val(50) => -- Maj+F6
						App.Console.Switch(Joshua);
						W_Io.Get_Immediate(Wchar);   
					     when Wide_Character'Val(51) => -- Maj+F7
						App.Console.Switch(Entreprise);
						W_Io.Get_Immediate(Wchar);   
					     when Wide_Character'Val(52) => -- Maj+F8
						App.Console.Switch(Process);
						W_Io.Get_Immediate(Wchar);   
					     when others =>
						null;
					  end case;
					  
				       when Wide_Character'Val(52) =>                    
					  null;--  Text_Io.Put_Line(" -- end");                     
					  W_Io.Get_Immediate(Wchar);   
					  App.Console.End_Of;
				       when Wide_Character'Val(53) =>
					  null;--  Text_Io.Put_Line(" -- page up");
					  App.Console.Page_Up;
					  W_Io.Get_Immediate(Wchar);   
				       when Wide_Character'Val(54) =>
					  null;--  Text_Io.Put_Line(" -- page down");
					  App.Console.Page_Down;
					  W_Io.Get_Immediate(Wchar);   
				       when Wide_Character'Val(65) =>
					  null;--  Text_Io.Put_Line(" -- up");
					  App.Console.Up_Arrow;
				       when Wide_Character'Val(66) =>
					  null;--  Text_Io.Put_Line(" -- down");
					  App.Console.Down_Arrow;
				       when Wide_Character'Val(67) =>
					  null;--  Text_Io.Put_Line(" -- right");
					  App.Console.Right_Arrow;
				       when Wide_Character'Val(68) =>
					  null;--  Text_Io.Put_Line(" -- left");
					  App.Console.Left_Arrow;
				       when Wide_Character'Val(91) =>
					  W_Io.Get_Immediate(Wchar);                
					  case Wchar is                               
					     when Wide_Character'Val(65) =>
						null;--  Text_Io.Put_Line(" -- F1");                                 
						App.Console.Switch(Organizer);
					     when Wide_Character'Val(66) =>
						null;--  Text_Io.Put_Line(" -- F2");
						App.Console.Switch(Dialog);
					     when Wide_Character'Val(67) =>
						null;--  Text_Io.Put_Line(" -- F3");                                 
						App.Console.Switch(Planning);
					     when Wide_Character'Val(68) =>
						null;--  Text_Io.Put_Line(" -- F4");
						App.Console.Switch(Manager);
					     when Wide_Character'Val(69) =>
						null;--  Text_Io.Put_Line(" -- F5");
						App.Console.Switch(Moneybox);
						
					     when others =>
						null;
					  end case;
					  
				       when others =>
					  
					  App.Console.Reset;            
					  
					  End_Of_Program := False;

					  App.Console.Receive(Wchar);
					  
				    end case;

				 when others =>

				    App.Console.Set_On_Esc(False);

			      end case;                                       
			      
			   when others =>                    
			      case Mode is
				 when Quit =>
				    -- uncomment this line !
				    App.Console.Switch(none);
				    null;
				 when others =>
				    null;
			      end case;

			      App.Console.Set_On_Esc(False);

			      
			      End_Of_Program := False;
			      
			      App.Console.Receive(Wchar);

			end case;
			
		     exception
			
			
			
			when W_Io.End_Error =>
			   

			   --Bell(Quiet);
			   delay 0.5;                   
			   App.Console.reset;

		     end;

		  when M.fvwm =>
		     
		     begin
			App.Console.Mode(Mode);
			W_Io.Get_Immediate(Wchar);
			--Matrix_Saver.Suspend;
			case Wchar is
			   when Wide_Character'Val(27) =>                                       
			      App.Console.Set_On_Esc(True);
			      W_Io.Get_Immediate(Wchar);         
			      case Wchar is
				 when Wide_Character'Val(27) =>				    

				    case Mode is                                                            
				       when Organizer .. Log =>
					  App.Console.Reset;                                 
				       when None =>

					  App.Console.Set_On_Esc(False);                                 
					  App.Console.Switch(Quit);                                 
					  End_Of_Program := True;
				       when Menu =>
					  
					  App.Console.Set_On_Esc(False);
					  M.Ansi.Console.Clear_Screen;
					  App.Console.Switch(none);


					  End_Of_Program := True;
					  
					  --when Shell =>
					  --   null;
				       when others =>
					  if End_Of_Program then         
					     
					     --App.Console.Switch(Quit);
					     App.Console.Halt;
					     exit;
					  end if;
				    end case;                          
				 when others =>
				    App.Console.Mode(Mode);
				    case Mode is
				       
				       when Quit =>
					  if End_Of_Program then         
					     
					     --App.Console.Switch(Quit);

					     App.Console.Halt;

					     exit;
					  end if;
					  
				       when others =>
					  
					  App.Console.Set_On_Esc(False);
					  
					  --App.Console.Switch(mode);
					  End_Of_Program := False;

				    end case;
				    
			      end case;                     
			      
			      case Wchar is
				 when Wide_Character'Val(79) =>                           
				    
				    W_Io.Get_Immediate(Wchar);
				    App.Console.Set_On_Esc(False);
				    case Wchar is
				       when Wide_Character'Val(80) =>
					  null;--  Text_Io.Put_Line(" -- F1");                               
					  App.Console.Switch(Organizer);
				       when Wide_Character'Val(81) =>
					  null;--  Text_Io.Put_Line(" -- F2");
					  App.Console.Switch(Dialog);
				       when Wide_Character'Val(82) =>
					  null;--  Text_Io.Put_Line(" -- F3");                               
					  App.Console.Switch(Planning);
				       when Wide_Character'Val(83) =>
					  null;--  Text_Io.Put_Line(" -- F4");
					  App.Console.Switch(Manager);

				       when others =>
					  null;
				    end case;
				    
				 when Wide_Character'Val(91) =>

				    App.Console.Set_On_Esc(False);
				    W_Io.Get_Immediate(Wchar);              
				    case Wchar is
				       when Wide_Character'Val(49) =>
					  W_Io.Get_Immediate(Wchar);
					  case Wchar is
					     when Wide_Character'Val(53) =>
						W_Io.Get_Immediate(Wchar);                  
						
						case Wchar is
						   when Wide_Character'Val(126) =>
						     null;--  Text_Io.Put_Line(" -- F5");        
						     App.Console.Switch(Moneybox);
						   when others =>
						      W_Io.Get_Immediate(Wchar);                  
						      W_Io.Get_Immediate(Wchar);                  
						      App.Console.Switch(Terminator); -- Maj+F5
						      
						end case;
					     when Wide_Character'Val(55) =>
						
						W_Io.Get_Immediate(Wchar);                  
						case Wchar is
						   when Wide_Character'Val(126) =>
						     null;--  Text_Io.Put_Line(" -- F6");
						     App.Console.Switch(Activity);
						   when others =>
						      W_Io.Get_Immediate(Wchar);                  
						      W_Io.Get_Immediate(Wchar);                  
						      App.Console.Switch(Joshua); -- Maj+F6
						      
						end case;
						
						
					     when Wide_Character'Val(56) =>
						
						W_Io.Get_Immediate(Wchar);                  
						case Wchar is
						   when Wide_Character'Val(126) =>
						     null;--  Text_Io.Put_Line(" -- F7");
						     App.Console.Switch(Stocks);
						   when others =>
						      W_Io.Get_Immediate(Wchar);                  
						      W_Io.Get_Immediate(Wchar);                  
						      App.Console.Switch(Entreprise); -- Maj+F6
						      
						end case;
					     when Wide_Character'Val(57) =>
						null;--  Text_Io.Put_Line(" -- F8");
						W_Io.Get_Immediate(Wchar);                  
						
						case Wchar is
						   when Wide_Character'Val(126) =>
						     App.Console.Switch(Bank);
						   when others =>
						      W_Io.Get_Immediate(Wchar);                  
						      W_Io.Get_Immediate(Wchar);                  
						      App.Console.Switch(Process); -- Maj+F6
						      
						end case;
					     when Wide_Character'Val(59) => 
						W_Io.Get_Immediate(Wchar);
						case Wchar is
						   when Wide_Character'Val(50) =>
						      W_Io.Get_Immediate(Wchar);
						      case Wchar is
							 when Wide_Character'Val(80) =>
							    null;W_Io.Put_Line(" -- Maj+F1");
							    App.Console.Switch(Navigation);
							 when Wide_Character'Val(81) =>
							    null;W_Io.Put_Line(" -- Maj+F2");
							    App.Console.Switch(Engineer);
							 when Wide_Character'Val(82) =>
							    null;W_Io.Put_Line(" -- Maj+F3");
							    App.Console.Switch(Agent);
							 when Wide_Character'Val(83) =>
							    null;W_Io.Put_Line(" -- Maj+F4");
							    App.Console.Switch(Admin);
							 when others =>
							    null;
						      end case;
						   when others =>
						      null;
						end case;
					     when others =>
						null;
					  end case;
				       when Wide_Character'Val(50) =>
					  W_Io.Get_Immediate(Wchar);
					  case Wchar is
					     when Wide_Character'Val(48) =>       
						null;--  Text_Io.Put_Line(" -- F9");
						App.Console.Switch(Log);

						W_Io.Get_Immediate(Wchar);
					     when Wide_Character'Val(49) =>
						null;--  Text_Io.Put_Line(" -- F10");
						App.Console.Switch(Menu);

						W_Io.Get_Immediate(Wchar);
					     when Wide_Character'Val(51) =>
						null;--  Text_Io.Put_Line(" -- F11");
						App.Console.Switch(Contacts);
						W_Io.Get_Immediate(Wchar);
					     when Wide_Character'Val(52) =>
						--null;Text_Io.Put_Line(" -- F12");
						App.Console.Switch(Library);
						W_Io.Get_Immediate(Wchar);
					     when Wide_Character'Val(126) =>
						null;--  Text_Io.Put_Line(" -- insert");
						
					     when others =>
						null;
					  end case;
					  
				       when Wide_Character'Val(51) =>                    
					  null;--  Text_Io.Put_Line(" -- del");                           
					  W_Io.Get_Immediate(Wchar);                            
				       when Wide_Character'Val(53) =>
					  null;--  Text_Io.Put_Line(" -- page up");
					  App.Console.Page_Up;
					  W_Io.Get_Immediate(Wchar);
				       when Wide_Character'Val(54) =>
					  null;--  Text_Io.Put_Line(" -- page down");
					  App.Console.Page_Down;
					  W_Io.Get_Immediate(Wchar);
					  
				       when Wide_Character'Val(65) =>
					  null;--  Text_Io.Put_Line(" -- up");
					  App.Console.Up_Arrow;
				       when Wide_Character'Val(66) =>
					  null;--  Text_Io.Put_Line(" -- down");
					  App.Console.Down_Arrow;
				       when Wide_Character'Val(67) =>
					  null;--  Text_Io.Put_Line(" -- right");
					  App.Console.Right_Arrow;
				       when Wide_Character'Val(68) =>                          
					  null;--  Text_Io.Put_Line(" -- left");
					  App.Console.Left_Arrow;
				       when Wide_Character'Val(70) =>
					  null;--  Text_Io.Put_Line(" -- end");
					  App.Console.End_Of;
				       when Wide_Character'Val(72) =>
					  null;--  Text_Io.Put_Line(" -- begin");                                                              
					  App.Console.Begin_Of;
				       when Wide_Character'Val(91) =>
					  W_Io.Get_Immediate(Wchar);                
					  case Wchar is                               
					     when Wide_Character'Val(69) =>
						
						-- screen print ?
						
						W_Io.Get_Immediate(Wchar);                  
					     when others =>
						null;
					  end case;
					  
				       when others =>
					  
					  App.Console.Reset;            
					  
					  End_Of_Program := False;

					  App.Console.Receive(Wchar);
					  
				    end case;

				 when others =>


				    App.Console.Set_On_Esc(False);



				    
			      end case;                                       

			   when others =>                    
			      case Mode is
				 when Quit =>
				    App.Console.Switch(none);
				 when others =>
				    null;
			      end case;
			      
			      App.Console.Set_On_Esc(False);
			      
			      End_Of_Program := False;
			      
			      App.Console.Receive(Wchar);
			      
			end case;

		     exception
			
			-- A la saisie de Ctrl+D End Error is raised.
			
			when W_Io.End_Error =>
			   
			   --Bell(Quiet);
			   delay 0.5;                   
			   App.Console.reset;
			   
		     end;            
	       end case;
	    end;
	    
	 end loop;
	 --App.Config_Proc.Halt(End_Of_Program);
	 
	 if Integer(Length(App.Bank.List)) /= 0 then
	    
	    Wide_Text_Io.Create(File, Wide_Text_Io.Out_File, Bank_Filename, Form => "WCEM=8");	 
	    
	    for I in 1..Length(App.Bank.List) loop
	       
	       declare
		  
		  Op   : Operation_Record := Element(App.Bank.List, Integer(I));
		  
	       begin
		  
		  Wide_Text_Io.Put_Line(File, Op.Label.all & Wide_Character'Val(9) & Handling.To_Wide_String(Formatting.Image(Op.Date_Op)) & 
			     Wide_Character'Val(9) & Handling.To_Wide_String(Formatting.Image(Op.Date_val)) & Wide_Character'Val(9) & 
					  Handling.To_Wide_String(Sum_Range'Image(Op.sum)));
		  
	       end;
	    end loop;
	    
	    Wide_Text_Io.Close(File);
	 end if;
	 
	 Projects_Manager.Manager_Save(App.Projects, "Projects.lst");
	 Projects_Manager.Archives_Save(App.Archives, "Archives/Projects.lst");
	 Stocks_Save;
	 M.Logs.save(App.logs, M.Logs.Log_Filename);
	 W_Io.Put_Line("Halting CPU process...");
	 Cpu_Process.Halt;
	 W_Io.Put_Line("CPU process halted.");
	 Main_Agence.Servers.Game_Save;
	 W_Io.Put_Line("Halting message box");
	 M.WOPR.Message_Box.Halt;
	 W_Io.Put_Line("Halting Servers");
	 Main_Agence.Servers.Ctrl_C_Procedure;
	 
	 
	 
	 
      exception
	 when W_Io.End_Error =>
	    Cpu_Process.Halt;
	    Main_Agence.Servers.Game_Save;
	    M.WOPR.Message_Box.Halt;

	    Main_Agence.Servers.Ctrl_C_Procedure;

	    
      end;
   end;
end Main ; 
