-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-11 16:46:44"
-- Version := "0.0.0r"
with Ada.Strings.Wide_Fixed;
use Ada.Strings;
with Ada.Wide_Text_Io;
use Ada.Wide_Text_Io;
package body M.Wopr is
   
   procedure Is_Valid (Message : out Message_Type;
		      Content : in Wide_String) is
      
      Last : Natural := 0;
      
   begin
      
      Last := Wide_Fixed.Index(Content, "onjour");
      if Last /= 0 then
	 Message.LANG := EU;
      end if;
      Last := Wide_Fixed.Index(Content, "ardonne");
      if Last /= 0 then
	 Message.Nation := UN;
      end if;
      
      Last := Wide_Fixed.Index(Content, "M.");
      if Last /= 0 then
	 Message.Nation := EST;
	 Message.LANG := none;
      end if;
      
      Last := Wide_Fixed.Index(Content, "Mr");
      if Last /= 0 then
	 Message.Nation := EST;
	 Message.LANG := none;
      end if;
      
      
      if Message.LANG = None and Message.Nation = None then
	 Message.Valid := False;
      elsif Message.LANG = None and Message.Nation = EST then
	 Message.Valid := False;
      else
	 Message.Valid := True;
      end if;
   end Is_Valid;
   
   
   task body Message_Box is
   begin
      loop
	 select
	    accept Initialize;
	 or
	    accept Receive(From : in User_Record;Dest : in User_Record;Msg : in Wide_String) do
	       declare
		  Message : Message_Type := (None, None, false);
	       begin
		  WOPR.Get_Message(Msg, Message);
		  if Message.Valid then
		     -- add
		     null;
		  end if;
	       end;
	    end Receive;
	      
	 or
	    accept Get(User : in User_Record;Box : in out Wide_String_Set);
	 or
	    accept Halt;
	    exit;
	 end select;
      end loop;
      Put_Line("Message box halted");
   end Message_Box;
   
   protected body WOPR is
      entry Set_Alert (Alert : in T_EmergCon) when Message.Nation = UN is
      begin
	 null;
      end Set_Alert;
      entry Raise_DefCon (DefCon : in T_DefCon) when Message.LANG = EU is
      begin
	 null;
      end Raise_DefCon;
      
      entry Get_Message (Line : in Wide_String;Msg : out Message_Type) when Message.Nation = UN and Message.LANG = EU is
      begin
	    Is_Valid(Message, Line);
	    if Message.Nation = UN and Message.LANG = EU then
	       Msg := Message;
	    else
	       Status := T_LertCon'Succ(Status);
	       Msg.Valid := False;
	    end if;
	 end Get_Message;
   end WOPR;
   
end M.Wopr ; 
