-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-06-25 13:06:35 ; 
-- Version := 0.4.0r ; 
with Gnat.Os_Lib;
use Gnat.Os_Lib;
with m.Strings;
use M.Strings;
with Sky;
use Sky;
with Sai;
use Sai;
with M.Main_Game;
use M.Main_Game;
with M.Engineering;
generic
   with package Engineer is new M.Engineering (<>);
   Engy : access Engineer.Engineering_Record;
package M.Servers is
   
   task Server is
      entry Initialize;
      entry Start;
      entry Standby (End_Of_Program : out Boolean);
      entry Stop;
      entry Halt;
   end Server;
   
   
   
   
   Current_Game : M.Main_Game.Main_Game(10);
   
   procedure Game_Save;
   procedure Game_Restore;
   
   
   procedure Ctrl_C_Procedure;

end M.Servers ; 
