-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-04 18:32:28"
-- Version := "0.0.0r"
with Ada.Text_Io;
use Ada.Text_Io;
with Gnat.Os_Lib;
use Gnat.Os_Lib;

with Ada.Strings.Fixed;
use Ada.Strings.Fixed;
with Gnat.Directory_Operations;
use Gnat.Directory_Operations;

package body M.Projects_manager is
   
      procedure Manager_Load (Projects : out Projects_Record; Filename : in String) is
      File : File_Type;
      Project : Project_Access;
   begin

      if not Is_Regular_File(Filename) then
	 return;
      end if;
      
      Open(File, In_File, Filename);
      Projects.Projects_Num := 0;
      while not End_Of_File(File) loop
	 
	 declare
	    
	    Project_Name : constant String := Get_Line(File);
	    Img : constant String := Project_Name(Index(Project_Name, " ")+1..Project_Name'Last);
	    String_Long_Float : constant String(1..Img'Length) := Img;
	    Elapsed_Long_Float : constant Long_Long_Float := (Long_Long_Float'Value(String_Long_Float));
	    Days         : constant Natural := Natural(Elapsed_Long_Float / 86400.0);
	    
	    Elapsed : Duration := 0.0;
	 begin	    

	    Elapsed := Duration(Elapsed_Long_Float - (Long_Long_Float(Days) * 86400.0));
	    
	    Read(Project, 
		 Project_Name(1..Index(Project_Name, " ")-1));

	    if Project /= null then
	       Project.Days := Days;
	       Project.Elapsed := Elapsed;
	       Project.Project_Num := Projects.Projects_Num + 1;
	       Projects.Projects_Num := Projects.Projects_Num + 1;
	       Append(Projects.List, Project);
	    end if;
	 end;

      end loop;
      New_Line;
      Close(File);

   end Manager_Load;
   
   procedure Manager_Save (Projects : in Projects_Record; Filename : in String) is
      File : File_Type;
      Curs : Projects_Dll.Cursor;

   begin
      
      if Projects_Dll.Length(Projects.List) /= 0 then
	 Create(File, Out_File, Filename);
	 Curs := Projects_Dll.First(Projects.List);
	 for Cur in 1..Projects_Dll.Length(Projects.List) loop

	    declare
	       
	       Project : constant Project_Access := Projects_Dll.Element(Curs);	       
	    begin
	       
	       if Project /= null then
		  --Put_Line(Project.Project_Name.all & Versions.Version_Io.To_String(Project.Version));
		  Save(Project.all, file);
	       end if;
	    end;
	    Curs := Projects_Dll.Next(Curs);
	    
	 end loop;
	 Close(File);
      end if;
   end Manager_Save;
   
   procedure Archives_Load (Projects : out Projects_Record; Filename : in String) is
      File : File_Type;
      Project : Project_Access;
   begin

      if not Is_Regular_File(Filename) then
	 return;
      end if;

      Open(File, In_File, Filename);
      Projects.Projects_Num := 0;
      while not End_Of_File(File) loop
	 
	 declare
	    
	    Project_Name : constant String := Get_Line(File);
	    Img : constant String := Project_Name(Index(Project_Name, " ")+1..Project_Name'Last);
	    String_Long_Float : constant String(1..Img'Length) := Img;
	    Elapsed_Long_Float : Long_Float := (Long_Float'Value(String_Long_Float));
	    Days         : Natural := Natural(Elapsed_Long_Float / 86400.0);
	    
	    Elapsed : Duration := 0.0;
	 begin	    
	    
	    Elapsed := Duration(Elapsed_Long_Float - (Long_Float(Days) * 86400.0));
	    
	    Read(Project, 
		 Dir_Name(Filename) & Project_Name(1..Index(Project_Name, " ")-1));
	    
	    if Project /= null then
	       Project.Days := Days;
	       Project.Elapsed := Elapsed;
	       Project.Project_Num := Projects.Projects_Num + 1;
	       Projects.Projects_Num := Projects.Projects_Num + 1;
	       Append(Projects.List, Project);
	    end if;
	 end;

      end loop;

      Close(File);
      
   end Archives_Load;
   
   procedure Archives_Save (Projects : in Projects_Record; Filename : in String) is
      File : File_Type;
      Curs : Projects_Dll.Cursor;

   begin
      
      if Projects_Dll.Length(Projects.List) /= 0 then
	 Create(File, Out_File, Filename);
	 Curs := Projects_Dll.First(Projects.List);
	 for Cur in 1..Projects_Dll.Length(Projects.List) loop

	    declare
	       
	       Project : constant Project_Access := Projects_Dll.Element(Curs);	       
	    begin
	       
	       if Project /= null then
		  Save(Project.all, file);
	       end if;
	    end;
	    Curs := Projects_Dll.Next(Curs);
	    
	 end loop;
	 Close(File);
      end if;
   end Archives_Save;

   
end M.Projects_manager ; 
