-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-04 11:53:09"
-- Version := "0.0.0r"
package M.Options is
   
      type Option_Tagged_Type (Requiered_Parameter : Boolean) is tagged
     -- Option type is tagged ; with Requiered_Parameters is Boolean ;
      record
     
         Is_Setted    : Boolean            := False;
	 -- True if occure on Command line ; Default False ;
	 
	 Optionals_Flags : Flag_Enum := None;
	 -- Flag of Option occurence ; Default Nul_Option ;
	 
	 case Requiered_Parameter is
	    -- case Requiered_Parameter is
	    when False =>	       
	    -- when False =>
	       
	       null;
	       
	       --null ;
	       
	    when True =>
	       -- when True =>
	       Value : access Wide_String;
	      
	      -- Value is image of parameter.
	      
	 end case;
	 
      end record;
   
   
   type Options_Kit is 
     -- Option_Kit is array ;
     array (Flag_Enum) 
     -- range Options_Flags_Enum_Type enumeration
     of access Option_Tagged_Type;
   -- of access to Option_Type ;
   
   
   Full_Line_Options_Kit : constant Options_Kit :=
     -- Full_Options_Kit is constant Options_Kit_Array_Type     
     (
      -- where
      None => 
     	-- Nul_Option is
     	new Option_Tagged_Type (False),
      
      Config_filename => new Option_Tagged_Type (True),
      Help => new Option_Tagged_Type (False),
      Name_length => new Option_Tagged_Type (True),
      Unit_max => new Option_Tagged_Type (True),
      Char_max => new Option_Tagged_Type (True),
      Version => new Option_Tagged_Type (False),      
      Object_max => new Option_Tagged_Type (True),
      Self_programming => new Option_Tagged_Type (True),
      Self_executed => new Option_Tagged_Type (True),
      Self_wait => new Option_Tagged_Type (True),
      User_wait => new Option_Tagged_Type (True),
      Human_Lang => new Option_Tagged_Type (True),
      With_gtk => new Option_Tagged_Type (True),
      With_Ada => new Option_Tagged_Type (True),
      With_Aws => new Option_Tagged_Type (True),
      Quiet => new Option_Tagged_Type (False),
      Geometry => new Option_Tagged_Type (True),
      Username => new Option_Tagged_Type (True),
      Address => new Option_Tagged_Type (True),      
      Input_Text  => new Option_Tagged_Type (True),
      Term_name  => new Option_Tagged_Type (True),
      Samples_Filename => new Option_Tagged_Type (True),
      Max_Epochs => new Option_Tagged_Type (True),
      Converged=> new Option_Tagged_Type (True),      
      Reuse  => new Option_Tagged_Type (False),
      Train  => new Option_Tagged_Type (False),
      Num_Samples  => new Option_Tagged_Type (True),      
      Line_width => new Option_Tagged_Type (True),
      Words_max => new Option_Tagged_Type (True),
      Num_hidden => new Option_Tagged_Type (True),
      Update => new Option_Tagged_Type (True),
      As_server => new Option_Tagged_Type (False),
      Style => new Option_Tagged_Type (True),
      Initialize => new Option_Tagged_Type (True),
      
      Total => new Option_Tagged_Type (False)


     );     
   
   Full_File_Options_Kit : constant Options_Kit :=
     -- Full_Options_Kit is constant Options_Kit_Array_Type     
     (
      -- where
      None => 
     	-- Nul_Option is
     	new Option_Tagged_Type (False),
      
      Config_filename => new Option_Tagged_Type (True),
      Help => new Option_Tagged_Type (False),
      Name_length => new Option_Tagged_Type (True),
      Unit_max => new Option_Tagged_Type (True),
      Char_max => new Option_Tagged_Type (True),
      Version => new Option_Tagged_Type (False),      
      Object_max => new Option_Tagged_Type (True),
      Self_programming => new Option_Tagged_Type (True),
      Self_executed => new Option_Tagged_Type (True),
      Self_wait => new Option_Tagged_Type (True),
      User_wait => new Option_Tagged_Type (True),
      Human_Lang => new Option_Tagged_Type (True),
      With_gtk => new Option_Tagged_Type (True),
      With_Ada => new Option_Tagged_Type (True),
      With_Aws => new Option_Tagged_Type (True),
      Quiet => new Option_Tagged_Type (False),
      Geometry => new Option_Tagged_Type (True),
      Username => new Option_Tagged_Type (True),
      Address => new Option_Tagged_Type (True),      
      Input_Text  => new Option_Tagged_Type (True),
      Term_name  => new Option_Tagged_Type (True),
      Samples_Filename => new Option_Tagged_Type (True),
      Max_Epochs => new Option_Tagged_Type (True),
      Converged=> new Option_Tagged_Type (True),      
      Reuse  => new Option_Tagged_Type (False),
      Train  => new Option_Tagged_Type (False),
      Num_Samples  => new Option_Tagged_Type (True),      
      Line_width => new Option_Tagged_Type (True),
      Words_max => new Option_Tagged_Type (True),
      Num_hidden => new Option_Tagged_Type (True),
      Update => new Option_Tagged_Type (True),
      As_server => new Option_Tagged_Type (False),
      Style => new Option_Tagged_Type (True),
      Initialize => new Option_Tagged_Type (True),
      
      Total => new Option_Tagged_Type (False)

	
	
     );     
   
   Default_Nul_Option : constant access Option_Tagged_Type :=
       -- Default_Nul_Option is constant access to
     new Option_Tagged_Type (False);     
   -- new Option_Tagged_Type(False);   
   
   function Get_Options_From_Command_Line
     -- To get Options_Kit_array_Type from argument in command_line ;
     
     return Options_Kit;
   -- return Options_Kit_Array_Type;  
   
   
   function Get_Options_From_File
     (Filename : in Wide_String)
     -- To get Options_Kit_array_Type from argument in file ;
     
     return Options_Kit;
   -- return Options_Kit_Array_Type;  

end M.Options ; 
