-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-11-20 06:17:39"
-- Version := "0.9.0r"
with Ada.Text_Io;
use Ada.Text_Io;
with Ada.Calendar.Formatting;
package body M.Logs is
   procedure Open (Session : in out Session_Record) is
   begin
      Session.Top := Clock;      
   end Open;
     
   procedure Close (Session : in out Session_Record) is
   begin

      Session.Bot := Clock;      
   end Close;
   
   Total : Long_Long_Float := 0.0;
   
   procedure Statistic (Sessions : in out Session_Array; Logs : in out Log_Array) is
      
      Sum : Long_Long_Float := 0.0;
   begin
      
	for Session in Sessions'Range loop
	   
	  if Sessions(Session).Bot > Sessions(Session).Top then

	    declare
	       Elapsed : constant Duration := Sessions(Session).Bot - Sessions(Session).Top;
	    begin
	       
	       
	       if Elapsed > 0.0 then
		  
		  Logs(Session).Total := Logs(Session).Total + Long_Long_Float(Elapsed);
		  
		  
		  
		  Sessions(Session).Top := Time_Of(2399, 12, 31, 86399.99);
		  
	       end if;
	    end;
	 end if;
	end loop;
	Total := 0.0;
	for Session in Sessions'Range loop
	   Total := Total + Logs(Session).Total;
	end loop;
	if Total > 0.0 then
	   
	   for Log in Logs'Range loop
	      
	      if Logs(Log).Total >= 1.0 then
		 
		 Sum := Logs(Log).Total / Total;
		 
		 Logs(Log).Rate := Rate_Type(Sum * 100.0);
		 
	      else
		 Logs(Log).Rate := 0.0;
	      end if;
	   end loop;      
	end if;

   end Statistic;
   
   procedure Save (Logs : in Log_Array; Filename : in String) is
      File : File_Type;
   begin
      begin
	 Open(File, Out_File, Filename);
      exception
	 when others =>
	    Create(File, Out_File, Filename);
      end;
      for log in Logs'Range loop
	 Put_Line(File, Long_Long_Float'Image(Logs(Log).Total));
	 Put_Line(File, Rate_Type'Image(Logs(Log).Rate));
      end loop;
      Close(File);
   end Save;
      
      
   procedure Restore (Logs : out Log_Array; Filename : in String) is
      File : File_Type;
   begin
      Total := 0.0;
      Open(File, In_File, Filename);
      for Log in Logs'Range loop
	 if not End_Of_File(File) then
	    Logs(Log).Total := Long_Long_Float'Value(Get_Line(File));
	    Logs(Log).Rate := Rate_Type'Value(Get_Line(File));
	    Total := Total + Logs(Log).Total;
	 end if;
      end loop;
      Close(File);
   end Restore;

end M.Logs ; 
