-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-04 18:32:28"
-- Version := "0.0.0r"
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with M.Ansi.Console;
use M.Ansi.Console;
with Text_Io;
use Text_Io;
with Gnat.Os_Lib;
use Gnat.Os_Lib;
with Ada.Unchecked_Deallocation;

package body M.Classes is
   procedure String_Free is new Ada.Unchecked_Deallocation(String, String_Access);
   
   procedure Obj_Free(O : in out Abstract_Access) is
   begin
      Wide_Free(O.Info.Name);
      if O.Definition.Index /= 0 then
	 for Att in 1..O.Definition.Index loop
	    if O.Definition.List(Att).Enum = Str then
	       String_Free(O.Definition.List(Att).Str);
	    end if;
	 end loop;
      end if;
      case O.Tag is
	 when Event =>
	    Wide_Free(Event_Class(O.all).Locality);
	    Wide_Free(Event_Class(O.all).Define);
	 when Job =>
	    Wide_Free(Job_Class(O.all).Locality);
	    Wide_Free(Job_Class(O.all).Define);
	 when Meeting =>
	    Wide_Free(Meeting_Class(O.all).Locality);
	    Wide_Free(Meeting_Class(O.all).Define);
	 when Rendezvous =>
	    Wide_Free(Rendezvous_Class(O.all).Locality);
	    Wide_Free(Rendezvous_Class(O.all).Define);
	 when Content =>
	    Wide_Free(content_Class(O.all).Description);
	 when Profile =>
	    Wide_Free(Profile_Class(O.all).Full_name);
	    Wide_Free(Profile_Class(O.all).Addr);
	    Wide_Free(Profile_Class(O.all).Phone);
	    Wide_Free(Profile_Class(O.all).Email);
	 when others =>
	    null;
      end case;
	      
   end Obj_Free;
   
   
   function Same (Left, Right : in Abstract_Access) return Boolean is
   begin
      return Left.all = Right.all;
   end Same;
   
   
   procedure Print (Info : Abstract_Info; header : in Window_Type) is
   begin
      
      Draw(Header, 1, 2, White, "Class : " & To_Wide_String(Class_Enum'Image(Info.Tag)));
      Draw(Header, 2, 2, White, "Index : " & To_Wide_String(Abstract_Index'Image(Info.Index)));
      if Info.Name /= null then
	 Draw(Header, 3, 2, White, "Name : " & Info.Name.all);
      else
	 Draw(Header, 3, 2, White, "Name : ");
      end if;
      Draw(Header, 4, 2, White, "Created : " & To_Wide_String(Image(Info.Created)));
   end Print;
   
   
   procedure Print (Obj    : in none_Class;
		    Header : in Window_Type;
		    Main : in Window_Type) is
   begin
      null;
   end Print;
   
   procedure Write (O : in none_Class;File : in W_Io.File_Type) is
   begin
      null;
   end Write;
   procedure Read (O : out none_Class;File : in W_Io.File_Type) is
   begin
      null;
   end Read;

   
   
   procedure Print (Attr : in Attributs; Win : in Window_type) is
   begin      

      if Attr.Index /= 0 then

	 for I in 1..Attr.Index loop
	    Draw(Win, I, 1, white, To_Wide_String(Attr.List(I).Name.all));
	    Draw(Win, I, Attr.List(I).Name'Length+1, Red, "=");
	    Draw(Win, I, Attr.List(I).Name'Length+2, white, To_Wide_String(Attr.List(I).Value.all));
	 end loop;
      end if;
   end Print;
      
   
   
   
   use Abstract_Vectors;
   ----------------------------------------------------------------------------
   -- Universe
   
   function Create return Universe_Class is
      Obj : Universe_Class;
   begin
      Obj.Info.Name := new Wide_String ' ("Universe");
      Obj.Info.Created := Clock;
      return Obj;
   end Create;
   
   procedure Print (Obj    : in Universe_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type) is
   begin
      Print(Obj.Info, header);
   end Print;
   
   procedure Write (O : in Universe_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Class_Enum'Image(Abstract_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Abstract_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
   end Write;
   
   
   
   procedure Read (O : out Universe_Class;File : in W_Io.File_Type) is
      
   begin
      
      O.Info.Index := Abstract_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
   end Read;
   
   ----------------------------------------------------------------------------
   -- Planning
   
   function Create return Planning_Class is
      Obj : Planning_Class;
   begin
      Obj.Info.Created := Clock;
      return Obj;
   end Create;
   
   procedure Print (Obj    : in Planning_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type) is
   begin
      Print(Obj.Info, header);
      Draw(Main, 1, 2, White, "From : " & To_Wide_String(Image(Obj.From)));
      Draw(Main, 2, 2, White, "To : " & To_Wide_String(Image(Obj.To)));
   end Print;
   
   procedure Write (O : in Planning_Class;File : in W_Io.File_Type) is
   begin
      
      W_Io.Put_Line(File, To_Wide_String(Class_Enum'Image(Abstract_Class(O).Tag)));
      
      W_Io.Put_Line(File, To_Wide_String(Abstract_Index'Image(O.Info.Index)));      
      
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      
      W_Io.Put_Line(File, O.Info.Name.all);
      
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, To_Wide_String(Image(O.from)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.to)));
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Planning_Class;File : in W_Io.File_Type) is
      Date_From : Wide_String_Access;
   begin
      
      O.Info.Index := Abstract_Index'Value(To_String(W_Io.Get_Line(File)));      
      
      O.Info.Created := Value(To_String(W_Io.Get_Line(File)));      
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      W_io.Put_Line("Name :" &  O.Info.Name.all);
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      
      O.From := Value(To_String(W_Io.Get_Line(File)));
      
      
      O.To := Value(To_String(W_Io.Get_Line(File)));
      
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
   end Read;
   
   ----------------------------------------------------------------------------
   -- Event
   
   function Create return Event_Class is
      Obj : Event_Class;
   begin
      Obj.Info.Created := Clock;
      return Obj;
   end Create;
   
   procedure Print (Obj    : in Event_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type) is
   begin
      Print(Obj.Info, header);
      Draw(Main, 1, 2, White, "Date : " & To_Wide_String(Image(Obj.Date)));
      Draw(Main, 2, 2, White, "Period : " & To_Wide_String(Integer'Image(Integer(Obj.Period/60.0))) &  " minutes");
      Draw(Main, 3, 2, White, "Locality : " & Obj.Locality.all);
      Draw(Main, 4, 2, White, "Define : " & Obj.Define.all);
   end Print;
   
   procedure Write (O : in Event_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Class_Enum'Image(Abstract_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstract_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, To_Wide_String(Image(O.Date)));
      W_Io.Put_Line(File, To_Wide_String(Duration'Image(O.Period)));
      W_Io.Put_Line(File, O.Locality.all);
      W_Io.Put_Line(File, O.Define.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Event_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Abstract_Index'Value(To_String(W_Io.Get_Line(File)));

      O.Info.Created := Value(To_String(W_Io.Get_Line(File)));

      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      
      O.Date := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Period := Duration'Value(To_String(W_Io.Get_Line(File)));
      
      O.Locality := new Wide_String ' (W_Io.Get_Line(File));
      
      O.Define := new Wide_String ' (W_Io.Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
   end Read;
   
   ----------------------------------------------------------------------------
   -- Job
   
   function Create return Job_Class is
      Obj : Job_Class;
   begin
      Obj.Info.Created := Clock;
      return Obj;
   end Create;
   
   procedure Print (Obj    : in Job_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type) is
   begin
      Print(Obj.Info, header);
      Draw(Main, 1, 2, White, "Date : " & To_Wide_String(Image(Obj.Date)));
      Draw(Main, 2, 2, White, "Period : " & To_Wide_String(Integer'Image(Integer(Obj.Period/60.0))) &  " minutes");
      Draw(Main, 3, 2, White, "Locality : " & Obj.Locality.all);
      Draw(Main, 4, 2, White, "Define : " & Obj.Define.all);
   end Print;
   
   procedure Write (O : in Job_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Class_Enum'Image(Abstract_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstract_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, To_Wide_String(Image(O.Date)));
      W_Io.Put_Line(File, To_Wide_String(Duration'Image(O.Period)));
      W_Io.Put_Line(File, O.Locality.all);
      W_Io.Put_Line(File, O.Define.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Job_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Abstract_Index'Value(To_String(W_Io.Get_Line(File)));

      O.Info.Created := Value(To_String(W_Io.Get_Line(File)));

      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));

      O.Date := Formatting.Value(To_String(W_Io.Get_Line(File)));

      O.Period := Duration'Value(To_String(W_Io.Get_Line(File)));

      O.Locality := new Wide_String ' (W_Io.Get_Line(File));

      O.Define := new Wide_String ' (W_Io.Get_Line(File));

      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
   end Read;
   
   ----------------------------------------------------------------------------
   -- Meeting
   
   function Create return Meeting_Class is
      Obj : Meeting_Class;
   begin
      Obj.Info.Created := Clock;
      return Obj;
   end Create;
   
   procedure Print (Obj    : in Meeting_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type) is
   begin
      Print(Obj.Info, header);
      Draw(Main, 1, 2, White, "Date : " & To_Wide_String(Image(Obj.Date)));
      Draw(Main, 2, 2, White, "Period : " & To_Wide_String(Integer'Image(Integer(Obj.Period/60.0))) &  " minutes");
      Draw(Main, 3, 2, White, "Locality : " & Obj.Locality.all);
      Draw(Main, 4, 2, White, "Define : " & Obj.Define.all);
   end Print;
   
   procedure Write (O : in Meeting_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Class_Enum'Image(Abstract_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstract_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, To_Wide_String(Image(O.Date)));
      W_Io.Put_Line(File, To_Wide_String(Duration'Image(O.Period)));
      W_Io.Put_Line(File, O.Locality.all);
      W_Io.Put_Line(File, O.Define.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Meeting_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Abstract_Index'Value(To_String(W_Io.Get_Line(File)));

      O.Info.Created := Value(To_String(W_Io.Get_Line(File)));

      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      
      O.Date := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Period := Duration'Value(To_String(W_Io.Get_Line(File)));
      O.Locality := new Wide_String ' (W_Io.Get_Line(File));
      
      O.Define := new Wide_String ' (W_Io.Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
   end Read;
   
   ----------------------------------------------------------------------------
   -- Rendezvous
   
   function Create return Rendezvous_Class is
      Obj : Rendezvous_Class;
   begin
      Obj.Info.Created := Clock;
      return Obj;
   end Create;
   
   procedure Print (Obj    : in Rendezvous_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type) is
   begin
      Print(Obj.Info, header);
      Draw(Main, 1, 2, White, "Date : " & To_Wide_String(Image(Obj.Date)));
      Draw(Main, 2, 2, White, "Period : " & To_Wide_String(Integer'Image(Integer(Obj.Period/60.0))) &  " minutes");
      Draw(Main, 3, 2, White, "Locality : " & Obj.Locality.all);
      Draw(Main, 4, 2, White, "Define : " & Obj.Define.all);
   end Print;
   
   procedure Write (O : in Rendezvous_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Class_Enum'Image(Abstract_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstract_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, To_Wide_String(Image(O.Date)));
      W_Io.Put_Line(File, To_Wide_String(Duration'Image(O.Period)));
      W_Io.Put_Line(File, O.Locality.all);
      W_Io.Put_Line(File, O.Define.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Rendezvous_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Abstract_Index'Value(To_String(W_Io.Get_Line(File)));

      O.Info.Created := Value(To_String(W_Io.Get_Line(File)));

      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      
      O.Date := Formatting.Value(To_String(W_Io.Get_Line(file)));
      
      O.Period := Duration'Value(To_String(W_Io.Get_Line(file)));
      
      O.Locality := new Wide_String ' (W_Io.Get_Line(File));
      
      O.Define := new Wide_String ' (W_Io.Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
   end Read;
   
   ----------------------------------------------------------------------------
   -- Profile
   
   function Create return Profile_Class is
      Obj : Profile_Class;
   begin
      Obj.Info.Created := Clock;
      return Obj;
   end Create;
   
   procedure Print (Obj    : in Profile_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type) is
   begin
      Print(Obj.Info, header);
      if Obj.Full_Name /= null then
	 Draw(Main, 1, 2, White, "Name : " & Obj.Full_Name.all);
      end if;
      Draw(Main, 2, 2, White, "Born : " & To_Wide_String(Image(Obj.Born)));
      if Obj.Addr /= null then
	 Draw(Main, 3, 2, White, "Addr : " & Obj.Addr.all);
      end if;
      if Obj.Phone /= null then
	 Draw(Main, 4, 2, White, "Phone : " & Obj.Phone.all);
      end if;
      if Obj.Email /= null then
	 Draw(Main, 5, 2, White, "Email : " & Obj.Email.all);
      end if;      
   end Print;
   
   procedure Write (O : in Profile_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Class_Enum'Image(Abstract_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstract_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Full_Name.all);
      W_Io.Put_Line(File, To_Wide_String(Image(O.Born)));
      W_Io.Put_Line(File, O.Addr.all);
      W_Io.Put_Line(File, O.Phone.all);
      W_Io.Put_Line(File, O.Email.all);
      W_Io.Put_Line(File, To_Wide_String(Integer'Image(O.id)));
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Profile_Class;File : in W_Io.File_Type) is
   begin
      
      O.Info.Index := Abstract_Index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      
      O.Full_Name := new Wide_String ' (W_Io.Get_Line(File));
      
      O.born := Formatting.Value(To_String(W_Io.Get_Line(file)));
      
      O.Addr := new Wide_String ' (W_Io.Get_Line(File));
      
      O.Phone := new Wide_String ' (W_Io.Get_Line(File));
      
      O.Email := new Wide_String ' (W_Io.Get_Line(File));
      O.id := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
   end Read;
   
   ----------------------------------------------------------------------------
   -- Content
   
   function Create return Content_Class is
      Obj : Content_Class;
   begin
      Obj.Info.Created := Clock;
      return Obj;
   end Create;
   
   procedure Print (Obj    : in Content_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type) is
   begin
      Print(Obj.Info, header);
      if Obj.Description /= null then
	 Draw(Main, 1, 2, White, "Define : " & Obj.Description.all);
      end if;
      Draw(Main, 2, 2, White, "Price : " & To_Wide_String(Fixed_Unit_Ttc'Image(Obj.Price)));
   end Print;
   
   procedure Write (O : in Content_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Class_Enum'Image(Abstract_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstract_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Description.all);
      W_Io.Put_Line(File, To_Wide_String(Fixed_Unit_Ttc'Image(O.Price)));
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Content_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Abstract_Index'Value(To_String(W_Io.Get_Line(File)));
      O.Info.Created := Value(To_String(W_Io.Get_Line(File)));
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Description := new Wide_String ' (W_Io.Get_Line(File));
      O.Price := Fixed_Unit_Ttc'value(To_String(W_Io.Get_Line(File)));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
   end Read;
   
   
   
   
   
   function Create return Book_Class is
      Book : Book_Class;
   begin
      return Book;
   end Create;
   
   procedure Print (Obj    : in Book_Class;
   		    Header    : in Window_Type;
   		    Main : in Window_Type) is
   begin
      Print(Obj.Info, header);
      if Obj.Info.Name /= null then
	 Draw(Main, 1, 2, White, "Title : " & Obj.Info.Name.all);
      end if;      
      if Obj.Author /= null then
	 Draw(Main, 2, 2, White, "Author : " & Obj.Author.all);
      end if;
      if Obj.Editor /= null then
	 Draw(Main, 3, 2, White, "Edito : " & Obj.Editor.all);
      end if;
   end Print;
   
   procedure Write (O : in Book_Class;File : in W_Io.File_Type) is
   begin
      
      W_Io.Put_Line(File, To_Wide_String(Class_Enum'Image(Abstract_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstract_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Author.all);
      W_Io.Put_Line(File, O.Editor.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Owner)));
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   
   procedure Read (O : out Book_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Abstract_Index'Value(To_String(W_Io.Get_Line(File)));
      O.Info.Created := Value(To_String(W_Io.Get_Line(File)));
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Author := new Wide_String ' (W_Io.Get_Line(File));
      O.Editor := new Wide_String ' (W_Io.Get_Line(File));
      O.Owner := natural'Value(To_String(W_Io.Get_Line(File)));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;

   end Read;
   
   
   
   function Create return CDROM_Class is
      CDROM : CDROM_Class;
   begin
      return CDROM;
   end Create;
   
   procedure Print (Obj    : in CDROM_Class;
   		    Header    : in Window_Type;
   		    Main : in Window_Type) is
   begin
      Print(Obj.Info, header);
      if Obj.Info.Name /= null then
	 Draw(Main, 1, 2, White, "Title : " & Obj.Info.Name.all);
      end if;      
      if Obj.Author /= null then
	 Draw(Main, 2, 2, White, "Authors : " & Obj.Author.all);
      end if;
      if Obj.Editor /= null then
	 Draw(Main, 3, 2, White, "Editor : " & Obj.Editor.all);
      end if;
   end Print;
   
   procedure Write (O : in CDROM_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Class_Enum'Image(Abstract_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstract_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;

      W_Io.Put_Line(File, O.Author.all);
      W_Io.Put_Line(File, O.Editor.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Owner)));
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
   end Write;
   
   procedure Read (O : out CDROM_Class;File : in W_Io.File_Type) is
   begin
            O.Info.Index := Abstract_Index'Value(To_String(W_Io.Get_Line(File)));
      O.Info.Created := Value(To_String(W_Io.Get_Line(File)));
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));

      O.Author := new Wide_String ' (W_Io.Get_Line(File));
      O.Editor := new Wide_String ' (W_Io.Get_Line(File));
      O.Owner := natural'Value(To_String(W_Io.Get_Line(File)));
            O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;

   end Read;
   
   

   
   function Create return DVD_Class is
      DVD : DVD_Class;
   begin
      return DVD;
   end Create;
   
   procedure Print (Obj    : in DVD_Class;
   		    Header    : in Window_Type;
   		    Main : in Window_Type) is
   begin
      Print(Obj.Info, header);
      if Obj.Info.name /= null then
	 Draw(Main, 1, 2, White, "Title : " & Obj.Info.name.all);
      end if;      
      if Obj.Author /= null then
	 Draw(Main, 2, 2, White, "Author : " & Obj.Author.all);
      end if;
      if Obj.Editor /= null then
	 Draw(Main, 3, 2, White, "Editor : " & Obj.Editor.all);
      end if;
   end Print;
   
   procedure Write (O : in DVD_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Class_Enum'Image(Abstract_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstract_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;

      W_Io.Put_Line(File, O.Author.all);
      W_Io.Put_Line(File, O.Editor.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Owner)));
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
   end Write;
   
   procedure Read (O : out DVD_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Abstract_Index'Value(To_String(W_Io.Get_Line(File)));
      O.Info.Created := Value(To_String(W_Io.Get_Line(File)));
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      
      O.Author := new Wide_String ' (W_Io.Get_Line(File));
      O.Editor := new Wide_String ' (W_Io.Get_Line(File));
      O.Owner := natural'Value(To_String(W_Io.Get_Line(File)));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;

   end Read;
   
   
   
   function Create return Car_Class is
      Car : Car_Class;
   begin
      return Car;
   end Create;
   
   procedure Print (Obj    : in Car_Class;
   		    Header    : in Window_Type;
   		    Main : in Window_Type) is
   begin
      null;
   end Print;
   
   procedure Write (O : in Car_Class;File : in W_Io.File_Type) is
   begin
      null;
   end Write;
   
   procedure Read (O : out Car_Class;File : in W_Io.File_Type) is
   begin
      null;
   end Read;
   
   
   function Create return House_Class is
      House : House_Class;
   begin
      return House;
   end Create;
   
   procedure Print (Obj    : in House_Class;
   		    Header    : in Window_Type;
   		    Main : in Window_Type) is
   begin
      null;
   end Print;
   
   procedure Write (O : in House_Class;File : in W_Io.File_Type) is
   begin
      null;
   end Write;

   procedure Read (O : out House_Class;File : in W_Io.File_Type) is
   begin
      null;
   end Read;

end M.Classes ; 
