-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-04 18:32:28"
-- Version := "0.0.0r"
with Sky;
use Sky;
package M.Balance is
   pragma Shared_Passive (M.Balance);
   
   type Balance_Record is
      record
   	 Capital     : Fixed_Total := 0.0;
   	 Material    : Fixed_Total := 0.0;
   	 TVA_In      : Fixed_Total := 0.0;
   	 TVA_Out     : Fixed_Total := 0.0;
      end record;
   
   
   
   
   Balance       : Balance_Record;
   
   Invoice_Num : Voice_Num_Range := 0;
   Outvoice_Num : Voice_Num_Range := 0;
   Initialized  : Boolean := False;
   
   
   Main_Balance       : Balance_Record;
   
   Main_Invoice_Num : Voice_Num_Range := 0;
   Main_Outvoice_Num : Voice_Num_Range := 0;
   Created  : Boolean := False;

   
end M.Balance ; 
