-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-04 18:32:28"
-- Version := "0.0.0r"
with Ada.Strings.Fixed;
use Ada.Strings.Fixed;
use Ada.Strings;
with Ada.Calendar.Formatting;

package body M.Attributes is
   procedure Parse (Line : in String; Name : out String_Access; Image : out String_Access) is
      current : constant Natural := Index(Line, "=");
      Top   : constant Natural := Index(Line(Line'First..current), " ", backward)+ 1;
      Bot   : constant Natural := Index_Non_Blank(Line, Backward);
   begin
      if (Current = 0) or (Top = 0) or (Bot = 0) then
	 return;
      end if;	      
      Name := new String ' (Line(Top..current-1));
      Image := new String ' (Line(Current+1..Bot));
   end Parse;
   
   
   
   
   function Make (Names : in String; Value : in String) return Attribut_Record is
      Att : Attribut_Record;
   begin
      Att.Name := new String ' (Names);
      begin
	 Att.boo := Boolean'Value(Value);
	 Att.Enum := Boo;
	 Att.Value := new String ' (Boolean'Image(Att.Boo));
      exception
	 when Constraint_Error =>
	    begin
	       Att.Int := Integer'Value(Value);
	       Att.Enum := Int;
	       Att.Value := new String ' (Integer'Image(Att.Int));
	    exception
	       when Constraint_Error =>
		  begin
		     Att.Flt := float'Value(Value);
		     Att.Enum := Flt;
		     Att.Value := new String ' (Float'Image(Att.Flt));
		  exception
		     when Constraint_Error =>
			begin
			   Att.date := Formatting.Value(Value);
			   Att.Enum := Date;
			   Att.Value := new String ' (Formatting.Image(Att.Date));
			exception
			   when Constraint_Error =>
			      begin
				 Att.str := new String ' (Value);
				 Att.Enum := Str;
				 Att.Value := new String ' (Att.Str.all);
			      end;
			end;
		  end;
	    end;
      end;
      return Att;
   end Make;
   
   function names (Att : in Attribut_Record) return String is
   begin
      return Att.Name.all;
   end Names;
   function images (Att : in Attribut_Record) return String is
   begin
      case Att.Enum is
	 when Nil =>
	    return "";
	 when Boo =>
	    return Boolean'Image(Att.Boo);
	 when Int =>
	    return Integer'Image(Att.Int);
	 when Flt =>
	    return Float'Image(Att.Flt);
	 when Date =>
	   return Formatting.Image(Att.Date);
	 when Str =>
	    return Att.Str.all;
      end case;
   end Images;

end M.Attributes ; 
