-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-09-16 16:33:02 ; 
-- Version := 0.12.0a ; 
with M.Account;
use M.Account;
with Ada.Containers.Vectors;
use Ada.Containers;
package M.Accounts_manager is
   
   
   subtype Operation_Index is positive;
   function "=" (Left, Right : Operation_Record) return Boolean;
   package Operation_Vectors is new Vectors(Operation_Index, Operation_Record, "=");
   use Operation_Vectors;
   
   type Account_Manager is
      record
	 List : Vector;
	 Total : Float := 0.0;
      end record;
   
   
   
   
end M.Accounts_manager ; 
