-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-09-16 16:33:00 ; 
-- Version := 0.12.0a ; 
with Ada.Calendar;
use Ada.Calendar;
package M.Account is
   
   
   subtype Sum_Range is Float range -999_999_999.99 .. 999_999_999.99;
   
   subtype Step_Range is Integer range -3 .. 120;
   
   type Label_Access is access Wide_String;
   
   type Operation_Record is
      record
	 Label : Label_Access;
	 Sum   : Sum_Range := 0.0;
	 Step  : Step_Range := 0;
	 Date_Op : Time := Clock;
	 Date_Val : Time := Clock;
      end record;
      
   
   
   
end M.Account ; 
