-- Procedure Head is basic Head command.
-- Date := "2023-04-29" ; 
-- Version := "1.0.0b" ; 
-- Obtain the 'firsts' lines with command : head firsts FILE

with ada.wide_text_io;
use ada.wide_text_io;
with Ada.Command_Line;
use Ada.Command_Line;

procedure Head is
   
   Line_Count : Natural := 0;
   
   Head_Line : constant Integer := Integer'Value(Argument(1));
   
   Filename : constant String := Argument(Argument_Count);
   
   File : File_Type;
begin
   
   Open(File, In_File, Filename, Form => "WCEM=8");
   while not End_Of_File(File) loop
      declare
	 Line : constant Wide_String := Get_Line(File);
      begin
	 if Line_Count < Head_Line then
	    
	    Put(Line);
	    
	    if not End_Of_File(File) then
	       New_Line;
	    end if;
	    
	    Line_Count := Line_Count + 1;
	 else
	    exit;
	 end if;
      end;
   end loop;
   Close(File);   
end Head;


