-- Workstation is attempt of A. i. written with Ada.
-- Workstation is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-08-24 11:28:21"
-- Version := "4.0.47r"
with Ada.Characters.Handling;
use Ada.Characters;
with Text_Io;
use Text_Io;

package body Work.Windows is
   
   
   function Lines_Max return Line_Range is
   begin
      return Lines;
   end Lines_Max;
   function Cols_Max return Column_Range is
   begin
      return Columns;
   end Cols_Max;
   
   procedure Set_Color (Window : in out Window_Record; Color : Color_Type) is
      
   begin
      case Style is
	 when Black_And_Color | Black_And_White =>
	    null;
	 when others =>
	    Window.Win.Frame_Color := Color;
      end case;
   end Set_Color;
   
   
   procedure Initialize (Win : in out Window_Record;
			 Line_Pos : in Line_Range;
			 Col_Pos : in Column_Range;
			 Lines : in Line_Range;
			 Cols : in Column_Range;
			 Color : in Color_Type;
			 Box_Color : in Color_Type) is
   begin
      
      Win.Win.L := Line_Pos;
      
      Win.Win.C := Col_Pos;
      
      Win.Win.H := Lines;
      
      Win.Win.W := cols;
      
      Win.L := Line_Pos;
      
      Win.C := Col_Pos;
      
      Win.H := Lines;
      
      Win.W := cols;
      
      
      Win.Win.Frame_Type := Single_Line_Frame;
      
      case Style is
	 when Black_And_White | Black_And_color =>
	    
	    Win.Win.Frame_Color := black;
	    
	    Win.Win.Close_Box_Color := black;
	    
	 when White_And_Color =>
	    
	    Win.Win.Frame_Color := white;
	    
	    Win.Win.Close_Box_Color := white;
	    
	 when others =>
	    
	    Win.Win.Frame_Color := Color;
	    
	    Win.Win.Close_Box_Color := Box_Color;
      end case;
      
   end Initialize;
   
   procedure Draw_Window (Win : in Window_Record) is
   begin
      Enlight_Window(Win.Win);
   end Draw_Window;
   procedure Draw_Text (Win : in Window_Record; 
			Line : in Line_Range;
   			Col : in Column_Range;
			Color : in Color_Type; Text : in Wide_String) is
   begin      
      case Style is
	 when Black_And_White =>
            
	    Enlighted_Draw(Win.Win, Line, Col, white, Text);
	 when others =>   
	    Enlighted_Draw(Win.Win, Line, Col, color, Text);
      end case;
   end Draw_Text;
   
   procedure Draw_Text (Win : in Window_Record;
			Line : in Line_Range;
   			Col : in Column_Range;
			Color : in Color_Type; Text : in String) is
   begin
      case Style is
	 when Black_And_White =>
            
	    Enlighted_Draw(Win.Win, Line, Col, white, Handling.To_Wide_String(Text));
	 when others =>   
	    Enlighted_Draw(Win.Win, Line, Col, color, Handling.To_Wide_String(Text));
      end case;
     
   end Draw_Text;


end Work.Windows ; 
