-- Workstation is attempt of A. i. written with Ada.
-- Workstation is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-08-14 07:53:20"
-- Version := "4.0.0r"
with Ada.Containers.Doubly_Linked_Lists;
use Ada.Containers;

package Work.Wargame.search is
   
   generic
      type Element is private;
      with function Heuristic (E : Element) return Float;
      with function Uniform (E : Element) return Float;
      with function equal (Left, Right : Element) return Boolean;
      with function "<" (Left, Right : Element) return Boolean;      
      type El_Array is array (Positive range <>) of Element;
      with function Successors (E : Element) return El_Array;
   package Path_Finding is
      
      type Node_Record is private;
      
      package Element_Lists is new Ada.Containers.Doubly_Linked_Lists(Element, "=");
      
      package Elements_Sorting is new Element_Lists.Generic_Sorting ("<");
      
      use Element_Lists;
      
      subtype Element_List is Element_Lists.List;
      
      procedure Astar (Open : in Element_List;
         Close  : out Element_List);
      
      task Astar_Task is
        entry Init (Open : in Element_List);  
        entry Close_Set (Closed_Out : out Element_List; End_Of_Task : out Boolean);
        entry Halt;
      end Astar_Task;
      
   private
      type Node_Access is access Node_Record;
      
      type Node_Record is tagged
  record
     E : Element;
     Ucost : Float := 0.0;
     Hcost  : Float := 0.0;
  end record;      
      
      function Init return Node_Access;
      
      function Element_Of (Node : in Node_Record) return Element;
      
      
      procedure Adjust(N : in out Node_Record; E : in Element);
      
   end Path_Finding;

   
end Work.Wargame.search ; 
