-- Workstation is attempt of A. i. written with Ada.
-- Workstation is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-08-14 07:53:20"
-- Version := "4.0.0r"
with Work.Classes.Note_class;
with Work.Classes.Profile_class;
with Work.Classes.Car_class;
with Work.Classes.Contact_class;
with Work.Classes.Content_class;
with Work.Classes.Event_class;
with Work.Classes.Planning_class;
with Work.Classes.Job_class;
with Work.Classes.Machine_class;
with Work.Classes.Activity_class;
with Work.Classes.Universe_class;
with Work.Classes.Compta_Line_class;
with Work.Classes.Account_class;
with Work.Classes.Account_Line_class;
with Work.Classes.Component_class;
with Work.Classes.house_class;

package Work.Classes.Main is
   
   
   
   function Fit (Object : in Object_Class'class) return Float;
   procedure Mutate(Object : in out Object_Class'class);
   function Mute(Left : in Object_Class'class; 
                   Right : in Object_Class'class) return Object_Class'class;
   
   
   type Object_Array is array (Positive range <>) of Object_Access;
   function Successor (O : in Object_Access) return Object_Array;
   function "=" (Left, Right : Object_Class'class) return Boolean;
   function "<" (Left, Right : Object_Class'class) return Boolean;
   function Uniform (O : in Object_Class'class) return Float;
   function Heuristic (O : in Object_Class'class) return Float;
   
   function Copy (Object : Object_Access) return Object_Access;
   
   type Path_Finding is access function  (Start, Goal : in Object_Class'class) return Object_Vectors.Vector;
   

end Work.Classes.Main ; 
