--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Ada.Wide_Text_Io;
with Ada.Text_Io;
use Ada;
package body Gnos.Systems is
   procedure initialize(System_Context : in out System_Context_Record;
			System_Params  : in System_Parameters_Type) is
   begin
      
      System_Context.System_Params := Parameters.System_Parameters_Type(System_Params);
      
      Objects_system.Initialize(Objects_Context_Record(System_Context), Objects_Parameters_Type(System_Params));
   end Initialize;
   
   procedure Load_Project(System_Context : in out System_Context_Record;
			  Ada_Path : in String;
			  Gtk_Path : in String;
			  Aws_Path : in String;
			  Project_Path : in String) is
   begin
      
      
      Objects_system.Load_Project(Objects_Context_Record(System_Context), Ada_Path, Gtk_Path, Aws_Path, Project_Path);
   end Load_Project;
   

   function Check_Parameters(System_Context : in System_Context_Record'Class;
			     Params : in System_Parameters_Type'class) return Boolean is
      
      Checked : Boolean := False;
      
   begin
      
      Wide_Text_Io.Put("System Context :");
      
      Checked := System_Context.System_Params = System_Parameters_Type(Params);
      
      if not Checked then
	 Text_Io.New_Line;
	 if System_Context.System_Params.Self_Programming /= System_Parameters_Type(Params).Self_Programming then
	    Text_Io.Put_Line("Self_Programming : " & 
			       Boolean'Image(System_Context.System_Params.Self_Programming) & " /= " &
			       Boolean'Image(System_Parameters_Type(Params).Self_Programming));
	 end if;
	 if System_Context.System_Params.Self_Executed /= System_Parameters_Type(Params).Self_Executed then
	    Text_Io.Put_Line("Self_Executed : " & 
			       Boolean'Image(System_Context.System_Params.Self_Executed) & " /= " &
			       Boolean'Image(System_Parameters_Type(Params).Self_Executed));	    
	 end if;
	 
	 raise Program_Error;
      end if;      
      Wide_Text_Io.Put("Ok, ");
      
      Checked := Checked and Objects_system.Check_Parameters(Objects_Context_Record(System_Context), Params);      
      return Checked;
   end Check_Parameters;




    function Random_name(char_index : in char_index_type) return string is
		
    begin
       Objects_system.Name_8.Reset;
       Objects_system.Name_12.Reset;
       Objects_system.Name_16.Reset;
       case char_index is
	  when 1..8 =>
	     return Name_8.random(char_index);
	  when 9..12 =>
	     return Name_12.random(char_index);
	  when 13..16 =>
	     return Name_16.random(char_index);
	  when others =>
	     return "system: random_name:the string is to long";
       end case;
    end random_name;
end Gnos.Systems;

