-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Engine ;
with El.Player ; 
with El.Privat ;
with el.Classe ;
with El.window ;
generic
   Glossary_Filename : String;
   Width_Line :Word_Range;
   Max_Words : Lexical_Range;
   Samples_Max : Positive;
   Network_Filename : String;
   Lines  : Line_Range;
   Cols   : Column_Range;
   with package Classes is new el.Classe (<>);
   with package Window is new El.Window (<>);

package El.Server is
   type Server_Interface_Record is limited private;   
   
   type Server_Interface_Access is access Server_Interface_Record;
   
   type Server_Record;
   
   task type Server_Process (The_Server : access Server_Record) is
      entry Initialize;
      entry Halt(End_Of_Program : out Boolean);
   end Server_Process;
   package Engine is new El.Engine (Glossary_Filename, Width_Line, Max_Words, Samples_Max, Network_Filename, Lines,  Cols, Classes, 
				     
				     window);
   
   
   type Server_Record is new Engine.Engine_Record with 
      record
	 Server_Proc : Server_Process (Server_Record ' access);
	 Server_Int  : Server_Interface_Access;
      end record;
   
   type Server_Access is access all Server_Record;
   
   
private
   
   task type Server_Interface_Process(Int : access Server_Interface_Record) is
      entry Init;
      entry Halt;
   end Server_Interface_Process;
   
   type Server_Interface_Record is tagged limited
      record
	 Server_Int_Proc : Server_Interface_Process (Server_Interface_Record ' access);
      end record;
   

end El.Server ; 
