-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   <one line to give the program's name and a brief idea of what it does.>
--   Copyright (C) 19yy  <name of author>
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Strings;
with Ada.Strings.Wide_Unbounded;
with Ada.Unchecked_Deallocation;
with Gnat.Os_Lib;
use Gnat;

package El.Result is
   use Strings;
   subtype U_String is Ada.Strings.Wide_Unbounded.Unbounded_Wide_String;
   use type U_String;
   
   function "+"(S: Wide_String) return U_String
     renames Ada.Strings.Wide_Unbounded.To_Unbounded_Wide_String;
 
   function "-"(U: U_String) return Wide_String
     renames Ada.Strings.Wide_Unbounded.To_Wide_String;
 
   type U_Array is array(Positive range <>) of U_String;
   
   type U_array_Access is access U_Array;
   
   procedure U_array_Free is new Ada.Unchecked_Deallocation 
     (U_Array, U_Array_Access);
   
   
   type Result_Enum is (File, Search, Spawn);
   
   type Result_Record (Name : Result_Enum) is tagged
      record
	 Wlines : U_Array_Access;
	 Count  : Natural := 0;
	 Initialized : Boolean := False;
	 case Name is
	    when File =>
	       null;
	    when Search =>
	       Pattern   : Wide_String_Access := new Wide_String ' ("");
	       Address   : Os_Lib.String_Access;
	       Doc_Name  : Wide_String_Access;
	    when Spawn =>
	       Process_Id     : Gnat.Os_Lib.Process_Id;
	       Program_Name   : U_String;
	       Args           : Os_Lib.Argument_List_Access;	 
	       Output_File    : U_String;
	       Success        : Boolean := False;
	       Return_Code    : Integer := 0;
	       Err_To_Out     : Boolean := False;	 
	 end case;
	 
      end record;   
   
   type Wide_Result_Access is access all Result_Record'Class;
   
   procedure Wide_Result_Free is new Ada.Unchecked_Deallocation(Result_Record'Class, Wide_Result_Access);
   
   type Spawn_Result_Record is new Result_Record(Spawn) with null record;
   type File_Result_Record is new Result_Record(File) with null record;
   type Search_Result_Record is new Result_Record(Search) with null record;

end El.Result ; 
