-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Neural;
with El.Lexics;
use El.Lexics;
with El.Generic_Extended_Binary_Code;

with PragmARC.Rem_Nn_Wrapper;
use PragmARC.Rem_Nn_Wrapper;

with Ada.Wide_Text_Io;
use Ada.Wide_Text_Io;
use Ada;
with Gnat.Semaphores;
use Gnat.Semaphores;
generic
   Glossary_Filename : String;
   Width_Line :Word_Range;
   Max_Words : Lexical_Range;
   Samples_Max : Positive;
   Network_Filename : String;   
   type Word_Type is (<>);
   
   with package Glossary is new Lexics.Glossary (<>);
package El.Hander is
   use Glossary;
   --pragma prellaborate_body (El.Hander);
   
   
   
   

   Word_Size : constant Word_Size_Range := Nb_Binary_Digits(Max_Words);
   
   Inum : constant Layer_Width_range := Word_Size * Width_line;
   Onum : constant Layer_Width_range := Word_Size * Width_line;
   Hnum : constant Layer_Width_range := Width_line;
   
   
   
   
   package Neural_Train is new  Neural.Neuro_Process
     (Inum,
      hnum,
      Onum,
      Samples_max,
      Network_Filename & ".wgt1");
   
   
   package Neural_Retrain is new Neural.Neuro_Process
     (Inum,
      hnum,
      Onum,
      2,
      Network_Filename & ".wgt2");
   
   
   
   use Neural_Retrain;
   package Coded_word is new Generic_Extended_Binary_Code(Word_Size, Word_Type);
   use Coded_Word;
   procedure Init_Samples(Samples  : in out Neural_Train.Sample_Set_Type;
   			  Words    : out Glossary_Type;
   			  Filename : in String);
   
   function String2input (Line : in Wide_String; Words : in out Glossary_Type) return Input_Type;
   function Output2string(Output : Output_Type; Words : in Glossary_Type) return Wide_String;
	 
   
   type Hander_record is tagged limited 
      record
	 Hander_Lock : Binary_Semaphore (True, Default_Ceiling);
      end record;

end El.Hander ; 
