-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with Text_Io;
with Ada.Wide_Text_Io;
with Ada.Strings.Wide_Fixed;
use Ada.Strings.Wide_Fixed;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
package body El.French is
   package W_Io renames Ada.Wide_Text_Io;
   use W_Io;
   procedure Initialize (From_Lexic_Filename : in String) is
      
      Lexique_File : W_Io.File_Type;
      
      
      Null_Count : Natural := 0;
      nom_Count : Natural := 0;
      Ver_Count : Natural := 0;
      adj_Count : Natural := 0;
      adv_Count : Natural := 0;
      aux_Count : Natural := 0;
      con_Count : Natural := 0;
      pre_Count : Natural := 0;
      pro_Count : Natural := 0;
      ono_Count : Natural := 0;      
      Art_Count : Natural := 0;
      
      Total_Count : Natural := 0;
   begin
      
      W_Io.Put_Line("Loading data/Lexique383.tsv");
      
      W_Io.Open(Lexique_File, W_Io.In_File, "data/Lexique383.tsv", Form => "WCEM=8");
      W_Io.Put_Line("data/Lexique383.tsv opened");
      while not End_Of_File(Lexique_File) loop
	 declare
	    Line : Wide_String_Access;
	    Genre_Top_Index : Natural := 0;
	    Genre_End_Index : Natural := 0;
	    word_Top_Index : constant Natural := 1;
	    Word_End_Index : Natural := 0;
	    Word : Wide_String_Access;
	    Genre_name : access Wide_String;
	    Genre : Fr_Gram_Enum := Null_Gram;
	    Instruction : Wide_String_Access; 	      	 	 
	    Next_Tab : Natural := 0;
	 begin
	    Line := new Wide_String ' (Get_Line(Lexique_File));
	    
	    if Line /= null and then Line'Length /= 0 then
	       for I in 1..3 loop
		  Genre_Top_Index := Index (Line(Genre_Top_Index+1..Line'Last), Wide_Character'Val(9) & "");
	       end loop;
	       Genre_End_Index := Index (Line(Genre_Top_Index+1..Line'Last), Wide_Character'Val(9) & "");
	       if Genre_Top_Index /= 0 and Genre_End_Index /= 0 then
		  Genre_Name := new Wide_String ' (Line(Genre_Top_Index + 1 .. Genre_End_Index -1));

		  if Genre_Name.all = "ART" then
		     Genre := Art;
		  elsif Genre_Name.all = "NOM" then
		     Genre := Nom;
		  elsif Genre_Name.all = "VER" then
		     Genre := Ver;
		  elsif Genre_Name.all = "ADJ" then
		     Genre := adj;
		  elsif Genre_Name.all = "ADV" then
		     Genre := Adv;
		  elsif Genre_Name.all = "AUX" then
		     Genre := Aux;
		  elsif Genre_Name.all = "CON" then
		     Genre := Con;
		  elsif Genre_Name.all = "PRO" then
		     Genre := Pro;
		  elsif Genre_Name.all = "PRE" then
		     Genre := PRE;
		  elsif Genre_Name.all = "ONO" then
		     Genre := Ono;
		  else
		     Genre_End_Index := Index (Line(Genre_Top_Index+1..Genre_End_Index), ":", Ada.Strings.Backward);
		     Genre_Name := new Wide_String ' (Line(Genre_Top_Index + 1 .. Genre_End_Index -1));
		  end if;
	       end if;
	       
	       if Genre_Name /= null and then Genre_Name'Length /= 0 then
		  
		  
		  if Genre_Name.all = "ART" then
		     Genre := Art;
		  elsif Genre_Name.all = "NOM" then
		     Genre := Nom;
		  elsif Genre_Name.all = "VER" then
		     Genre := Ver;
		  elsif Genre_Name.all = "ADJ" then
		     Genre := adj;
		  elsif Genre_Name.all = "ADV" then
		     Genre := Adv;
		  elsif Genre_Name.all = "AUX" then
		     Genre := Aux;
		  elsif Genre_Name.all = "CON" then
		     Genre := Con;
		  elsif Genre_Name.all = "PRO" then
		     Genre := Pro;
		  elsif Genre_Name.all = "PRE" then
		     Genre := PRE;
		  elsif Genre_Name.all = "ONO" then
		     Genre := Ono;
		  end if;
		  --Genre := Fr_Gram_Enum'Value(To_String(Genre_Name.all)); 
		  
		  Word_End_Index := Index (Line(Word_Top_Index .. Line'Last), Wide_Character'Val(9) & "");	 
		  
		  if Word_End_Index /= 0 and Word_End_Index < 32 then
		     
		     word := new Wide_String ' (Line(Word_Top_Index .. Word_End_Index-1));
		     
		     if Word /= null then
			Total_Count := Total_Count + 1;
			case Genre is
			   when Nom =>
			      Nom_Count := Nom_Count + 1;
			   when Ver =>
			      Ver_Count := Ver_Count + 1;
			   when Adj =>
			      Adj_Count := Adj_Count + 1;
			   when Adv =>
			      Adv_Count := Adv_Count + 1;
			   when Aux =>
			      Aux_Count := Aux_Count + 1;
			   when Con =>
			      Con_Count := Con_Count + 1;
			   when Pre =>
			      Pre_Count := Pre_Count + 1;
			   when Pro =>
			      Pro_Count := Pro_Count + 1;
			   when Ono =>
			      Ono_Count := Ono_Count + 1;
			   when Art =>
			      Art_Count := Art_Count + 1;
			   when Null_Gram =>
			      Null_Count := Null_Count + 1;
			   when others =>
			      Total_Count := Total_Count - 1;
			end case;
		     end if;
		  end if;
	       end if;
	    end if;
	    Wide_Free(Line);
	    Wide_Free(Word);
	    Wide_Free(Genre_Name);
	 end;
	 Text_Io.Put(Character'Val(13) & Integer'Image(Total_Count));
      end loop;
      
      W_Io.Close(Lexique_File);
      Text_Io.New_Line;
      
      Text_Io.Put_Line("Voici le décompte du lexique français : ");
      Text_Io.Put_Line(Natural'Image(Nom_Count) & " noms ;");
      Text_Io.Put_Line(Natural'Image(Ver_Count) & " verbes ;");
      Text_Io.Put_Line(Natural'Image(Adj_Count) & " adjectifs ;");
      Text_Io.Put_Line(Natural'Image(Adv_Count) & " adverbes ;");
      Text_Io.Put_Line(Natural'Image(Aux_Count) & " auxiliaires ;");
      Text_Io.Put_Line(Natural'Image(Con_Count) & " conjonctions ;");
      Text_Io.Put_Line(Natural'Image(Pre_Count) & " prepositions ;");
      Text_Io.Put_Line(Natural'Image(Pro_Count) & " pronoms ;");
      Text_Io.Put_Line(Natural'Image(Ono_Count) & " onomatopés ;");
      Text_Io.Put_Line(Natural'Image(Null_Count) & " sans genre ;");
      
      
      Fr_Glossary(1) := new Word_Array (1..Nom_Count);
      Fr_Glossary(2) := new Word_Array (1..Ver_Count);
      Fr_Glossary(3) := new Word_Array (1..Adj_Count);
      Fr_Glossary(4) := new Word_Array (1..Adv_Count);
      Fr_Glossary(5) := new Word_Array (1..Aux_Count);
      Fr_Glossary(6) := new Word_Array (1..Con_Count);
      Fr_Glossary(7) := new Word_Array (1..Pre_Count);
      Fr_Glossary(8) := new Word_Array (1..Pro_Count);      
      Fr_Glossary(9) := new Word_Array (1..Art_Count);
      Fr_Glossary(10) := new Word_Array (1..Ono_Count);
      
      Null_Count := 0;
      nom_Count := 0;
      Ver_Count := 0;
      adj_Count := 0;
      adv_Count := 0;
      aux_Count := 0;
      con_Count := 0;
      pre_Count := 0;
      pro_Count := 0;
      ono_Count := 0;      
      Art_Count := 0;
      Total_Count := 0;
      W_Io.Open(Lexique_File, W_Io.In_File, "data/Lexique383.tsv", Form => "WCEM=8");
      while not End_Of_File(Lexique_File) loop
	 declare
	    Line : Wide_String_Access;
	    Genre_Top_Index : Natural := 0;
	    Genre_End_Index : Natural := 0;
	    word_Top_Index : constant Natural := 1;
	    Word_End_Index : Natural := 0;
	    Word : Wide_String_Access;
	    Genre_name : access Wide_String;
	    Genre : Fr_Gram_Enum := Null_Gram;
	    Instruction : Wide_String_Access; 	      	 	 
	    Next_Tab : Natural := 0;
	 begin
	    
	    Line := new Wide_String ' (Get_Line(Lexique_File));
	    
	    if Line /= null and then Line'Length /= 0 then
	       for I in 1..3 loop
		  Genre_Top_Index := Index (Line(Genre_Top_Index+1..Line'Last), Wide_Character'Val(9) & "");
	       end loop;
	       
	       Genre_End_Index := Index (Line(Genre_Top_Index+1..Line'Last), Wide_Character'Val(9) & "");
	       
	       if Genre_Top_Index /= 0 and Genre_End_Index /= 0 then
		  Genre_Name := new Wide_String ' (Line(Genre_Top_Index + 1 .. Genre_End_Index -1));

		  if Genre_Name.all = "ART" then
		     Genre := Art;
		  elsif Genre_Name.all = "NOM" then
		     Genre := Nom;
		  elsif Genre_Name.all = "VER" then
		     Genre := Ver;
		  elsif Genre_Name.all = "ADJ" then
		     Genre := adj;
		  elsif Genre_Name.all = "ADV" then
		     Genre := Adv;
		  elsif Genre_Name.all = "AUX" then
		     Genre := Aux;
		  elsif Genre_Name.all = "CON" then
		     Genre := Con;
		  elsif Genre_Name.all = "PRO" then
		     Genre := Pro;
		  elsif Genre_Name.all = "PRE" then
		     Genre := PRE;
		  elsif Genre_Name.all = "ONO" then
		     Genre := Ono;
		  else
		     Genre_End_Index := Index (Line(Genre_Top_Index+1..Genre_End_Index), ":", Ada.Strings.Backward);
		     Genre_Name := new Wide_String ' (Line(Genre_Top_Index + 1 .. Genre_End_Index -1));
		  end if;
	       end if;
	       
	       if Genre_Name /= null and then Genre_Name'Length /= 0 then
		  
		  
		  if Genre_Name.all = "ART" then
		     Genre := Art;
		  elsif Genre_Name.all = "NOM" then
		     Genre := Nom;
		  elsif Genre_Name.all = "VER" then
		     Genre := Ver;
		  elsif Genre_Name.all = "ADJ" then
		     Genre := adj;
		  elsif Genre_Name.all = "ADV" then
		     Genre := Adv;
		  elsif Genre_Name.all = "AUX" then
		     Genre := Aux;
		  elsif Genre_Name.all = "CON" then
		     Genre := Con;
		  elsif Genre_Name.all = "PRO" then
		     Genre := Pro;
		  elsif Genre_Name.all = "PRE" then
		     Genre := PRE;
		  elsif Genre_Name.all = "ONO" then
		     Genre := Ono;
		  end if;
		  --Genre := Fr_Gram_Enum'Value(To_String(Genre_Name.all)); 
		  
		  Word_End_Index := Index (Line(Word_Top_Index .. Line'Last), Wide_Character'Val(9) & "");	 
		  
		  if Word_End_Index /= 0 and Word_End_Index < 32 then
		     
		     word := new Wide_String ' (Line(Word_Top_Index .. Word_End_Index-1));
		     
		     if Word /= null then
			
			Total_Count := Total_Count + 1;
			case Genre is
			   when Nom =>
			      Nom_Count := Nom_Count + 1;
			      Fr_Glossary(1)(Nom_Count) := new Nom_Record ' (Lex => Word, Genre => Nom);
			   when Ver =>
			      Ver_Count := Ver_Count + 1;
			      Fr_Glossary(2)(Ver_Count) := new Ver_Record ' (Lex => Word, Genre => ver);
			   when Adj =>
			      Adj_Count := Adj_Count + 1;
			      Fr_Glossary(3)(Adj_Count) := new Adj_Record ' (Lex => Word, Genre => Adj);
			   when Adv =>
			      Adv_Count := Adv_Count + 1;
			      Fr_Glossary(4)(Adv_Count) := new Adv_Record ' (Lex => Word, Genre => Adv);
			   when Aux =>
			      Aux_Count := Aux_Count + 1;
			      Fr_Glossary(5)(Aux_Count) := new Aux_Record ' (Lex => Word, Genre => Aux);
			   when Con =>
			      Con_Count := Con_Count + 1;
			      Fr_Glossary(6)(Con_Count) := new Con_Record ' (Lex => Word, Genre => Con);
			   when Pre =>
			      Pre_Count := Pre_Count + 1;
			      Fr_Glossary(7)(Pre_Count) := new Pre_Record ' (Lex => Word, Genre => Pre);
			   when Pro =>
			      Pro_Count := Pro_Count + 1;
			      Fr_Glossary(8)(Pro_Count) := new Pro_Record ' (Lex => Word, Genre => Pro);
			   when Art =>
			      Art_Count := Art_Count + 1;
			      Fr_Glossary(9)(Art_Count) := new Art_Record ' (Lex => Word, Genre => Art);
			   when Ono =>
			      Ono_Count := Ono_Count + 1;
			      Fr_Glossary(10)(Ono_Count) := new Ono_Record ' (Lex => Word, Genre => Ono);
			   when Null_Gram =>
			      Null_Count := Null_Count + 1;
			   when others =>
			      Total_Count := Total_Count - 1;
			end case;
			
		     end if;
		  end if;
	       end if;
	    end if;
	    
	    Wide_Free(Line);
	    
	 end;
	 Text_Io.Put(Character'Val(13) & Integer'Image(Total_Count));
	 
      end loop;
	       
      W_Io.Close(Lexique_File);
      
      Text_Io.Put_Line("Done");
      
   exception
      when End_Error =>
	 raise ;
      
   end Initialize;
   
end El.French ; 
