-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Player ;
with El.Aiinfo ;
with El.Docume ;
with El.Result ;
with El.Axiome ;
with El.Boards ;
with El.Intell ;
with El.Engine ;
with El.Classe ;
with El.Strings;

with Gnat.Sockets;
use Gnat.Sockets;
generic
   with package Classes is new El.Classe (<>);
   with package Engine is new El.Engine (<>);
package El.Elhoim is
   use Player ;
   use Engine ;
   use Engine.Intelligency;
   use Engine.Intelligency.Classes;
   use Engine.Intelligency.Classes.Abstracted_Vectors;
   use Strings;

   type Elhoim_Task(T : access Terminal_record);
   
   
   -- Elhoim must find the ordored list of created object to obtain the goal object.
   
   task type Elhoim_Process (World : access Elhoim_Task) is
      
      entry Think (Object : in out Abstracted_Access);
      entry Send (Object : out Abstracted_Access);
      
      entry Send (Wline : out Wide_String_Access);
      entry Receive (Wline : in Wide_String);
      
      entry Find (New_Tree : in Abstracted_Class ' Class);
                  
   end Elhoim_Process;
   
   type Elhoim_Task(T : access Terminal_record) is limited
      record
	 Visitor : Player.Player_Record(Human_Player, 2);
	 Ai_Info : Aiinfo.Aiinfo_Record;
	 Doc_Ptr : Docume.Docume_Access;
	 Exec_Result : Result.Wide_Result_Access;
	 Domain : Ai_Domain_Record (128);	 
      end record;
     

end El.Elhoim ; 
