-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with Ada.Text_Io;
use Ada;
with Gnat.Sha1;
use Gnat;

package body El.Client is
   
   task body Client_Process is
   begin
      null;
   end Client_Process;
   
   
   task body Textual_Thread_Type is
      
      End_Of_Task : Boolean := False;
            
      Running : Boolean := False;      
      
      Inputs_Buffer : array (1..12) of String_Access;
      Inputs_Buffer_Last : Natural := 0;
      
      Outputs_Buffer : array (1..12) of String_Access;
      Outputs_Buffer_Last : Natural := 0;
      
      
      
   begin            
      --  accept Initialize (Errno : out Integer) do
	 
      --  	 Errno := 0;
      --  end Initialize;
      Running := True;               
      Text_Io.Put(" OS Starting... ");	       		              
      Text_Io.New_Line;
      
      Text_Io.New_Line;            
      loop
	 select	             
	    accept Halt do
	       Running := False;	       
	       Text_Io.Put(" OS Stopping... ");	       
	    end Halt;	    
	    exit;
      	 or
	    accept Receive(Text : in String) do
	       Text_Io.Put(" OS Receive text from : " & Text);
	       if Inputs_Buffer_Last = Inputs_Buffer'Length then
		  String_Free(Inputs_Buffer(1));
		  for I in 2..Inputs_Buffer_Last loop
		     
		     Inputs_Buffer(I-1) := Inputs_Buffer(I);
		  end loop;
		  Inputs_Buffer_Last := Inputs_Buffer_Last - 1;
	       end if;
	       --Free_String(Inputs_Buffer(Inputs_Buffer_Last+1));
	       Inputs_Buffer(Inputs_Buffer_Last+1) := new String ' (Text);
	       Inputs_Buffer_Last := Inputs_Buffer_Last + 1;
	       
	    end Receive;
	 or
	    when Outputs_Buffer_Last > 0 =>
	       accept Send(Text : out String_Access) do
		  Text := new String ' (Outputs_Buffer(1).all);		  
		  
		  if Outputs_Buffer_Last > 0 then
		     String_Free(Outputs_Buffer(1));
	    	     for I in 2..Outputs_Buffer_Last loop
	    		Outputs_Buffer(I-1) := Outputs_Buffer(I);
	    	     end loop;
	    	     Outputs_Buffer_Last := Outputs_Buffer_Last - 1;	    	     
	    	  end if;		  	    	  		  
		  
	       end Send;	       	    
	       
         or
	    when Outputs_Buffer_Last = 0 =>
	       accept Send(Text : out String_Access) do
		  Text := null;
	       end Send;	       	    
         or
	    
	    when Running and (Inputs_Buffer_Last > 0) =>
	       accept Exhauste(Text : out String_Access) do
	    	  Text := Inputs_Buffer(1);	    	  		  
		  
		  if Inputs_Buffer_Last > 0 then
		     
		     for I in 1..Inputs_Buffer_Last-1 loop
			
			Inputs_Buffer(I) := Inputs_Buffer(I+1);
		     end loop;
		     Inputs_Buffer_Last := Inputs_Buffer_Last - 1;
		  end if;
		  
		  if Outputs_Buffer_Last > 0 then
		     String_Free(outputs_Buffer(1));
	    	     for I in 1..Outputs_Buffer_Last-1 loop
	    	  	Outputs_Buffer(I) := Outputs_Buffer(I+1);
	    	     end loop;
	    	     Outputs_Buffer_Last := Outputs_Buffer_Last - 1;	    	     
	    	  end if;		  
		  String_Free(outputs_Buffer(Outputs_Buffer_Last+1));
		  Outputs_Buffer(Outputs_Buffer_Last+1) := new String ' (Text.all);
	    	  Outputs_Buffer_Last := Outputs_Buffer_Last + 1;		  		  
	       end Exhauste;
	 end select;
	 
      end loop;      
   end Textual_Thread_Type;

end El.Client ; 
