-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with ANSI_Console;
use ANSI_Console;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Wide_Fixed;
use Ada.Strings;

package body El.Classe.Planning_class is
   
   function ressources_Value(Line : in Wide_String) return Wstring_32 is
      Description : Wstring_32 := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2 : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), """");
      Last_3 : Natural := Wide_Fixed.Index(Line(Last_2+1..Line'Last), """");
      
   begin
      if Next /= 0 then
	 Wide_Fixed.Move(Line(Last_2+1..Last_3-1), Description);
      end if;      
      return Description;
   exception
      when others =>
	 return Description;
   end ressources_Value;
   
   
   function Get_Date_from(Line : in Wide_String) return time is
      
      Date  : Time := Clock;
      Index : Natural := Wide_Fixed.Index(Line, """");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), """");
      Last  : Natural := Wide_Fixed.Index(Line(Next..Line'Last), " "); 
   begin
      
      if Last /= 0 then
	 Date := Formatting.Value(To_String(Line(last+1..Last+19)));
      end if;      
      return Date;
   exception
      when others =>
	 return Date;
   end Get_Date_from;
				  
   function Get_Date_To(Line : in Wide_String) return time is
	 
      Date  : Time := Clock;
      Index : Natural := Wide_Fixed.Index(Line, """");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), """");
      Last  : Natural := Wide_Fixed.Index(Line(Next..Line'Last), " "); 
   begin
      
      if Last /= 0 then
	 Date := Formatting.Value(To_String(Line(last+21..Last+39)));
      end if;      
      return Date;
   exception
      when others =>
	 return Date;
   end Get_Date_To;
   
   
   -----------------------------------------------------------------------------
   --                  Planning                                                 --
   
   procedure Help(Planning    : in out Planning_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Red, "create Planning : help");
      Draw(Win, Win_Index+2, 3, Cyan,
	   "Name is string 16.");
      Draw(Win, Win_Index+3, 3, Cyan,
	   "Description is quotted string 32.");
      Draw(Win, Win_Index+4, 3, Cyan,
	   "From/To is date : 2021-04-22 00:00:00");      
      Draw(Win, Win_Index+5, 3, Cyan,
	   "Create Planning NAME ""Description"" From To");
      Win_Index := Win_Index + 6;
      Wide_Fixed.Move("help", Name, Error, Left, ' ');
   end Help;
   
   
   procedure Print (Object : Planning_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Cyan, "Index   : " &
	     To_Wide_String(Abstracted_Index'Image(Object.Index)));
      
      Draw(Win, Win_Index+2, 3, Cyan, "Name        : " & Object.Name);
      Draw(Win, Win_Index+3, 3, Cyan, "Created     : "
	     & To_Wide_String(Image(Object.Create_Date)));      
      
      Draw(Win, Win_Index+4, 3, Cyan, "From        : "
	     & To_Wide_String(Image(Object.from)));      
      Draw(Win, Win_Index+5, 3, Cyan, "To          : "
	     & To_Wide_String(Image(Object.to)));      
      
      Draw(Win, Win_Index+6, 3, Cyan, "Description : " & Object.Description(1..16));
      Draw(Win, Win_Index+7, 3, Cyan, Object.Description(17..32));
                        
      Win_Index := Win_Index + 8;
      
      Draw(Win, Win_Index+1, 3, Cyan, "Definition " & Object.Name);
      Win_Index := Win_Index + 1;
      for I in 1..Object.Def.Index loop
	 Draw(Win, Win_Index+1, 3, Cyan, "Attr " & To_Wide_String(Natural'Image(I)) & " : " &
		To_Wide_String(Object.Def.List(I).Names) & '=' & To_Wide_String(Object.Def.List(I).Image));
	 Win_Index := Win_Index + 1;
      end loop;
      
      Name := Object.Name;
   end Print;
   
function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Name      : in Name_Type;
		   description   : in Wstring_32;
		   From          : in Time;
		   To            : in Time) return Abstracted_Access is
      
      
      O : Abstracted_Access := new Planning_Class;
      Label : Name_Type;
   begin
      if O /= null then
	 Wide_Fixed.Move(Name, O.Name, Error, Left, ' ');
	 
	 Planning_Class(O.all).description := Description;
	 Planning_Class(O.all).From := From;
	 Planning_Class(O.all).To := To;
	 Planning_Class(O.all).Print(Win, Win_Index, Label);
	 
	 return O;
      else
	 return null;
      end if;
   end Create;
   procedure Write (O : in Planning_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Tag_Name'Image(Abstracted_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstracted_Index'Image(O.Index)));      
      W_Io.Put_Line(File, O.Name);
      W_Io.Put_Line(File, To_Wide_String(Image(O.Create_Date)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.from)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.to)));
      W_Io.Put_Line(File, O.Description);
      
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Def.Index)));
      for I in 1..O.Def.Index loop
	 W_Io.Put_Line(File, To_Wide_String(O.Def.List(I).Names) & '=' & To_Wide_String(O.Def.List(I).Image));
      end loop;
      
   end Write;
   procedure Read (O : in out Planning_Class;File : in W_Io.File_Type) is
      Name_Last : Natural := 0;
      Empty : Wide_String (1..19);
      Line : Wide_String(1..80);
      Empty_Last : natural := 0;
      
      
      Att_Index : Natural := 0;
   begin
      
      W_Io.Get_Line(File, Empty, Empty_Last); 
      
      O.Index := Integer'Value(To_String(W_Io.Get_Line(File)));      
      
                  
      
      W_Io.Get_Line(File, O.Name, Name_last);
      W_Io.Get_Line(File, line, Empty_Last); 
      W_Io.Get_Line(File, line, Empty_Last); 
      
      O.Create_Date := Value(To_String(Line(1..Empty_last)));      
      
      W_Io.Get_Line(File, line, Empty_Last); 
      
      O.From := Value(To_String(Line(1..Empty_last)));      
      
      
      W_Io.Get_Line(File, line, Empty_Last); 
      W_Io.Put(line(1..Empty_last));
      W_Io.Put(To_Wide_String(Integer'Image(Empty_Last)));
      O.To := Value(To_String(Line(1..Empty_last)));
      
      W_Io.Get_Line(File, O.description, Empty_Last); 
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;

      Att_Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      for I in 1..Att_Index loop
	 declare
	    Tags      : String_Access;
	    Image     : String_Access;
	 begin
	    Parse(W_Io.Get_Line(File), Tags, Image);
	    O.Def.List(I) := Make (Tags.all, Image.all);
	    O.Def.Index := O.Def.Index + 1;
	 end;
      end loop;
      
   end Read;
   
   procedure Random (O : in out Planning_Class) is
   begin
      null;
   end Random;
   --
   -----------------------------------------------------------------------------

end El.Classe.Planning_class ; 
