-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Strings;
generic

package El.Classe.Contacts_class is
   use Strings;
   --------------------------------------------------------------------------
   --                    Contact
   
   function contact_Value(Line : in Wide_String) return Name_Type;
     
   subtype Tel_Num_Type is Wide_String(1..12);
   
   function Tel_num_Value(Line : in Wide_String) return Tel_Num_Type;
     
   type Contact_Class is new Abstracted_Class(Contact) with
      record
	 Tel : Tel_Num_Type := (others => Wide_Character'Val(32));	 
      end record;
   
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Tel       : in Tel_Num_Type;
		   Name      : in Name_Type) return Abstracted_Access;
   
   
   procedure Print (Object    : in Contact_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type);
   
   procedure Help(Contact    : in out Contact_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type);
   
   procedure Write (O : in Contact_Class;File : in W_Io.File_Type);
   procedure Read (O : in out Contact_Class;File : in W_Io.File_Type);
   
   procedure Random (O : in out Contact_Class);
   --                 End Contact
   --------------------------------------------------------------------------

end El.Classe.Contacts_class ; 
