-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with Ada.Strings.Fixed;
use Ada.Strings.Fixed;

package body El.Axiome is
   function Veritable(Line : in String) return Boolean is
   begin
      if Line = En_Veritable then
	 return True;
      end if;
      return False;
   end Veritable;
   
   function veracity (Line : in String) return Boolean is
   begin
      if Line /= En_Contraire then
	 return True;
      end if;
      return False;
   end Veracity;
   
   
      
   package body Main_Work is
      
      function To_Boolean (Verite : in Binaire) return Boolean is
      begin
	 if Verite = Vrai then
	    return True;
	 end if;
	 return False;
      end To_Boolean;
      
      function To_Binaire(Veracity : in Boolean) return Binaire is
      begin
	 if Veracity then
	    return Vrai;
	 end if;
	 return Faux;
      end To_Binaire;
   
      
      function "not" (Veracite : Binaire) return Binaire is
      begin
	 if Veracite = Vrai then
	    return Faux;
	 else
	    return Vrai;
	 end if;
      end "not";

      function "and" (Left, Right : Binaire) return Binaire is
      begin
	 if ((Left = Vrai) and (Right = Vrai)) then
	    return Vrai;
	 else
	    return Faux;
	 end if;
      end "and";
      
      function "or" (Left, Right : Binaire) return Binaire is
      begin
	 return not ((not Left) and (not (Right)));
      end "or";

      function  From_line (Line : in String) return Result_Record is
	    Result : Result_Record;
	    
	    Step : Natural := 0;      
	 begin
	    Step := Index(Line, "have" );
	    if Step /= 0 then
	       Result.Have := True;
	    end if;
	    Step := Index(Line, "know" );
	    if Step /= 0 then
	       Result.Know := True;
	    end if;
	    Step := Index(Line, "reason" );
	    if Step /= 0 then
	       Result.Reason := True;
	    end if;
	    Step := Index(Line, "freedom" );
	    if Step /= 0 then
	       Result.Freedom := True;
	    end if;
	    Step := Index(Line, "peace" );
	    if Step /= 0 then
	       Result.peace := Nice;
	    end if;
	    Step := Index(Line, "love" );
	    if Step /= 0 then
	       Result.love := Nice;
	    end if;
	    Step := Index(Line, "war" );
	    if Step /= 0 then
	       Result.Peace := Uncknow;
	       Result.Love := Uncknow;           
	       Result.war := bad;
	    end if;
	    return Result;
	 end From_Line;
	 
	 function To_String (Result : in Result_Record) return String is
	    Line : access String;
	 begin
	    if (Result.Know and Result.Have) and (Result.Reason and Result.Freedom) and ((Result.Love = nice) and (Result.Peace = nice)) then
	       Line := new String ' ("we have peace and we know love in reason and in freedom" );
	    elsif ((Result.Know or Result.Have) and (Result.Reason or Result.Freedom)) and (Result.Peace = nice)  then  
	       Line := new String ' ("we have peace in reason or in freedom" );
	    elsif ((Result.Know and Result.Have) and (Result.Reason and Result.Freedom)) and (Result.Love = nice) then
	       Line := new String ' ("we know love in reason or in freedom" );
	    elsif (Result.Have) then
	       if Result.Peace = Nice then
		  Line := new String ' ("we have peace" );
	       elsif Result.War = Bad then
		  Line := new String ' ("we have war" );
	       elsif Result.Love = Uncknow then
		  Line := new String ' ("we know unckno" );
	       elsif Result.Love = Nice then
		  Line := new String ' ("we know love" );
	       elsif Result.Love = Bad then
		  Line := new String ' ("we unknow love" );
	       else
		  Line := new String ' ("we haven't peace" );
	       end if;
	    else
	       Line := new String ' ("we haven't freedom" );
	    end if;
	    
	    return Line.all;
	 end To_String;
	 
	 
	 
	 procedure Verifiing (Preuve : in out Preuve_Record) is
	 begin
	    if ((Preuve.Have and (Preuve.Love = nice)) and (Preuve.Know and (Preuve.Peace = nice))) then
	       Preuve.Veritable := True;
	    end if;
	    if (Preuve.Power = nice) then
	       Preuve.Veracity := True;
	    end if;
	    if (Preuve.Will = nice) then
	       Preuve.verified := True;
	    end if;
	 end Verifiing;
	 
	 function To_String (Preuve : in Preuve_Record) return String is
	 begin
	    if Preuve.Veritable and Preuve.Veracity then
	       return To_String(Result_Record(Preuve)) & " with power.";
	    elsif Preuve.Verified then
	       return To_String(Result_Record(Preuve)) & " with will.";
	    elsif Preuve.Veritable then
	       return To_String(Result_Record(Preuve)) & " without will.";
	    elsif Preuve.Veracity then
	       return To_String(Result_Record(Preuve)) & ".";
	    elsif Preuve.Veracity and Preuve.Verified then
	       return To_String(Result_Record(Preuve)) & " with power and with will.";
	    else
	       return "know you love?";
	    end if;
	 end To_String;
	 function  From_line (Line : in String) return Preuve_Record is
	    Preuve : Preuve_Record;
	 begin
	    Result_Record(Preuve) := From_Line(Line);
	    return Preuve;
	 end From_Line;
	 
	 function To_State (Preuve : in Preuve_Record) return Boolean is
	    Verax : Boolean := False;
	 begin
	    if Preuve.Verified then
	       Verax := ((Preuve.Know and (Preuve.Love = nice)) and ((Preuve.Have and (Preuve.Peace = nice)) and (Preuve.Reason or Preuve.Freedom))) or (Preuve.War = bad);
	    elsif Preuve.Veracity then
	       return Preuve.War /= bad;
	    elsif ((Preuve.Know and (Preuve.Love = nice)) and ((Preuve.Have and (Preuve.Peace = nice)) and (Preuve.Reason or Preuve.Freedom))) or (Preuve.War = uncknow) then
	       Verax := True;
	    else
	       return False;
	    end if;
	    return Verax;
	 end To_State;

   end Main_Work;
   

end El.Axiome ; 
