package Adam is
   
   pragma Pure (Adam);
   type Command_Type is (Null_Item, 			 
			 AiManagment,
			 DataTechnologie,
			 AllManuals,
			 GnuLinuxInterface,
			 EnvironmentParameters,
			 SelfProgrammingProcess,
                         PlansAdministration,
			 Adamanborg_Call, Search,
                         Alarm,
                         -- Repeat,
			 Howto,
			 Other,
			 Chess,
			 GnuShell,
			 Print,
			 Shell_Print,
			 Completion_Print,
			 builtin,
			 Aimanagment_Print,
			 Plans_Print,
			 Computation,			 
                         Quit);        
   
   
   type Sub_Command_Type is (Null_Command, Setenv, Getenv, Chdir, mkdir);
   
   
   
   -------------------------------------
   -- Used by Timer, Dater and Alarm. --
   -------------------------------------
   subtype Years_Count is Natural range 0..385; -- Max Years of Ada implementation (2399) - Current Year (2015) + 1.
   subtype Months_Count is Natural range 0..11;
   subtype Days_Count is Natural range 0..365;   
   
   
   
   Project_Prefix : constant String := "Adam";
   Project_Name : constant String := Project_Prefix & "anborg";   
   
   Working_Directory : constant String := "$HOME";

   
   type Parameters_Flags_Enum_Type is
     
     (
      Nul_Parameter,
      Config_Filename,
      Help,
      Quiet,
      Graph_geometry,
      Version,
      Old_Geometry,
      Linux_Geometry,
      wide_Geometry,
      Train_Filename,
      L1_Network_Filename,
      L2_Network_Filename,
      Lexic_Filename,
      L1_Max_Epochs,
      L2_Max_Epochs,
      L1_Converged,
      L2_Converged,
      L1_Max_Iteration,
      L1_Reuse_Network,
      L2_Reuse_Network,
      Univers_Filename,
      L1_Max_Samples,
      L2_Max_Samples,
      Username,
      Hostname,
      Self_Programming,
      Load_Manpages,
      Delay_For_Response,
      Input_Text
	
     );
   
   type Parameter_Tagged_Record_Type (Requiered_Parameter : Boolean) is tagged
      record	 
	 Switch   : access Wide_String;	 	 
	 Num_Iter : Natural := 0;	 	 
	 Is_Setted : Boolean := False;	 
	 Parameter_Flag : Parameters_Flags_Enum_Type := Nul_Parameter;	 
	 Descr : access Wide_String;	 
	 case Requiered_Parameter is
	    when False =>
	       null;
	    when True =>
	       
	       param : access Wide_String;
	       Value : access Wide_String;
	 end case;
      end record;
      
   type Parameters_Kit_Array_Type is 
     array (Parameters_Flags_Enum_Type) of 
     access Parameter_Tagged_Record_Type;
               
   Line_Parameters : constant Parameters_Kit_Array_Type := 
     (
      
      Nul_parameter => null,
      Config_Filename => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Config_Filename, 
	 Descr => new Wide_String ' ("Configuration filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
	 
      Help => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => help, 
	 Descr => new Wide_String ' ("print this message")),
	 
      Quiet => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("q"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Quiet, 
	 Descr => new Wide_String ' ("quiet option")),
      
      Graph_geometry => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("x"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Graph_geometry, 
	 Descr => new Wide_String ' ("running under X window system")),
      
      Version => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version, 
	 Descr => new Wide_String ' ("print the version")),
      
      Old_Geometry => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("o"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Old_geometry, 
	 Descr => new Wide_String ' ("running under textual 80x25 mode")),
      
      Linux_Geometry => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("w"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Linux_geometry, 
	 Descr => new Wide_String ' ("running under textual 160x64 mode")),
      Wide_Geometry => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("W"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Wide_geometry, 
	 Descr => new Wide_String ' ("running under textual 211x78 mode")),
      
      Train_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("f"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Train_Filename, 
	 Descr => new Wide_String ' ("train filename for L1"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      L1_Network_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("r"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Network_Filename, 
	 Descr => new Wide_String ' ("network filename for L1"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      L2_Network_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("R"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L2_Network_Filename, 
	 Descr => new Wide_String ' ("network filename for L2"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      Lexic_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("l"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Network_Filename, 
	 Descr => new Wide_String ' ("lexic filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      L1_Max_Epochs => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("m"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Max_Epochs, 
	 Descr => new Wide_String ' ("max epochs for L1"),
	 Param => new Wide_String ' ("Positive"),
	 Value => null),
      
      L2_Max_Epochs => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("M"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L2_Max_Epochs, 
	 Descr => new Wide_String ' ("max epochs for L2"),
	 Param => new Wide_String ' ("Positive"),
	 Value => null),
      
      L1_Converged => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("c"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Converged, 
	 Descr => new Wide_String ' ("converged for L1"),
	 Param => new Wide_String ' ("Real"),
	 Value => null),
      
      L2_Converged => new Parameter_Tagged_Record_Type'
	(Requiered_Parameter => True, Switch => new Wide_String ' ("C"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L2_Converged, 
	 Descr => new Wide_String ' ("converged for L2"),
	 Param => new Wide_String ' ("Real"),
	 Value => null),
      
      L1_Max_Iteration => new Parameter_Tagged_Record_Type'
	(Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Max_Iteration, 
	 Descr => new Wide_String ' ("max iteration for L1"),
	 Param => new Wide_String ' ("Positive"),
	 Value => null),
      
      L1_Reuse_Network => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("n"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Reuse_Network, 
	 Descr => new Wide_String ' ("initialize network for L1")),
	
      L2_Reuse_Network => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("N"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Reuse_Network, 
	 Descr => new Wide_String ' ("initialize network for L2")),
      
      Univers_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("U"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Univers_Filename, 
	 Descr => new Wide_String ' ("univers filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      L1_Max_Samples => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Max_Samples, 
	 Descr => new Wide_String ' ("max samples for L1"),
	 Param => new Wide_String ' ("Positive"),
	 Value => null),
      
      L2_Max_Samples => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("S"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L2_Max_Samples, 
	 Descr => new Wide_String ' ("max samples for L2"),
	 Param => new Wide_String ' ("Positive"),
	 Value => null),
      
      Username => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("e"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Username, 
	 Descr => new Wide_String ' ("user name"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Hostname => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("H"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Hostname, 
	 Descr => new Wide_String ' ("hostname"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      Self_Programming => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => False, Switch => new Wide_String ' ("P"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Programming, 
	 Descr => new Wide_String ' ("Self programming process")),
      
      Load_Manpages => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("p"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Load_Manpages, 
	 Descr => new Wide_String ' ("load manpages")),
      
      Delay_For_Response => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("d"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Delay_For_Response,
	 Descr => new Wide_String ' ("delay for response"),
	 Param => new Wide_String ' ("Duration"),
	 Value => null),
		
      Input_Text => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("t"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Input_Text, 
	 Descr => new Wide_String ' ("input text"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null)
	
     );
   
   
   File_Parameters : constant Parameters_Kit_Array_Type := 
     (
      
      Nul_parameter => null,
      Config_Filename => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Config_Filename, 
	 Descr => new Wide_String ' ("Configuration filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
	 
      Help => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => help, 
	 Descr => new Wide_String ' ("print this message")),
	 
      Quiet => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("q"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Quiet, 
	 Descr => new Wide_String ' ("quiet option")),
      
      Graph_geometry => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("x"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Graph_geometry, 
	 Descr => new Wide_String ' ("running under X window system")),
      
      Version => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version, 
	 Descr => new Wide_String ' ("print the version")),
      
      Old_Geometry => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("o"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Old_geometry, 
	 Descr => new Wide_String ' ("running under textual 80x25 mode")),
      
      Linux_Geometry => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("w"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Linux_geometry, 
	 Descr => new Wide_String ' ("running under textual 160x64 mode")),
      Wide_Geometry => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("W"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Wide_geometry, 
	 Descr => new Wide_String ' ("running under textual 211x78 mode")),
      
      Train_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("f"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Train_Filename, 
	 Descr => new Wide_String ' ("train filename for L1"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      L1_Network_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("r"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Network_Filename, 
	 Descr => new Wide_String ' ("network filename for L1"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      L2_Network_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("R"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L2_Network_Filename, 
	 Descr => new Wide_String ' ("network filename for L2"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      Lexic_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("l"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Network_Filename, 
	 Descr => new Wide_String ' ("lexic filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      L1_Max_Epochs => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("m"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Max_Epochs, 
	 Descr => new Wide_String ' ("max epochs for L1"),
	 Param => new Wide_String ' ("Positive"),
	 Value => null),
      
      L2_Max_Epochs => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("M"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L2_Max_Epochs, 
	 Descr => new Wide_String ' ("max epochs for L2"),
	 Param => new Wide_String ' ("Positive"),
	 Value => null),
      
      L1_Converged => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("c"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Converged, 
	 Descr => new Wide_String ' ("converged for L1"),
	 Param => new Wide_String ' ("Real"),
	 Value => null),
      
      L2_Converged => new Parameter_Tagged_Record_Type'
	(Requiered_Parameter => True, Switch => new Wide_String ' ("C"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L2_Converged, 
	 Descr => new Wide_String ' ("converged for L2"),
	 Param => new Wide_String ' ("Real"),
	 Value => null),
      
      L1_Max_Iteration => new Parameter_Tagged_Record_Type'
	(Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Max_Iteration, 
	 Descr => new Wide_String ' ("max iteration for L1"),
	 Param => new Wide_String ' ("Positive"),
	 Value => null),
      
      L1_Reuse_Network => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("n"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Reuse_Network, 
	 Descr => new Wide_String ' ("initialize network for L1")),
	
      L2_Reuse_Network => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("N"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Reuse_Network, 
	 Descr => new Wide_String ' ("initialize network for L2")),
      
      Univers_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("U"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Univers_Filename, 
	 Descr => new Wide_String ' ("univers filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      L1_Max_Samples => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L1_Max_Samples, 
	 Descr => new Wide_String ' ("max samples for L1"),
	 Param => new Wide_String ' ("Positive"),
	 Value => null),
      
      L2_Max_Samples => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("S"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => L2_Max_Samples, 
	 Descr => new Wide_String ' ("max samples for L2"),
	 Param => new Wide_String ' ("Positive"),
	 Value => null),
      
      Username => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("e"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Username, 
	 Descr => new Wide_String ' ("user name"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Hostname => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("H"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Hostname, 
	 Descr => new Wide_String ' ("hostname"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      Self_Programming => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => False, Switch => new Wide_String ' ("P"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Programming, 
	 Descr => new Wide_String ' ("Self programming process")),
      
      Load_Manpages => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("p"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Load_Manpages, 
	 Descr => new Wide_String ' ("load manpages")),
      
      Delay_For_Response => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("d"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Delay_For_Response,
	 Descr => new Wide_String ' ("delay for response"),
	 Param => new Wide_String ' ("Duration"),
	 Value => null),
		
      Input_Text => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("t"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Input_Text, 
	 Descr => new Wide_String ' ("input text"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null)
	
     );
   

   
   type Parameters_Kit_Record_Type is tagged
      record
	 All_Parameters : Parameters_Kit_Array_Type;
      end record;
   
   type Adam_Interface_Type is abstract tagged limited
      record
	 Parameters_Kit : Parameters_Kit_Record_Type;
      end record;
      
   --  Spec_Error : exception;
   --  Impl_Limit : exception;
   
end Adam;
