with Gnat.Os_Lib;
with Adam.Operating_System;
with Ada.Text_Io;
use Ada;
with Ada.Directories;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Fixed;
use Ada.Strings;
with Gnat.Strings;
use Gnat.Strings;
package body Adam.Compiling_System is
   

   
   procedure Initialize is
   begin
      Specifications_Filenames_Search :=
	Operating_System.Spawn ("find " & Path & " -iname " & Project_Prefix & "*.ads");
      
      if Specifications_Filenames_Search.Args /= null then
	 for Arg in Specifications_Filenames_Search.Args'Range loop
	    Free(Specifications_Filenames_Search.Args(Arg));
	    end loop;
      end if;

      

      
      
      
      
      Implementations_Filenames_Search :=
	Operating_System.Spawn ("find " & Path & " -iname " & Project_Prefix & "*.adb");
      
      
      
      if Implementations_Filenames_Search.Args /= null then
	 for Arg in Implementations_Filenames_Search.Args'Range loop
	    Free(Implementations_Filenames_Search.Args(Arg));
	    end loop;
      end if;

      
      
   end Initialize;
   

   procedure Replace_Description (Var_Name : in String; Value : in String; Node : in String) is
      Filename : constant String := Project_Name & '/' & Project_Prefix & "-" & Node & "/src/lib/" & To_Lower(Project_Prefix) & '-' & To_Lower(Node) & ".ads";
      
      Source : Text_Io.File_Type;
      Target : Text_Io.File_Type;
      
      Tmp_Filename : constant String := Filename & ".tmp";
      Done : Boolean := False;
   begin      
      Text_Io.Put_Line("Change value of " & Var_Name & " to " & Value & " in " & Node & " ; ");
      Text_Io.Put_Line("with filename : " & Filename);
      if Os_Lib.Is_Regular_File(Filename) then
	 Text_Io.Create(Target, Text_Io.Out_File, Tmp_Filename);
	 Text_Io.Open(Source, Text_Io.In_File, Filename);
	 while not Text_Io.End_Of_File(Source) loop
	    declare
	       Line : constant String := Text_Io.Get_Line(Source);
	    begin
	       if not Done then
		  if Fixed.Index(Line, Var_Name) /= 0 then
		     
		     Text_Io.Put_Line(Target, Line(Line'First..Fixed.Index(Line, "=")+1) & Value & " ; ");	       
		     Done := True;
		  else
		     Text_Io.Put_Line(Target, Line);
		  end if;		  
	       else
		  Text_Io.Put_Line(Target, Line);
	       end if;
	    end;
	 end loop;
	 Text_Io.Close(Target);
	 Text_Io.delete(Source);      
	 directories.Rename(Tmp_Filename, Filename);
      end if;
   end Replace_Description;
   
   
   procedure Main_Description (Var_Name : in String; Value : in String; Node : in String) is
      Filename : constant String := Project_Name & '/' & Project_Prefix & Node & "/src/" & Project_Name & ".adb";
      Source : Text_Io.File_Type;
      Target : Text_Io.File_Type;
      
      Tmp_Filename : constant String := Filename & ".tmp";
      Done : Boolean := False;
   begin      
      Text_Io.Put_Line("Change value of " & Var_Name & " to " & Value & " in " & Node & " ; ");
      Text_Io.Put_Line("with filename : " & Filename);
      if Os_Lib.Is_Regular_File(Filename) then
	 Text_Io.Create(Target, Text_Io.Out_File, Tmp_Filename);
	 Text_Io.Open(Source, Text_Io.In_File, Filename);
	 while not Text_Io.End_Of_File(Source) loop
	    declare
	       Line : constant String := Text_Io.Get_Line(Source);
	    begin
	       if not Done then
		  if Fixed.Index(Line, Var_Name) /= 0 then
		     
		     Text_Io.Put_Line(Target, Line(Line'First..Fixed.Index(Line, "=")+1) & Value & " ; ");	       
		     Done := True;
		  else
		     Text_Io.Put_Line(Target, Line);
		  end if;		  
	       else
		  Text_Io.Put_Line(Target, Line);
	       end if;
	    end;
	 end loop;
	 Text_Io.Close(Target);
	 Text_Io.delete(Source);      
	 directories.Rename(Tmp_Filename, Filename);
      end if;
   end Main_Description;
   
end Adam.Compiling_System;
