-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2024-11-19 17:59:10 ; 
-- Version := 0.7.0r ; 
with Ada.Containers.Vectors;
use Ada.Containers;
with Sky.Ansi.Windows;
with Ada.Calendar;
use Ada.Calendar;
with Sky.Strings;
use Sky.Strings;
with Ada.Wide_Text_Io;
with Sky.Attributes;
use Sky.Attributes;
generic
   with package My_Windows is new Sky.Ansi.Windows (<>);
package Sky.Classes is
   use My_Windows;
   package W_Io renames Ada.Wide_Text_Io;
   
   type Abstract_Index is new Positive;
   
   type Abstract_Class(Tag : Class_Enum);
   
   type Abstract_Access is access all Abstract_Class'Class;
   
   procedure Obj_Free(O : in out Abstract_Access);
   
   
   function Same (Left, Right : in Abstract_Access) return Boolean;
   package Abstract_Vectors is new Vectors (Abstract_Index, Abstract_Access, Same);
   
   type Abstract_Info(Tag : Class_Enum) is
      record
	 Index   : Abstract_Index := 1;
	 Name    : Wide_String_Access;
	 Created : Time := Time_Of(1970, 1, 1, 0.0);
	 Childs_Num : Natural := 0;
      end record;
   
   type Abstract_Class(Tag : Class_Enum) is abstract tagged
      record
	 
	 Info : Abstract_Info(Tag);
	 
	 Childs  : Abstract_Vectors.Vector;
	 
	 Definition : Attributs(10);
	 case Tag is
	    when Event .. Rendezvous =>
	       Date          : Time := Time_Of(1970, 1, 1, 0.0);
	       Period        : Duration := 0.0;
	       Locality      : Wide_String_Access;
	       Define        : Wide_String_Access;
	    when Book..DVD =>
	       Author : Wide_String_Access;
	       Editor : Wide_String_Access;
	    when others =>
	       null;
	 end case;
      end record;
   
   
   
   procedure Print (Obj    : in abstract_Class;
		    Header : in Window_Type;
		    Main : in Window_Type) is abstract;
   
   procedure Write (O : in Abstract_Class;File : in W_Io.File_Type) is abstract;
   procedure Read (O : out Abstract_Class;File : in W_Io.File_Type) is abstract;

   
   type None_Class is new Abstract_Class(None) with null record;
   
   procedure Print (Attr : in Attributs; Win : in Window_type);
   
   procedure Print (Obj    : in none_Class;
		    Header : in Window_Type;
		    Main : in Window_Type);
   
   procedure Write (O : in none_Class;File : in W_Io.File_Type);
   procedure Read (O : out none_Class;File : in W_Io.File_Type);

   
   type Universe_Class is new Abstract_Class(Universe) with null record;
   --type Universe_Class is new Abstract_Class(Universe) with null record;
   function Create return Universe_Class;
   
   procedure Print (Obj    : in Universe_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type);
   
   procedure Write (O : in Universe_Class;File : in W_Io.File_Type);
   procedure Read (O : out Universe_Class;File : in W_Io.File_Type);
   
   
   type Content_Class is new Abstract_Class(Content) with
     record
	
	Description         : Wide_String_Access;
	Price               : Fixed_Unit_Ttc := 0.0;
     end record;
   
   --type Content_Class Is new Abstract_Class(Content) with null record;
   function Create return Content_Class;
   
   procedure Print (Obj    : in Content_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type);
   
   procedure Write (O : in Content_Class;File : in W_Io.File_Type);
   procedure Read (O : out Content_Class;File : in W_Io.File_Type);
   
   
   
   
   type Planning_Class is new Abstract_Class(Planning) with
      record
	 From                : Time := Time_Of(1970, 1, 1, 0.0);
	 To                  : Time := Time_Of(1970, 1, 1, 0.0);
      end record;
   
   --type Planning_Class is new Abstract_Class(Planning) with null record;
   function Create return Planning_Class;
   
   procedure Print (Obj    : in Planning_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type);
   
   procedure Write (O : in Planning_Class;File : in W_Io.File_Type);
   procedure Read (O : out Planning_Class;File : in W_Io.File_Type);
   
   type Event_Class is new Abstract_Class(Event) with
      record
	 null;
      end record;
   
   
   --type Event_Class is new Abstract_Class(Event) with null record;
   function Create return Event_Class;
   
   procedure Print (Obj    : in Event_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type);
   
   procedure Write (O : in Event_Class;File : in W_Io.File_Type);
   procedure Read (O : out Event_Class;File : in W_Io.File_Type);
   
   
   type Job_Class is new Abstract_Class(Job) with
      record
	 null;
      end record;
   
   --type Job_Class is new Abstract_Class(Job) with null record;
   function Create return Job_Class;
   
   procedure Print (Obj    : in Job_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type);
   
   procedure Write (O : in Job_Class;File : in W_Io.File_Type);
   procedure Read (O : out Job_Class;File : in W_Io.File_Type);
   
   
   type Meeting_Class is new Abstract_Class(Meeting) with
      record
	 null;
      end record;
   
   --type Meeting_Class is new Abstract_Class(Meeting) with null record;
   function Create return Meeting_Class;
   
   procedure Print (Obj    : in Meeting_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type);
   
   procedure Write (O : in Meeting_Class;File : in W_Io.File_Type);
   procedure Read (O : out Meeting_Class;File : in W_Io.File_Type);
   
   
   type Rendezvous_Class is new Abstract_Class(Rendezvous) with
      record
	 null;
      end record;
   
      --type Rendezvous_class is new Abstract_Class(Rendezvous) with null record;
   function Create return Rendezvous_Class;
   
   procedure Print (Obj    : in Rendezvous_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type);
   
   procedure Write (O : in Rendezvous_Class;File : in W_Io.File_Type);
   procedure Read (O : out Rendezvous_Class;File : in W_Io.File_Type);
   

   
   type Profile_Class is new Abstract_Class(Profile) with
      record
	 Full_Name           : Wide_String_Access;
	 Born                : Time := Time_Of(1970, 1, 1, 0.0);	      
	 Addr                : Wide_String_Access;
	 Phone               : Wide_String_Access;
	 Email               : Wide_String_Access;
      end record;
   
   --type Profile_Class Is new Abstract_Class(Profile) with null record;
   function Create return Profile_Class;
   
   procedure Print (Obj    : in Profile_Class;
		    Header    : in Window_Type;
		    Main : in Window_Type);
   
   procedure Write (O : in Profile_Class;File : in W_Io.File_Type);
   procedure Read (O : out Profile_Class;File : in W_Io.File_Type);
   
   
   type Book_Class is new Abstract_Class(Book) with null record;
   
   function Create return Book_Class;
   
   procedure Print (Obj    : in Book_Class;
  		    Header    : in Window_Type;
  		    Main : in Window_Type);
   
   procedure Write (O : in Book_Class;File : in W_Io.File_Type);
   procedure Read (O : out Book_Class;File : in W_Io.File_Type);
   
   
   type CDROM_Class is new Abstract_Class(CDROM) with null record;
   
   
   function Create return CDROM_Class;
   
   procedure Print (Obj    : in CDROM_Class;
  		    Header    : in Window_Type;
  		    Main : in Window_Type);
   
   procedure Write (O : in CDROM_Class;File : in W_Io.File_Type);
   procedure Read (O : out CDROM_Class;File : in W_Io.File_Type);
   
   
   type DVD_Class is new Abstract_Class(DVD) with null record;
   
   function Create return DVD_Class;
   
   procedure Print (Obj    : in DVD_Class;
  		    Header    : in Window_Type;
  		    Main : in Window_Type);
   
   procedure Write (O : in DVD_Class;File : in W_Io.File_Type);
   procedure Read (O : out DVD_Class;File : in W_Io.File_Type);
   
   
   type Car_Class is new Abstract_Class(Car) with
      record
  	 Mark : Wide_String_Access;
  	 Model : Wide_String_Access;
  	 Mat   : Wide_String_Access;
      end record;
   
   function Create return Car_Class;
   
   procedure Print (Obj    : in Car_Class;
  		    Header    : in Window_Type;
  		    Main : in Window_Type);
   
   procedure Write (O : in Car_Class;File : in W_Io.File_Type);
   procedure Read (O : out Car_Class;File : in W_Io.File_Type);
   
   type House_Class is new Abstract_Class(House) with
      record
  	 Addr : Wide_String_Access;
  	 Surf : Wide_String_Access;
      end record;
   
   function Create return House_Class;
   
   procedure Print (Obj    : in House_Class;
  		    Header    : in Window_Type;
  		    Main : in Window_Type);
   
   procedure Write (O : in House_Class;File : in W_Io.File_Type);
   procedure Read (O : out House_Class;File : in W_Io.File_Type);
   
     
     
   
   
   use My_Windows;
   
   --function Create return Abstract_Class'Class is abstract;
   
   
   
   
   
   
   
end Sky.Classes ; 
