with Ada.Wide_Text_Io;
use Ada.Wide_Text_Io;
with Gnat.CGI;
with Gnat.CGI.Cookie;
--use Gnat.CGI;
with Ada.Characters.Handling;
use Ada.Characters;
use Gnat.CGI.Cookie;
use Gnat;
with Gnat.Sha1;
use Gnat.Sha1;
with Ada.Streams.Stream_Io;
use Ada.Streams;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Gnat.Directory_operations;
use Gnat.Directory_operations;
with Gnat.Directory_Operations.Iteration;
use Gnat.Directory_Operations.Iteration;
with gnat.os_lib;
use gnat.os_lib;
with Text_Io;
procedure Webmain is
   
   type String_Access is access all String;
   
   package Users_Manager is
      
      
      
      function Add_User(Logname : in String;
			Passwd : in Sha1.Message_Digest) return Boolean;
      

      
      function Check_passwd(Logname : in String;
			    Passwd : in Sha1.Message_Digest) return Boolean;
      
      
   private
      
      
      -- User define --
      
      subtype Logname_Type is String (1..64);
      
      
      
      type User_Type is tagged
	 record
	    Logname : Logname_Type := (others => Character ' Val (32)) ;
	    Passwd : Sha1.Message_Digest;
	 end record;                  
      
      procedure Initialize(User : out User_Type;
			   Name : in String);
      -- Get player named "Name".
      
      
      
      procedure Set_Pass(User : in out User_Type;
			 Pass : in Sha1.Message_Digest);
      -- Set password for player.
      
      function Check_Pass(User : in User_Type;
			  Pass : in Sha1.Message_Digest) return Boolean;
      -- Return True is getted password is valid. False else.      
      
      
      
      
   end Users_Manager;
package body Users_Manager is
      
      -- User define --
      procedure Initialize(User : out User_Type;
			   Name : in String) is
	 
      begin
	 User.Logname(1..Name'Length) := Name;
      end Initialize;
      -- Get player named "Name".
      
      procedure Set_Pass(User : in out User_Type;
			 Pass : in Sha1.Message_Digest) is
      begin
	 User.Passwd := Pass;
      end Set_Pass;
      -- Set password for player.
      
      function Check_Pass(User : in User_Type;
			  Pass : in Sha1.Message_Digest) return Boolean is
      begin
	 return User.Passwd = Pass;
      end Check_Pass;
      -- Return True is getted password is valid. False else.      

      
      Users_Filename : constant String_Access := new String ' (".users");
      
      
      function Add_User(Logname : in String;
			Passwd : in Sha1.Message_Digest) return Boolean is

	 Users_File : Stream_Io.File_Type;
	 Users_Stream : Stream_Io.Stream_Access;

	 Old, Current : User_Type;

      begin

	 Initialize(Current, Logname);

	 Set_Pass(Current, Passwd);
	 
	 begin
	    Stream_IO.open(users_File, Stream_Io.In_File, Users_Filename.all);
	    
	    users_stream := Stream_IO.Stream(users_File);
	    while not Stream_Io.End_Of_File(Users_File) loop
	       User_Type'read(Users_Stream, old);
	       if Current.Logname = Old.Logname then
		  Stream_IO.Close(Users_File);
		  return False;
	       end if;
	    end loop;
	    Stream_IO.Close(Users_File);
	 exception
	    when Stream_Io.Name_Error =>
	       Stream_IO.create(users_File, Stream_Io.out_File, Users_Filename.all);
	       Stream_IO.Close(Users_File);
	 end;

	 Stream_IO.open(users_File, Stream_Io.append_File, Users_Filename.all);
	 users_stream := Stream_IO.Stream(users_File);
	 User_Type'write(Users_Stream, Current);
	 Stream_IO.Close(Users_File);
	 return True;
      end add_user;


      function Check_passwd(Logname : in String;
			    Passwd : in Sha1.Message_Digest) return Boolean is
	 Users_File : Stream_Io.File_Type;
	 Users_Stream : Stream_Io.Stream_Access;
	 

	 Old, Current : User_Type;

      begin
	 
	 
	 Initialize(Current, Logname);
	 Set_Pass(Current, Passwd);
	 
	 Stream_IO.open(users_File, Stream_Io.In_File, Users_Filename.all);
	 
	 users_stream := Stream_IO.Stream(users_File);
	 
	 while not Stream_Io.End_Of_File(Users_file) loop
	    User_Type'read(Users_Stream, old);
	    
	    if Current.Logname = Old.Logname then
	       
	       if Check_Pass(Old, passwd) then
		  

		  Stream_IO.Close(Users_File);

		  return True;

	       else

		  Stream_IO.Close(Users_File);
		  return False;
	       end if;
	    end if;
	 end loop;
	 
	 Stream_IO.Close(Users_File);
	 return False;
      exception
	 when others =>
	    return False;
      end Check_passwd;

      
   end Users_Manager;

   
   use Users_Manager;
   
   
   File : File_Type;
   
   Errno : Integer := 0;
   function System(Line : in String) return Integer;
   pragma Import (C, System, "system");
   procedure create_htaccess (path : in string; logname : in string) is
      file : Text_Io.file_type;
   begin
      Text_Io.Create(file, Text_Io.out_file, path & '/' & ".htaccess");
      Text_Io.put_line(file, "AuthType Basic");
      Text_Io.put_line(file, "AuthName ""Restricted Files""");
      Text_Io.put_line(file, "AuthBasicProvider file");
      Text_Io.put_line(file, "AuthUserFile " & path & "/.htpasswd");
      Text_Io.put_line(file, "Require user " & logname);
   end create_htaccess;
   package W_Io renames Ada.Wide_Text_Io;
   
begin   
   if Cgi.Argument_Count = 1  and then
     Cgi.Key(1) = "logout" then
      Cgi.Cookie.Set(Key     => "logname",
		     Value   => Value(""),
		     Domain  => "inconito.net");
      Gnat.Cgi.Cookie.Put_Header;
      Put_Line("<html>");
      Put_Line("  <head>");
      Put_Line("    <meta charset=""UTF-8"">");
      Put_Line("    <title>");
      Put_Line("");
      Put_Line("    </title>");
      Put_Line("  </head>");
      Put_Line("  <body>");
      Put_Line("    <h2></h2>");
      Put_Line("    <h3>Page d'accueil</h3>");
      Put_Line("    Site web dédié au développement cybernétique avec le langage de programmation Ada.");
      Put_Line("    <h4>Plan</h4>");
      Put_Line("     Ce <a href=""/cgi-bin/webmain"">plan du site</a> présente l'ensemble des éléments mis à votre disposition dans un espace personnel nécessitant une authentification.");
      Put_Line("  </body>");
      Put_Line("</html>");
      
   elsif Cgi.Argument_Count = 0 and then 
     Gnat.CGI.Cookie.Count = 1 and then
     Gnat.CGI.Cookie.Value("logname")'Length /= 0 then
      Cgi.Put_Header;
      Put_Line("<!DOCTYPE html>");
      Put_Line("<html>");
	 Put_Line("  <head>");
	 Put_Line("    <meta charset=""UTF-8"">");
	 Put_Line("    <title>");
	 Put_Line("      index");
	 Put_Line("    </title>");
	 Put_Line("  </head>");
	 Put_Line("  <body>");
	 Put_Line("    <table align=""center"" width=""66%"">");
	 Put_Line("      <tr>");
	 Put_Line("<td>");
	 Put_Line("  <h2>Déconnexion</h2>");
	 Put_Line("<form action=""/cgi-bin/webmain"" method=""post"">");
	 Put_Line("  <input type=""hidden"" name=""logout"" id=""logout"">");
	 Put_Line("  <input type=""submit"" value=""Quitter"">");
	 Put_Line("</form>");
	 Put_Line("</td>");
	 Put_Line("      </tr>");
	 Put_Line("      <tr>");
	 Put_Line("<td>");
	 Put_Line("  <table align=""center"">");
	 Put_Line("    <tr>");
	 Put_Line("      <td>");
	 Put_Line("  <table align=""Left"">");
	 Put_Line("    <tr>");
	 Put_Line("      <td>");
	 Put_Line("<h1>Offres</h1>");
	 Put_Line("<h2>Outils</h2>");
	 Put_Line("<h4>Ada Empty</h4>");
	 Put_Line("Make your files headers with <a href=""/Ada_Empty.html"">Ada Empty</a> 6.4.0");
	 Put_Line("<h4>Quickstart</h4>");
	 Put_Line("Create your Ada project online with <a href=""/cgi-bin/procgi"">Quickstart</a>");
	 Put_Line("<h2>Logiciels</h2>");	 
	 Put_Line("Programmes réalisés sur système GNU/Linux");
	 Put_Line("<h4>Business</h4>");
	 Put_Line("<a href=""/Documentations/business.html"">Gestion d'entreprise</a>");
	 Put_Line("<h4>Entreprise</h4>");
	 Put_Line("<a href=""/Documentations/entreprise.html"">Usine logicielle</a>");
	 Put_Line("<h4>Server</h4>");
	 Put_Line("<a href=""/Documentations/server.html"">Web server of Entreprise</a>");
	 Put_Line("<h4>Ultrason</h4>");
	 Put_Line("<a href=""/Documentations/ultrason.html"">Compositeur virtuel</a>");
	 Put_Line("<h2>Jeux</h2>");
	 Put_Line("<h4>Chess</h4>");
	 Put_Line("<a href=""/Documentations/chess_finder.html"">Chess game</a>");
	 Put_Line("<h4>Space Fighter</h4>");
	 Put_Line("<a href=""/Documentations/space_fighter.html"">Fighter combat</a>");
	 Put_Line("<h2>Audits</h2>");
	 Put_Line("<h3>Enquêtes</h3>");
	 Put_Line("<h4>Etude de marcher</h4>");
	 Put_Line("<h4>Sondages</h4>");
	 Put_Line("<h2>Traveaux à façon</h2>");
	 Put_Line("<h3>Ingéniérie du logiciel avec Ada</h3>");

	 Put_Line("<h1>Home directory</h1>");
	 Put_Line("<a href=""/" & To_Wide_String(CGI.Cookie.Value("logname")) & "/gate.html"">Accueil</a>");
	 Put_Line("      </td>");
	 Put_Line("    </tr>");
	 Put_Line("  </table>");
	 Put_Line("  </td>");
	 
	 Put_Line("      <td>");

	 Put_Line("  <table align=""Left"">");
	 Put_Line("    <tr>");
	 Put_Line("      <td>");

	 
	 Put_Line("<h1>Suivi de commande</h1>");
	 Put_Line("<h4>Service technique</h4>");
	 Put_Line("<h4>Service après vente</h4>");
	 Put_Line("<h4>Prestations annexes</h4>");
	 Put_Line("<h1>Annonces</h1>");
	 Put_Line("<h4>Consulter</h4>");
	 Put_Line("<h4>Faire une offre</h4>");
	 Put_Line("<h1>Formations</h1>");
	 Put_Line("<h3>Initiation</h3>");
	 Put_Line("<h3>Généralités</h3>");
	 Put_Line("<h3>Structures de données et algorithmes</h3>");
	 Put_Line("<h3>Système d'entreprise</h3>");
	 Put_Line("<h4>Etude de l'existant</h4>");
	 Put_Line("<h4>Rassemblement des données</h4>");
	 Put_Line("<h4>Système de gestion de base de donnée relationnelle</h4>");
	 Put_Line("<h4>Ingéniérie système</h4>");
	 Put_Line("<h1>Programmer avec le langage Ada</h1>");
	 Put_Line("<h3>Le langage de programmation Ada</h3>");
	 Put_Line("<a href=""/Ada_Tutoriel.html"">Tutoriel Ada</a> inspiré du cours du Conservatoire National des Arts et Métiers<br>");
	 Put_Line("<h3>Le système d'exploitation Gnu/Linux</h3>");
	 Put_Line("<a href=""/gnu.html"">Premiers pas avec Gnu/Linux</a>");
	 Put_Line("<h3>Cybernétique</h3>");
	 Put_Line("<a href=""/systemical.html"">Approche systémique</a>");
	 Put_Line("<h4>Bibliographie</h4>");
	 Put_Line("L'architecture de l'ordinateur<br>");
	 Put_Line("Linux in a Nutshell<br>");
	 Put_Line("Administration des systèmes Linux<br>");
	 Put_Line("Le noyau Linux 2.0.0<br>");
	 Put_Line("Transmission et reseaux<br>");
	 Put_Line("Programmer en Ada 95<br>");
	 Put_Line("Ingéniérie du logiciel avec Ada<br>");
	 Put_Line("Structures de données et algorithmes<br>");
	 Put_Line("Mérise");
	 Put_Line("  </td>");
	 Put_Line("  </tr>");
	 
	 Put_Line("  </table>");
Put_Line("  </td>");
	 Put_Line("  </tr>");
	 Put_Line("  </table>");
	 Put_Line("  </td>");
	 Put_Line("  </tr>");
	 Put_Line("  </body>");
	 Put_Line("</html>");
	 
   elsif Cgi.Argument_Count >= 2 and then
     CGI.Value("logname")'Length /= 0 and then
     CGI.Value("password")'Length /= 0 then
      if Add_User(CGI.Value("logname"),
		  Digest(CGI.Value("password"))) or
	Check_Passwd(CGI.Value("logname"),
		     Digest(CGI.Value("password"))) then
	 begin
	    
	    Change_Dir("/var/www/html/" & CGI.Value("logname"));
	    
	    
	 exception
	    when Directory_Error =>
	       Make_Dir("/var/www/html/" & CGI.Value("logname"));
	       Errno := System("chmod a+w " & "/var/www/html/" & CGI.Value("logname") & Character'Val(0));
	       Change_Dir("/var/www/html/" & CGI.Value("logname"));
	       -- create html dir

	       create_htaccess("/var/www/html/" & CGI.Value("logname"), CGI.Value("logname"));
	       -- add dir/htaccess
	       
	       errno := system("sh -c ""echo " & CGI.Value("password") & " | " & "/usr/bin/htpasswd -c -i " & ".htpasswd" & " " & CGI.Value("logname") & """" & character'val(0));
	       if Errno /= 0 then
		  Gnat.Cgi.Cookie.Put_Header;
		  W_Io.Put_Line("<!DOCTYPE html>");
		  W_Io.Put_Line("<html>");
		  W_Io.Put_Line("<head>");
		  W_Io.Put_Line("<meta charset=""utf-8"">");
		  W_Io.Put_Line("<title>Program_Error</title>");
		  W_Io.Put_Line("</head>");
		  W_Io.Put_Line("<body>");
		  
		  Text_Io.Put_Line("htpasswd : errno : " & Integer'Image(Errno));
		  W_Io.Put_Line("</body>");
		  W_Io.Put_Line("</html>");
		  raise Program_Error;
	       end if;
	       -- create .htpasswd
	 end;
	 errno := system("sh -c ""cp /etc/skel/gate.html" & "/var/www/html/" & Value("logname") & """" & character'val(0));
	 Gnat.Cgi.Cookie.Set(Key     => "logname",
			     Value   => CGI.Value("logname"),
			     Domain  => "inconito.net");
	 
	 Gnat.Cgi.Cookie.Put_Header;
	 
	 Put_Line("<html>");
	 Put_Line("  <head>");
	 Put_Line("    <meta charset=""UTF-8"">");
	 Put_Line("    <title>");
	 Put_Line("      index");
	 Put_Line("    </title>");
	 Put_Line("  </head>");
	 Put_Line("  <body>");
	 Put_Line("    <table align=""center"" width=""66%"">");
	 Put_Line("      <tr>");
	 Put_Line("<td>");
	 Put_Line("  <h2>Déconnexion</h2>");
	 Put_Line("<form action=""/cgi-bin/webmain"" method=""post"">");
	 Put_Line("  <input type=""hidden"" name=""logout"" id=""logout"">");
	 Put_Line("  <input type=""submit"" value=""Quitter"">");
	 Put_Line("</form>");
	 Put_Line("</td>");
	 Put_Line("      </tr>");
	 Put_Line("      <tr>");
	 Put_Line("<td>");
	 Put_Line("  <table align=""Center"">");
	 Put_Line("    <tr>");
	 Put_Line("      <td>");
	 Put_Line("  <table align=""Left"">");
	 Put_Line("    <tr>");
	 Put_Line("      <td>");
	 
	 Put_Line("<h1>Offres</h1>");
	 Put_Line("<h2>Outils</h2>");
	 Put_Line("<h4>Ada Empty</h4>");
	 Put_Line("Make your files headers with <a href=""/Ada_Empty.html"">Ada Empty</a> 6.4.0");
	 Put_Line("<h4>Quickstart</h4>");
	 Put_Line("Create your Ada project online with <a href=""/cgi-bin/procgi"">Quickstart</a>");
	 Put_Line("<h2>Logiciels</h2>");
	 Put_Line("Programmes réalisés sur système GNU/Linux");
	 Put_Line("<h4>Business</h4>");
	 Put_Line("<a href=""/Documentations/business.html"">Gestion d'entreprise</a>");
	 Put_Line("<h4>Entreprise</h4>");
	 Put_Line("<a href=""/Documentations/entreprise.html"">Usine logicielle</a>");
	 Put_Line("<h4>Server</h4>");
	 Put_Line("<a href=""/Documentations/server.html"">Web server of Entreprise</a>");
	 Put_Line("<h4>Ultrason</h4>");
	 Put_Line("<a href=""/Documentations/ultrason.html"">Compositeur virtuel</a>");
	 Put_Line("<h2>Jeux</h2>");
	 Put_Line("<h4>Chess</h4>");
	 Put_Line("<a href=""/Documentations/chess_finder.html"">Chess game</a>");
	 Put_Line("<h4>Space Fighter</h4>");
	 Put_Line("<a href=""/Documentations/space_fighter.html"">Fighter combat</a>");
	 Put_Line("<h2>Audits</h2>");
	 Put_Line("<h3>Enquêtes</h3>");
	 Put_Line("<h4>Etude de marcher</h4>");
	 Put_Line("<h4>Sondages</h4>");
	 Put_Line("<h2>Traveaux à façon</h2>");
	 Put_Line("<h3>Ingéniérie du logiciel avec Ada</h3>");

	 Put_Line("<h1>Home directory</h1>");
	 Put_Line("<a href=""/" & To_Wide_String(CGI.Value("logname")) & "/gate.html"">Accueil</a>");
	 W_Io.Put_Line("  <table align=""left"" width=""22%"">");
	 W_Io.Put_Line(""); 
	 W_Io.Put_Line("    <tr><td>");
	 W_Io.Put_Line("<form action=""/cgi-bin/procgi"" method=""post"">");
	 W_Io.Put_Line("   <table border=""1"">");
	 W_Io.Put_Line("   <tr><td>Name</td><td>Path</td><td>Delete</td></tr>");
	 

	 declare
	    
	    procedure Table_Action
	      (Item  :        String;
	       Index :        Positive;
	       Quit  : in out Boolean) is
	    begin
	       if Base_Name(Item) /= CGI.Value("logname") then
		  if Is_Directory(Item) then
		     W_Io.Put_Line("   <tr><td>" & Handling.To_Wide_String(Base_Name(Item)) & "</td><td><a href=""/" & Handling.To_Wide_String(CGI.Value("logname")) & '/' & Handling.To_Wide_String(Base_Name(Item)) & '/' & Handling.To_Wide_String(Base_Name(Item)) & ".tgz"">" & 
				     Handling.To_Wide_String(Base_Name(Item)) & ".tgz</a></td><td><input type=""checkbox"" value=""" & Handling.To_Wide_String(Base_Name(Item)) & """ id=""" & 
				     Handling.To_Wide_String(Base_Name(Item)) & """ name=""" & Handling.To_Wide_String(Base_Name(Item)) & """></td></tr>   ");
		  end if;
	       end if;
	    end Table_Action;
	    
	    procedure Iterator is new Wildcard_Iterator (Table_Action);
	 begin
	    Iterator("/var/www/html/" & CGI.Value("logname") & "/*");
	 end;

	 
	 

	 W_Io.Put_Line("   <input type=""reset"" value=""Reset""><input type=""submit"" value=""Submit"">");
	 W_Io.Put_Line("   </form>");
	 W_Io.Put_Line("   </table>");
	 	 W_Io.Put_Line("   </table>");
	 W_Io.Put_Line("");   
	 W_Io.Put_Line("    </td></tr>");
	 Put_Line("  </table>");
	 Put_Line("      </td>");
	 Put_Line("    </tr>");
	 Put_Line("  </table>");
	 Put_Line("  </td>");
	 Put_Line("      <td>");

	 Put_Line("  <table align=""Left"">");
	 Put_Line("    <tr>");
	 Put_Line("      <td>");

	 
	 Put_Line("<h1>Suivi de commande</h1>");
	 Put_Line("<h4>Service technique</h4>");
	 Put_Line("<h4>Service après vente</h4>");
	 Put_Line("<h4>Prestations annexes</h4>");
	 Put_Line("<h1>Annonces</h1>");
	 Put_Line("<h4>Consulter</h4>");
	 Put_Line("<h4>Faire une offre</h4>");
	 Put_Line("<h1>Formations</h1>");
	 Put_Line("<h3>Initiation</h3>");
	 Put_Line("<h3>Généralités</h3>");
	 Put_Line("<h3>Structures de données et algorithmes</h3>");
	 Put_Line("<h3>Système d'entreprise</h3>");
	 Put_Line("<h4>Etude de l'existant</h4>");
	 Put_Line("<h4>Rassemblement des données</h4>");
	 Put_Line("<h4>Système de gestion de base de donnée relationnelle</h4>");
	 Put_Line("<h4>Ingéniérie système</h4>");
	 Put_Line("<h1>Programmer avec le langage Ada</h1>");
	 Put_Line("<h3>Le langage de programmation Ada</h3>");
	 Put_Line("<a href=""/Ada_Tutoriel.html"">Tutoriel Ada</a> (inspiré du cours du Conservatoire National des Arts et Métiers)<br>");
	 Put_Line("<h3>Le système d'exploitation Gnu/Linux</h3>");
	 Put_Line("<a href=""/gnu.html"">Premiers pas avec Gnu/Linux</a>");
	 Put_Line("<h3>Cybernétique</h3>");
	 Put_Line("<a href=""/systemical.html"">Approche systémique</a>");
	 Put_Line("<h4>Bibliographie</h4>");
	 Put_Line("L'architecture de l'ordinateur<br>");
	 Put_Line("Linux in a Nutshell<br>");
	 Put_Line("Administration des systèmes Linux<br>");
	 Put_Line("Le noyau Linux 2.0.0<br>");
	 Put_Line("Transmission et reseaux<br>");
	 Put_Line("Programmer en Ada 95<br>");
	 Put_Line("Ingéniérie du logiciel avec Ada<br>");
	 Put_Line("Structures de données et algorithmes<br>");
	 Put_Line("Mérise");
	 Put_Line("  </td>");
	 Put_Line("  </tr>");

	 Put_Line("  </table>");
	 Put_Line("  </td>");
	 Put_Line("  </tr>");
	 Put_Line("  </table>");
	 Put_Line("  </td>");
	 Put_Line("  </tr>");
	 Put_Line("  </body>");
	 Put_Line("</html>");
      else
	 Cgi.Put_Header;
	 Put_Line("<html>");
	 Put_Line("  <head>");
	 Put_Line("    <meta charset=""UTF-8"">");
	 Put_Line("    <title>");
	 Put_Line("      index");
	 Put_Line("    </title>");
	 Put_Line("  </head>");
	 Put_Line("  <body>");
	 Put_Line("Access denied.");
	 Put_Line("  </body>");
	 Put_Line("</html>");
      end if;
   else
      Cgi.Put_Header;
      
      Put_Line("<html>");
      Put_Line("  <head>");
      Put_Line("    <meta charset=""UTF-8"">");
      Put_Line("    <title>");
      Put_Line("      index");
      Put_Line("    </title>");
      Put_Line("  </head>");
      Put_Line("  <body>");
      Put_Line("    <table align=""center"" width=""66%"">");
      Put_Line("      <tr>");
      Put_Line("<td>");
      Put_Line("  <h2>Plan</h2>");
      Put_Line("  Nous sommes impliqués dans l&#39évolution et le progrès de chacun au sein de notre environnement social et culturel.<br>");
      Put_Line("  Avec vous, nous espérons répondre à votre attente ; Alors ce jour, chacun mient en contact afin d&#39exposer nos intérêts communs.<br>");
      Put_Line("  Nous sommes une équipe de programmeur ayant pour objectif de mener ou d&#39aider chacun à atteindre leurs propres objectifs.");
      Put_Line("</td>");
      Put_Line("      </tr>");
      Put_Line("      <tr>");
      Put_Line("<td>");
      Put_Line("  <table align=""Center"">");
      Put_Line("    <tr>");
      Put_Line("      <td>");
      
      Put_Line("  <table align=""Left"">");
      Put_Line("    <tr>");
      Put_Line("      <td>");
      Put_Line("<h1>Offres</h1>");
      Put_Line("<h2>Outils</h2>");
      Put_Line("<h4>Ada Empty</h4>");
      Put_Line("Make your files headers with <a href=""/Ada_Empty.html"">Ada Empty</a> 6.4.0");
      Put_Line("<h4>Quickstart</h4>");
      Put_Line("Create your Ada project online with <a href=""/cgi-bin/procgi"">Quickstart</a>");
      Put_Line("<h2>Logiciels</h2>");
      Put_Line("Programmes réalisés sur système GNU/Linux");
      Put_Line("<h4>Business</h4>");
      Put_Line("<a href=""/Documentations/business.html"">Gestion d'entreprise</a>");
      Put_Line("<h4>Entreprise</h4>");
      Put_Line("<a href=""/Documentations/entreprise.html"">Usine logicielle</a>");
      Put_Line("<h4>Server</h4>");
      Put_Line("<a href=""/Documentations/server.html"">Web server of Entreprise</a>");
      Put_Line("<h4>Ultrason</h4>");
      Put_Line("<a href=""/Documentations/ultrason.html"">Compositeur virtuel</a>");
      Put_Line("<h2>Jeux</h2>");
      Put_Line("<h4>Chess</h4>");
      Put_Line("<a href=""/Documentations/chess_finder.html"">Chess game</a>");
      Put_Line("<h4>Space Fighter</h4>");
      Put_Line("<a href=""/Documentations/space_fighter.html"">Fighter combat</a>");
      Put_Line("<h2>Audits</h2>");
      Put_Line("<h3>Enquêtes</h3>");
      Put_Line("<h4>Etude de marcher</h4>");
      Put_Line("<h4>Sondages</h4>");
      Put_Line("<h2>Traveaux à façon</h2>");
      Put_Line("<h3>Ingéniérie du logiciel avec Ada</h3>");
      Put_Line("  Ce formulaire installe des cookies dans votre navigateur.<br>");
      Put_Line("  Ils serons effacés lors de votre deconnexion.<br><br>");
      
      
      Put_Line("  <form action=""/cgi-bin/webmain"" method=""post"">");
      Put_Line("");
      Put_Line("  <h4>Authentification</h4>");
      Put_Line("  Site en cours de construction<br>");
      Put_Line("  Ne pas utiliser le formulaire.<br><br>");
      
      Put_Line("");
      Put_Line("<table>");
      Put_Line("<tr><td>Username :</td><td><input type=""text"" id=""logname"" name=""logname""></td><tr>");
      Put_Line("<tr><td>password :</td><td><input type=""password"" id=""password"" name=""password""></td></tr>");
      Put_Line("<tr><td></td><td><input type=""reset"" value=""Reset""><input type=""submit"" value=""Send""></td></tr>");
      Put_Line("</table>");
      Put_Line("  </form>");

      
      Put_Line("      </td>");
      Put_Line("    </tr>");
      Put_Line("  </table>");
      Put_Line("      </td>");
      
      Put_Line("      <td>");
      Put_Line("  <table align=""Left"">");
      Put_Line("    <tr>");
      Put_Line("      <td>");

      
      Put_Line("<h1>Suivi de commande</h1>");
      Put_Line("<h4>Service technique</h4>");
      Put_Line("<h4>Service après vente</h4>");
      Put_Line("<h4>Prestations annexes</h4>");
      Put_Line("<h1>Annonces</h1>");
      Put_Line("<h4>Consulter</h4>");
      Put_Line("<h4>Faire une offre</h4>");
      Put_Line("<h1>Formations</h1>");
      Put_Line("<h3>Initiation</h3>");
      Put_Line("<h3>Généralités</h3>");
      Put_Line("<h3>Structures de données et algorithmes</h3>");
      Put_Line("<h3>Système d'entreprise</h3>");
      Put_Line("<h4>Etude de l'existant</h4>");
      Put_Line("<h4>Rassemblement des données</h4>");
      Put_Line("<h4>Système de gestion de base de donnée relationnelle</h4>");
      Put_Line("<h4>Ingéniérie système</h4>");
      Put_Line("<h1>Programmer avec le langage Ada</h1>");
      Put_Line("<h3>Le langage de programmation Ada</h3>");
      Put_Line("<a href=""/Ada_Tutoriel.html"">Tutoriel Ada</a> (inspiré du cours du Conservatoire National des Arts et Métiers)<br>");
      Put_Line("<h3>Le système d'exploitation Gnu/Linux</h3>");
      Put_Line("<a href=""/gnu.html"">Premiers pas avec Gnu/Linux</a>");
      Put_Line("<h3>Cybernétique</h3>");
      Put_Line("<a href=""/systemical.html"">Approche systémique</a>");
      Put_Line("<h4>Bibliographie</h4>");
      Put_Line("L'architecture de l'ordinateur<br>");
      Put_Line("Linux in a Nutshell<br>");
      Put_Line("Administration des systèmes Linux<br>");
      Put_Line("Le noyau Linux 2.0.0<br>");
      Put_Line("Transmission et reseaux<br>");
      Put_Line("Programmer en Ada 95<br>");
      Put_Line("Ingéniérie du logiciel avec Ada<br>");
      Put_Line("Structures de données et algorithmes<br>");
      Put_Line("Mérise");
      Put_Line("  </td>");
      Put_Line("  </tr>");
      
      Put_Line("  </table>");

      Put_Line("  </td>");
      Put_Line("  </tr>");
      Put_Line("  </table>");
      Put_Line("  </td>");
      Put_Line("  </tr>");
      Put_Line("  </body>");
      Put_Line("</html>");

   end if;
end Webmain;
