-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-09-25 14:50:54 ; 
-- Version := 0.15.0a ; 
package M is
   
   pragma Pure (M);
   
   Name_Length_Max : constant Positive := 1024;
   
   subtype Name_Index_Type is Positive range 1..Name_Length_Max;
   
   Units_Max : constant Positive := 65536;
   
   subtype Unit_Index_Type is Positive range 1..Units_Max;   
   
   Ada_Line_Length_Max : constant Positive := 256;
   
   subtype Char_Index_Type is Positive range 1..Ada_Line_Length_Max;
   
   
   Ada_Version_Max : constant Positive := 2399;
   
   subtype Version_Index_Type is Positive range 1983..Ada_Version_Max;
   
   Objects_Max : constant Positive := 65536;
   
   subtype Object_Index_Type is Positive range 1..Objects_Max;
      
   type Human_Lang_Enum is (En, Fr);
   
   type Machine_Lang_Enum is (Project_Define, Ada_2012, Gtk_Ada, Ada_Web_Server);
   
   type Total_Type is delta 0.01 Digits 9 range -999_999.99 .. 999_999.99;
   
   
   type Style_Enum is (Black_And_White, Black_And_Color, Color_And_White,
		       White_And_Color, Color_And_Color, White_And_White);
   
   type Int_Cmd_Enum is (None, Alias, Unalias, Cd, Set, Unset, Put, Put_Line);
   
   type Class_Enum is (
		       
		       None,
		       
		       Universe,			 
		       Profile,
		       Content,
		       Event,
		       Job,
		       Meeting,
		       Rendezvous,
		       Planning,
		       
		       Book,
		       CDROM,
		       DVD,
		       Car,
		       House
			 
			 
		      );
   
   Organizer_Filename : constant String := "m-organizer.txt";
   Person_Filename : constant String := "m-person.txt";
   Project_Filename : constant String := "m-project.txt";
   Bank_Filename : constant String := "m-bank.txt";
   
   type Element_Enum is (None, Program, Description, License, 
			 Main, Library, Axiomatic, Precondition,
			 Axiom, Predicate, Condition, Component, 
			 Action, Class, Machine, System);
   
   
   
   
   type Term_Enum is (Linux, fvwm);
   subtype Line_Range is Positive range 1 .. 82;
   subtype Column_Range is Positive range 1..320;
   type Mode_Enum is (None, 
		      Organizer, Dialog, Planning, Manager, 
		      Moneybox,  Activity,  Stocks, Bank, 
		      Log, Menu, Contacts, Library, 
		      Navigation, Engineer, Agent, Admin, 
		      Terminator, Joshua, Entreprise, Process, 
		      Auth, Quit);
   
   type Flag_Enum is
     (None,
      Config_Filename,
      Help,      
      Quiet,
      Version,
      Geometry,
      Username,     
      Address,                  
      Input_Text,
      Term_Name,
      Samples_Filename,
      Max_Epochs,
      Converged,
      Reuse,
      Train,
      Num_Samples,      
      Human_Lang,
      Line_Width,
      Words_Max,
      Num_Hidden,
      Update,
      As_Server,
      Style,
      Initialize,
      Total,
      Name_Length,
      Unit_Max,
      Char_Max,
      Object_Max,
      Self_Programming,
      Self_Executed,
      Self_Wait,
      User_Wait,
      With_Gtk,
      With_Ada,
      With_Aws
     );
   
   

   
end M ; 
