-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-04 18:32:28"
-- Version := "0.0.0r"
with M.Project;
use M.Project;
with Ada.Containers.Doubly_Linked_Lists;
use Ada.Containers;

package M.Projects_manager is
   
   package Projects_DLL is new Ada.Containers.Doubly_Linked_Lists(Project_Access);
   use Projects_Dll;
   
   type Project_Array is array (Project_Num_Range range <>) of Project_Access;
   
   type Projects_Record(Projects_Max : Project_Num_Range) is
      record
	 Projects_Num : Project_Num_Range := 0; -- used as unic
	 List     : Projects_Dll.List;
      end record;
   
   
   
   procedure Manager_Save (Projects : in Projects_Record; Filename : in String);
   procedure Manager_Load (Projects : out Projects_Record; Filename : in String);
   procedure Archives_Save (Projects : in Projects_Record; Filename : in String);
   procedure Archives_Load (Projects : out Projects_Record; Filename : in String);

   
end M.Projects_manager ; 
