-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-04 18:32:28"
-- Version := "0.0.0r"
with M.Versions;
use M.Versions;
with Sky.Strings;
use Sky.Strings;
with Ada.Calendar;
use Ada.Calendar;
with Ada.Text_Io;
use Ada.Text_Io;
with Gnat.Os_Lib;
use Gnat.Os_Lib;
with Ada.Unchecked_Deallocation;
use Ada;

package M.Project is
   type Project_Info_Record is tagged
      record
	 Source_Path : String_Access := new String ' ("");
	 Absolute_Path : String_Access := new String ' ("");
	 Project_Name  : String_access := new String ' ("");
	 Version       : Version_Type;
	 Old_Version   : Version_Type;
	 Elapsed    : Duration := 0.0;	 
	 Days       : Natural := 0;
      end record;
   
   type Project_Record;
   
   type Project_Access is access all Project_Record;
   
   subtype Project_Num_Range is Natural range Natural'First..4096;
   
   subtype Component_Num_Range is Natural range Natural'First..8192;
   
   type Component_Record is tagged
      record
	 Unit_Name : String_Access;
	 Unit_Path : String_Access;
	 Unit_Num  : Component_Num_Range := 0;
	 Buffer    : Wide_String_Set(65536) := (65536, (others => null), 0);
      end record;
   
   Null_Component : constant Component_Record :=
     (null,
      null,
      0,
      (65536, (others => null), Line_Last => 0));
      
   type Unit_Array is array (Component_Num_Range range <>) of Component_Record;
   
   type Project_Record(Units_Max : Component_Num_Range) is new Project_Info_Record with
      record
	 Start_Date : Time := Time_Of(1970, 1, 1, 0.0);
	 end_Date   : Time := Time_Of(1970, 1, 1, 0.0);
	 
	 
	 Old_Project : Project_Access;
	 Project_Num : Project_Num_Range := 0;	 
	 libs : Unit_Array(1..Units_Max);
	 lib_Last : Component_Num_Range := 0;
	 Copyright  : String_Access;
	 Creation_Date : Time := Time_Of(1970, 1, 1, 0.0);
	 Last_Update   : Time := Time_Of(1970, 1, 1, 0.0);
      end record;
   
   procedure Lib_Add(Project : in out Project_Record; Lib : in String);
   procedure Open(Project : in out Project_Record; Date : Time := Clock);
   procedure Close(Project : in out Project_Record; Date : Time := Clock);
   procedure Save (Project : in Project_Record; File : in File_Type);
   procedure Read (Project : out Project_Access; Project_Name : in String);
   
   procedure Project_Free is new Ada.Unchecked_Deallocation(Project_Record, Project_Access); 
   
   
   
   type Abstract_Project is abstract new Project_Record with
      record
	 null;
      end record;
	 
   
   
   Null_Project : constant Project_Record := 
     (0,
      new String ' (""),
      new String ' (""),
      new String ' (""),
      Null_Version,
      Null_Version,      
      0.0,
      0,
      Time_Of(1970, 1, 1, 0.0),
      Time_Of(1970, 1, 1, 0.0),
      null,
      0,
      (others => Null_component),
      0,
      null,
      Time_Of(1970, 1, 1, 0.0),
      Time_Of(1970, 1, 1, 0.0)
     );

end M.Project ; 
