-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2025-06-04 18:32:28"
-- Version := "0.0.0r"
with Ada.Calendar;
use Ada.Calendar;

package M.Logs is
   type Log_Enum is (None, Organizer, Computer, Planning,
		     Makefile, Manpage, Project, HOWTO, HISTORY, Test,
		     Moneybox, Activity, Stocks, Bank);
   
   type Session_Record is
      record
	 Top : Time := Time_Of(2399, 12, 31, 86399.99);
	 Bot : Time := Clock;
      end record;
   
   procedure Open (Session : in out Session_Record);
   procedure Close (Session : in out Session_Record);
   
   type Session_Array is array (Log_Enum) of Session_Record;
   
   type Rate_Type is delta 0.01 digits 5 range 0.0..100.0;
   
   type Log_Record is
      record
	 Total : Long_Long_Float := 0.0;
	 Rate  : Rate_Type := 0.0;
      end record;
   
   type Log_Array is array (Log_Enum) of Log_Record;
   
   procedure Statistic (Sessions : in out Session_Array; Logs : in out Log_Array);
   
   procedure Save (Logs : in Log_Array; Filename : in String);
   procedure Restore (Logs : out Log_Array; Filename : in String);
   
   
   Log_Filename : constant String := "sky-logs.txt";


end M.Logs ; 
