-- main is main file of main project written with Ada.
-- Main is Copyright (C) 2025 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2025-07-25 08:23:50 ; 
-- Version := 0.5.0r ; 
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with M.Ansi.Console;
use M.Ansi.Console;
with Text_Io;
use Text_Io;
with Gnat.Os_Lib;
use Gnat.Os_Lib;
with Ada.Unchecked_Deallocation;

package body M.Engine is
   
   use Ada.Wide_Text_Io;
   use Element_Vectors;
   procedure String_Free is new Ada.Unchecked_Deallocation(String, String_Access);
   function Same (Left, Right : in Element_Access) return Boolean is
   begin
      return Left.all = Right.all;
   end Same;
   
   procedure Obj_Free(O : in out Element_Access) is
   begin
      Wide_Free(O.Info.Name);
      if O.Definition.Index /= 0 then
	 for Att in 1..O.Definition.Index loop
	    if O.Definition.List(Att).Enum = Str then
	       String_Free(O.Definition.List(Att).Str);
	    end if;
	 end loop;
      end if;
      
	      
   end Obj_Free;

   
   procedure Print (Info : Element_Info; header : in Window_Type) is
   begin
      
      Draw(Header, 1, 2, White, "Class : " & To_Wide_String(Element_Enum'Image(Info.Tag)));
      Draw(Header, 2, 2, White, "Index : " & To_Wide_String(Element_Index'Image(Info.Index)));
      if Info.Name /= null then
	 Draw(Header, 3, 2, White, "Name : " & Info.Name.all);
      else
	 Draw(Header, 3, 2, White, "Name : ");
      end if;
      Draw(Header, 4, 2, White, "Created : " & To_Wide_String(Image(Info.Created)));
   end Print;
   
   
   
   
   procedure Print (Obj    : in None_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      null;
   end Print;
   
   procedure Write (O : in None_Class;File : in W_Io.File_Type) is
   begin
      null;
   end Write;
   procedure Read (O : out None_Class;File : in W_Io.File_Type) is
   begin
      null;
   end Read;
   
   
   
   
   procedure Print (Attr : in Attributs; Win : in Window_type) is
   begin      

      if Attr.Index /= 0 then
	 
	 for I in 1..Attr.Index loop
	    Draw(Win, I, 1, white, To_Wide_String(Attr.List(I).Name.all));
	    Draw(Win, I, Attr.List(I).Name'Length+1, Red, "=");
	    Draw(Win, I, Attr.List(I).Name'Length+2, white, To_Wide_String(Attr.List(I).Value.all));
	 end loop;
      end if;
   end Print;
      
   procedure Print (Obj    : in Program_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin

      Print(Obj.Info, Header);

      if Obj.line /= null then

	 Draw(Win, 1, 1, white, "Project : " & Obj.line.all);

      end if;
   end Print;
   
   procedure Write (O : in Program_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
      
   end Write;
   procedure Read (O : out Program_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
      
   end Read;
   
   procedure Print (Obj    : in Description_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, header);
      Draw(Win, 1, 1, Yellow, "Description : ");
      Draw(Win, 1, 15, white, Obj.Line.all);
   end Print;
   
   procedure Write (O : in Description_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);      
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
      
   end Write;
   procedure Read (O : out Description_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;

      
   end Read;
   
   procedure Print (Obj    : in License_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin      
      Print(Obj.Info, Header);
      for Line in 1..Obj.License.Line_Last loop
	 Draw(Win, Line, 1, Yellow, Obj.License.Lines(Line).all);
      end loop;
   end Print;
   
   procedure Write (O : in License_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      W_Io.Put_Line(File, To_Wide_String(Integer'Image(O.License.Line_Last)));
      for Line in 1..O.License.Line_Last loop
	 W_Io.Put_Line(File, O.License.Lines(Line).all);
      end loop;
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out License_Class;File : in W_Io.File_Type) is
      Length : Natural := 0;
   begin
      O.Info.Index := Element_Index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      Length := Integer'Value(To_String(Get_Line(File)));
      O.License := new Wide_String_Set(Length);
      for Line in 1..Length loop
	 O.License.lines(Line) := new Wide_String ' (Get_Line(File));
      end loop;
      O.License.Line_Last := Length;
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
      
   end Read;
   
   procedure Print (Obj    : in Main_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw(Win, 1, 1, White, "Name : " & Obj.Line.all);
   end Print;
   
   procedure Write (O : in Main_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Main_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_Index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
      
   end Read;

   procedure Print (Obj    : in Library_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw (Win, 1, 1, White, "Unit : " & Obj.Line.all);
   end Print;
   
   procedure Write (O : in Library_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Library_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
      

   end Read;
   
   
   
   procedure Print (Obj    : in Axiomatic_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw(Win, 1, 1, White, "Title : " & Obj.Line.all);
   end Print;
   
   procedure Write (O : in Axiomatic_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Axiomatic_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
      
   end Read;
   
   procedure Print (Obj    : in Precondition_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw(Win, 1, 1, White, "Precondition : " & Obj.Line.all);
   end Print;
	   
   procedure Write (O : in Precondition_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Precondition_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
      

   end Read;
   
   procedure Print (Obj    : in Axiom_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw(Win, 1, 1, White, "Axiom : " & Obj.Line.all);
   end Print;
   
   procedure Write (O : in Axiom_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Axiom_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
      
   end Read;
   
   procedure Print (Obj    : in Predicate_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw(Win, 1, 1, White, "Predicate : " & Obj.Line.all);
   end Print;
   
   procedure Write (O : in Predicate_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      w_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Predicate_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      W_Io.Put_Line(File, O.Line.all);
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;


   end Read;
   
   procedure Print (Obj    : in Condition_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw(Win, 1, 1, White, "Condition : " & Obj.Line.all);
   end Print;
   
   procedure Write (O : in Condition_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      W_Io.Put_Line(File, O.Line.all);
   end Write;
   procedure Read (O : out Condition_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;


   end Read;
   
   procedure Print (Obj    : in Component_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw(Win, 1, 1, White, "Component : " & Obj.Line.all);
   end Print;
   
   procedure Write (O : in Component_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Component_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;


   end Read;
   
   procedure Print (Obj    : in Action_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw(Win, 1, 1, White, "Action : " & Obj.Line.all);
   end Print;
   
   procedure Write (O : in Action_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Action_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;


   end Read;
   
   procedure Print (Obj    : in Class_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw(Win, 1, 1, White, "Class : " & Obj.Line.all);
   end Print;
   
   procedure Write (O : in Class_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Class_Class;File : in W_Io.File_Type) is
   begin
            O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
      

   end Read;
   
   procedure Print (Obj    : in Machine_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw(Win, 1, 1, White, "Machine : " & Obj.Line.all);
   end Print;
   
   procedure Write (O : in Machine_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out Machine_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
      

   end Read;
   
   procedure Print (Obj    : in System_Class;
		    Header : in Window_Type;
		    Win : in Window_Type) is
   begin
      Print(Obj.Info, Header);
      Draw(Win, 1, 1, White, "System : " & Obj.Line.all);
   end Print;
   
   procedure Write (O : in System_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Element_Enum'Image(Element_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Element_Index'Image(O.Info.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Info.Created)));
      W_Io.Put_Line(File, O.Info.Name.all);
      if not Is_Empty(O.Childs) then
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(Natural(Length(O.Childs)))));
      else
	 W_Io.Put_Line(File, To_Wide_String(Natural'Image(0)));
      end if;
      W_Io.Put_Line(File, O.Line.all);
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Definition.Index)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    W_Io.Put_Line(File, To_Wide_String(O.Definition.List(I).name.all) & '=' & To_Wide_String(O.Definition.List(I).Value.all));
	 end loop;
      end if;
      
   end Write;
   procedure Read (O : out System_Class;File : in W_Io.File_Type) is
   begin
      O.Info.Index := Element_index'Value(To_String(W_Io.Get_Line(File)));
	    
      O.Info.Created := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      O.Info.Name := new Wide_String ' (W_Io.Get_Line(File));
      O.Info.Childs_Num := Natural'Value(To_String(W_Io.Get_Line(File)));
      O.Line := new Wide_String ' (Get_Line(File));
      O.Definition.Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      if O.Definition.Index /= 0 then
	 for I in 1..O.Definition.Index loop
	    declare
	       Name : String_Access;
	       Image : String_Access;
	       Line : constant String :=  To_String(W_Io.Get_Line(File));
	    begin
	       Parse(Line, Name,  Image);
	       O.Definition.List(I) := Make(Name.all, Image.all);
	    end;
	 end loop;
      end if;
      

   end Read;
   
   use Element_Vectors;

end M.Engine ; 
