--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-12-02 14:09:36 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.27.0a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
package Gnos is

   pragma pure (Gnos);
   
   subtype Name_Type is String(1..1024);
   -- Name is string of 1024 characters.
   
   subtype Version_Type is String(1..128);
   -- Version is string of 128 characters.   
   
   type Project_Type is tagged
      record
	 Name    : Name_Type;
	 Version : Version_Type;
      end record;
   -- Project is a name and version.            
   
   Max_Projects : constant Positive := 128;
   -- Maximum number of project in Adam.Systemic.Project_Set.
   subtype Project_Index_Type is Natural range 1..Max_Projects;
   -- Project_Index is the index of project in Adam.Systemic.Project_Set.
   
   type Project_Set_Type is array (Project_Index_Type range <>) of Project_Type;
   -- Project_Set is positive array of project.   
   subtype Extended_Project_Index_Type is Natural range 0..Project_Index_Type'Last;   
   type Manufacture_Type is
      record
	 Projects : Project_Set_Type(1..Max_Projects);
	 
      end record;   
   
   Bad_Passwd, Already_registered : exception;
   Full_Set, Empty_Set, Project_Not_Match : exception;
   Not_Initialized, Already_Initialized : exception;
   
   -------------------------------------
   -- Used by Timer, Dater and Alarm. --
   -------------------------------------
   subtype Years_Count is Natural range 0..385; -- Max Years of Ada implementation (2399) - Current Year (2015) + 1.
   subtype Months_Count is Natural range 0..11;
   subtype Days_Count is Natural range 0..365;   
     
   -----------------------------------------------------------------
   -- Parameters type definitions :
   
   Name_Length_Max : constant Positive := 1024;
   
   subtype Name_Index_Type is Positive range 1..Name_Length_Max;
   
   Units_Max : constant Positive := 65536;
   
   subtype Unit_Index_Type is Positive range 1..Units_Max;   
   
   Ada_Line_Length_Max : constant Positive := 256;
   
   subtype Char_Index_Type is Positive range 1..Ada_Line_Length_Max;
   
   
   Ada_Version_Max : constant Positive := 2399;
   
   subtype Version_Index_Type is Positive range 1983..Ada_Version_Max;
   
   Objects_Max : constant Positive := 65536;
   
   subtype Object_Index_Type is Positive range 1..Objects_Max;
      
   type Human_Lang_Enum is (En, Fr);
   
   type Machine_Lang_Enum is (Project_Define, Ada_2012, Gtk_Ada, Ada_Web_Server);
         
   type Parameters_Flags_Enum_Type is
     
     (
      Null_Parameter,
      Config_Filename,
      Help,
      Version_Edition,
      Name_Length,
      Unit_Max,
      Char_Max,
      Version,
      Object_Max,
      Self_Programming,
      Self_Executed,
      Self_Wait,
      User_Wait,
      Human_Lang,
      With_Gtk,
      With_Ada,
      With_Aws	
     );
   
   type Parameter_Tagged_Record_Type (Requiered_Parameter : Boolean) is tagged
      record	 
	 Switch   : access Wide_String;	 	 
	 Num_Iter : Natural := 0;	 	 
	 Is_Setted : Boolean := False;	 
	 Parameter_Flag : Parameters_Flags_Enum_Type := Null_Parameter;	 
	 Descr : access Wide_String;	 
	 case Requiered_Parameter is
	    when False =>
	       null;
	    when True =>
	       
	       param : access Wide_String;
	       Value : access Wide_String;
	 end case;
      end record;
      
   type Parameters_Kit_Array_Type is 
     array (Parameters_Flags_Enum_Type) of 
     access Parameter_Tagged_Record_Type;
               
   Line_Parameters : constant Parameters_Kit_Array_Type := 
     (
      
      Null_parameter => null,
      
      Config_Filename => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Config_Filename, 
	 Descr => new Wide_String ' ("Configuration filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),	 
      Help => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => help, 
	 Descr => new Wide_String ' ("print this message")),
      Version_Edition => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version_Edition, 
	 Descr => new Wide_String ' ("print the edition version")),
      Name_Length => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("n"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Name_Length,
	 Descr => new Wide_String ' ("Name length max"),
	 Param => new Wide_String ' ("Name_Index_Type"),
	 Value => null),
      Unit_Max => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("u"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Unit_Max,
	 Descr => new Wide_String ' ("Units max"),
	 Param => new Wide_String ' ("Unit_Index_Type"),
	 Value => null),
      Char_Max => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("c"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Char_Max,
	 Descr => new Wide_String ' ("Line length max"),
	 Param => new Wide_String ' ("Char_Index_Type"),
	 Value => null),
      Version => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("V"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version, 
	 Descr => new Wide_String ' ("Language version"),
	 Param => new Wide_String ' ("Version_Index_Type"),
	 Value => null),
      Object_Max => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("o"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Object_Max, 
	 Descr => new Wide_String ' ("Object max"),
	 Param => new Wide_String ' ("Object_index_type"),
	 Value => null),
      Self_Programming => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("p"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Programming,
	 Descr => new Wide_String ' ("Self programming"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      Self_Executed => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("e"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Executed,
	 Descr => new Wide_String ' ("Self Executed"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      Self_Wait => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("w"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Wait,
	 Descr => new Wide_String ' ("Self wait"),
	 Param => new Wide_String ' ("Duration"),
	 Value => null),
      User_wait => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("W"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => User_Wait,
	 Descr => new Wide_String ' ("User wait"),
	 Param => new Wide_String ' ("Duration"),
	 Value => null),
      Human_Lang => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("l"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Human_Lang, 
	 Descr => new Wide_String ' ("Human Language I18 abrev"),
	 Param => new Wide_String ' ("Human_Lang_Enum"),
	 Value => null),
      With_Gtk => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("g"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Gtk, 
	 Descr => new Wide_String ' ("with GtkAda"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      With_Ada => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("a"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Ada, 
	 Descr => new Wide_String ' ("with Ada"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      With_Aws => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Aws, 
	 Descr => new Wide_String ' ("with AWS"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null)
     );
     
   File_Parameters : constant Parameters_Kit_Array_Type := 
     (
      
      Null_parameter => null,
      Config_Filename => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Config_Filename, 
	 Descr => new Wide_String ' ("Configuration filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
	 
      Help => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => help, 
	 Descr => new Wide_String ' ("print this message")),
      Version_Edition => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version_Edition, 
	 Descr => new Wide_String ' ("print the edition version")),
      Name_Length => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("n"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Name_Length,
	 Descr => new Wide_String ' ("Name length max"),
	 Param => new Wide_String ' ("Name_Index_Type"),
	 Value => null),
      Unit_Max => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("u"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Unit_Max,
	 Descr => new Wide_String ' ("Units max"),
	 Param => new Wide_String ' ("Unit_Index_Type"),
	 Value => null),
      Char_Max => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("c"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Char_Max,
	 Descr => new Wide_String ' ("Line length max"),
	 Param => new Wide_String ' ("Char_Index_Type"),
	 Value => null),
      Version => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("V"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version, 
	 Descr => new Wide_String ' ("Language version"),
	 Param => new Wide_String ' ("Version_Index_Type"),
	 Value => null),
      Object_Max => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("o"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Object_Max, 
	 Descr => new Wide_String ' ("Object max"),
	 Param => new Wide_String ' ("Objetcs_index_type"),
	 Value => null),
      Self_Programming => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("p"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Programming,
	 Descr => new Wide_String ' ("Self programming"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      Self_Executed => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("e"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Executed,
	 Descr => new Wide_String ' ("Self Executed"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      Self_Wait => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("w"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Self_Wait,
	 Descr => new Wide_String ' ("Self wait"),
	 Param => new Wide_String ' ("Duration"),
	 Value => null),
      User_wait => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("W"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => User_wait, 
	 Descr => new Wide_String ' ("User wait"),
	 Param => new Wide_String ' ("Duration"),
	 Value => null),
      Human_Lang => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("l"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Human_Lang, 
	 Descr => new Wide_String ' ("Human Language I18 abrev"),
	 Param => new Wide_String ' ("Human_Lang_Enum"),
	 Value => null),
      With_Gtk => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("g"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Gtk, 
	 Descr => new Wide_String ' ("with GtkAda"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      With_Ada => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("a"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Ada, 
	 Descr => new Wide_String ' ("with Ada"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null),
      With_Aws => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => With_Aws, 
	 Descr => new Wide_String ' ("with AWS"),
	 Param => new Wide_String ' ("Boolean"),
	 Value => null)
     );
      
   
   type Abstract_Parameters_Type is abstract tagged null record;
   
   type Parameters_Kit_Record is new Abstract_Parameters_Type with
      record
	 Kit : Parameters_Kit_Array_Type;
      end record;
   
   --Spec_Error : exception;
   --Impl_Limit : exception;
           
end Gnos;
