-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   <one line to give the program's name and a brief idea of what it does.>
--   Copyright (C) 19yy  <name of author>
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with El.Attrib ;
with Gnat.Sockets;
with Gnat.Sha1;

package El.Player is
use Attrib;
   use Gnat;
   
   type Inet_Socket_Access is access Gnat.Sockets.Sock_Addr_Type(Gnat.Sockets.Family_Inet);
   type Inet4_Socket_Access is access Gnat.Sockets.Sock_Addr_Type(Gnat.Sockets.Family_Inet6);
     
   
   type Inet_Addr_Array is array (Machine_Range range <>) of Inet_Socket_Access;
   type Inet6_Addr_Array is array (Machine_Range range <>) of Inet4_Socket_Access;
   
   
   type Internet_Set (Max_Addr : Machine_Range) is
      record
	 IPv4_Addresses : Inet_Addr_Array(1 .. Max_Addr);
	 IPv6_Addresses : Inet6_Addr_Array(1 .. Max_Addr);
      end record;
   
   
   type Player_Record(Player_Type : Player_Enum; Max_Player : Machine_Range) is tagged      
      record	 
	 case Player_Type is
	    when Null_Player =>	       
	       Local : Internet_Set(Max_Player);
	    when Human_Player =>
	       Dialog : Internet_Set(Max_Player);
	    when Machine_Player =>
	       Internet :  Internet_Set(Max_Player);
	 end case;
      end record;
   
   type Player_Access is access Player_Record;
   type Player_Array is array (Positive range <>) of Player_Access;
   type Players_Ptr is access Player_Array;
   
   type Auth_Record is tagged
      record
	 Logname   : access String;
	 Password  : access String;
      end record;      
   
   type Identity_Record is new Auth_Record with
      record
	 
	 Full_Name : access Wide_String;
	 Address   : access Wide_String;
	 City_Code : access Wide_String;
	 City_Name : access Wide_String;
	 Phone_Nb  : access Wide_String;
	 Email     : access Wide_String;
	 Web_Addr  : access Wide_String;
      end record;
   
   
   type User_Record(Player_Type : Player_Enum; Max_Player : Machine_Range) is new Auth_record with
      record
	 Identity   : Identity_Record;
	 Home_Path  : access String;
	 Last_Visit : access Date_Record;
	 Alias_Set         : Attributs(2048);
	 Var_Set           : Attributs(2048);
	 Players    : Players_Ptr := new Player_Array(1..4);
      end record;
   
   
   type User_Access is access User_Record;
   type User_Array is array (Positive range <>) of User_Access;
   
   type User_Set(Max_Users : Positive) is tagged
      record
	 Set : User_Array(1..Max_Users);
	 User_Last : Natural := 0;
      end record;
        
   type Users_Ptr is access all User_Set;

end El.Player ; 
