-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
package El.Params is
      type Parameters_Flags_Enum_Type is
     
     (
      Null_Parameter,
      Config_Filename,
      Help,      
      Quiet,
      Version,
      Geometry,
      Username,
      Address,                  
      Input_Text,
      Term_Name,
      Samples_Filename,
      Max_Epochs,
      Converged,
      Reuse,
      Train,
      Num_Samples,      
      Line_Width,
      Words_Max,
      Num_Hidden,
      Update,
      As_Server,
      style
     );
   
   type Parameter_Tagged_Record_Type (Requiered_Parameter : Boolean) is tagged
      record	 
	 Switch   : access Wide_String;	 	 
	 Num_Iter : Natural := 0;	 	 
	 Is_Setted : Boolean := False;	 
	 Parameter_Flag : Parameters_Flags_Enum_Type := Null_Parameter;	 
	 Descr : access Wide_String;	 
	 case Requiered_Parameter is
	    when False =>
	       null;
	    when True =>
	       
	       param : access Wide_String;
	       Value : access Wide_String;
	 end case;
      end record;
      
   type Parameters_Kit_Array_Type is 
     array (Parameters_Flags_Enum_Type'range) of 
     access Parameter_Tagged_Record_Type;
   
   Line_Parameters : constant Parameters_Kit_Array_Type := 
     
     (Null_parameter => null,
      Config_Filename => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Config_Filename, 
	 Descr => new Wide_String ' ("Configuration filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
	 
      Help => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => help, 
	 Descr => new Wide_String ' ("print this message")),
      
      
      Quiet => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("q"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Quiet, 
	 Descr => new Wide_String ' ("quiet option")),
      Version => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version, 
	 Descr => new Wide_String ' ("print the version")),
      
      Geometry => new Parameter_Tagged_Record_Type '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("g"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => geometry, 
	 Descr => new Wide_String ' ("Descibe the term geometry ; (ex : 24x80)"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      Username => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("e"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Username, 
	 Descr => new Wide_String ' ("user name"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      Address => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("A"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Address, 
	 Descr => new Wide_String ' ("remote address"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      Input_Text => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Input_Text, 
	 Descr => new Wide_String ' ("input text"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Term_Name => new Parameter_Tagged_Record_Type '
      	(Requiered_Parameter => True, Switch => new Wide_String ' ("N"), Num_Iter => 0,
      	 Is_Setted => False, Parameter_Flag => Term_Name, 
      	 Descr => new Wide_String ' ("Terminal name"),
      	 Param => new Wide_String ' ("String"),
      	 Value => null),
      Samples_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("f"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag =>  Samples_filename, 
	 Descr => new Wide_String ' ("Samples filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Max_epochs => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("m"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Max_Epochs, 
	 Descr => new Wide_String ' ("Max_Epochs"),
	 Param => new Wide_String ' ("Integer"),
	 Value => null),
      Converged => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("c"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Converged, 
	 Descr => new Wide_String ' ("Converged"),
	 Param => new Wide_String ' ("Real number"),
	 Value => null),
      Reuse => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("r"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Reuse, 
	 Descr => new Wide_String ' ("Reuse")),	 
      Train => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("l"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Train, 
	 Descr => new Wide_String ' ("Train")),
      Num_samples => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("n"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Num_Samples, 
	 Descr => new Wide_String ' ("Num_Samples"),
	 Param => new Wide_String ' ("Integer"),
	 Value => null),      
      Line_Width => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("W"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Line_Width, 
	 Descr => new Wide_String ' ("Line_Width"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
      Words_Max => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("L"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Words_Max, 
	 Descr => new Wide_String ' ("Words_Max"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
      Num_hidden => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("H"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Num_hidden, 
	 Descr => new Wide_String ' ("Num_hidden"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
      Update => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("u"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Update, 
	 Descr => new Wide_String ' ("update"),
	 Param => new Wide_String ' ("string"),
	 Value => null),
      As_server => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("a"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => As_server, 
	 Descr => new Wide_String ' ("As server")),
      style => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => style, 
	 Descr => new Wide_String ' ("style"),
	 Param => new Wide_String ' ("string : Black_And_White, Black_And_Color, Color_And_White" &
				       Wide_Character'Val(10) &
				       "                       White_And_Color, Color_And_Color, White_And_White"),
	 Value => null)
	
	);
   
   File_Parameters : constant Parameters_Kit_Array_Type := 
     
     (Null_parameter => null,
      Config_Filename => new Parameter_Tagged_Record_Type ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Config_Filename, 
	 Descr => new Wide_String ' ("Configuration filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
	 
      Help => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => help, 
	 Descr => new Wide_String ' ("print this message")),
      
      
      Quiet => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("q"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Quiet, 
	 Descr => new Wide_String ' ("quiet option")),
      Version => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version, 
	 Descr => new Wide_String ' ("print the version")),
      
     Geometry => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("g"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => geometry, 
	 Descr => new Wide_String ' ("Descibe the terminal geometry ; (ex : 24x80)"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
     Username => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("e"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Username, 
	 Descr => new Wide_String ' ("user name"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      Address => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("A"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Address, 
	 Descr => new Wide_String ' ("remote address"),
	 Param => new Wide_String ' ("String"),
	 Value => null),
      Input_Text => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Input_Text, 
	 Descr => new Wide_String ' ("input text"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Term_name => new Parameter_Tagged_Record_Type '
      	(Requiered_Parameter => True, Switch => new Wide_String ' ("N"), Num_Iter => 0,
      	 Is_Setted => False, Parameter_Flag => Term_name, 
      	 Descr => new Wide_String ' ("Terminal name"),	 
      	 Param => new Wide_String ' ("String"),
      	 Value => null),
      Samples_Filename => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("f"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Samples_Filename, 
	 Descr => new Wide_String ' ("Samples_Filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      Max_epochs => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("m"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Max_Epochs, 
	 Descr => new Wide_String ' ("Max_Epochs"),
	 Param => new Wide_String ' ("Integer"),
	 Value => null),
      Converged => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("c"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Converged, 
	 Descr => new Wide_String ' ("Converged"),
	 Param => new Wide_String ' ("Real"),
	 Value => null),
      Reuse => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("r"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Reuse, 
	 Descr => new Wide_String ' ("Reuse")),	 
      Train => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("l"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Train, 
	 Descr => new Wide_String ' ("Train")),
      Num_samples => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("n"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Num_Samples, 
	 Descr => new Wide_String ' ("Num_Samples"),
	Param => new Wide_String ' ("Integer"),
	 Value => null),
      Line_Width => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("W"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Line_Width, 
	 Descr => new Wide_String ' ("Line_Width"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
      Words_Max => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("L"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Words_Max, 
	 Descr => new Wide_String ' ("Words_Max"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
      Num_hidden => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("H"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Num_hidden, 
	 Descr => new Wide_String ' ("Num_hidden"),
	 Param => new Wide_String ' ("integer"),
	 Value => null),
      Update => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("u"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Update, 
	 Descr => new Wide_String ' ("update"),
	 Param => new Wide_String ' ("string"),
	 Value => null),
      As_server => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("a"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => As_Server, 
	 Descr => new Wide_String ' ("As server")),
      style => new Parameter_Tagged_Record_Type '
	(Requiered_Parameter => True, Switch => new Wide_String ' ("s"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => style, 
	 Descr => new Wide_String ' ("style"),
	 Param => new Wide_String ' ("string : Black_And_White, Black_And_Color, Color_And_White" &
				       Wide_Character'Val(10) &
				       "                       White_And_Color, Color_And_Color, White_And_White"),
	 Value => null)
	

	);
   
   
   type Parameters_Kit_Record_Type is tagged
      record
	 All_Parameters : Parameters_Kit_Array_Type;
      end record;

end El.Params ; 
