-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"

with Ada.Strings.Wide_Fixed;
with Ada.Characters.Handling;
use Ada.Strings;
use Ada.Characters.Handling;

with Ada.Wide_Characters.Handling;
use Ada.Wide_Characters.Handling;
use Ada;

with Ada.Tags;
use Ada.Tags;

with PragmARC.Ansi_Tty_Control;      
use PragmARC.Ansi_Tty_Control;

with PragmARC.Wrapping;

with Ada.Command_Line;
use Ada.Command_Line;

with Ada.Strings.UTF_Encoding.Strings;
with Ada.Strings.UTF_Encoding.Wide_Strings;

with El.Langua ;
with El.Attrib ;
with El.Errors ;
with Ansi_Console;


package body El.Intell is
use Attrib ;
   use Errors ;
   use Langua ;
   use Ansi_Console;

   --------------------------------------------------------
   --             Organizer sub routines                 --
   --------------------------------------------------------
   function Class_Value(Line : in Wide_String) return Tag_Name is
      Class : Tag_Name;
      Index : Natural := Wide_Fixed.Index(Line, " ");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " ");
   begin
      if index /= 0 then
   	 if Next /= 0 then
   	    Class := Tag_name'Value(To_String(Line(Index+1..Next-1)));
   	 else
   	    Class := Tag_name'Value(To_String(Line(Index+1..Line'Last)));
   	 end if;
      else
   	 raise Spec_Error;
      end if;
      return Class;
   end Class_Value;
   
   
   function Cmd_Value(Line : in Wide_String) return Cmd_Name is
      Cmd : Cmd_Name := Null_Item;
      Index : Natural := Wide_Fixed.Index(Line, " ");
   begin
      if index /= 0 then	 
	 if not Exist_Word (Line(Line'First..Index-1)) then	 
	    Cmd := Cmd_Name'Value(To_String(Line(Line'First..Index-1)));
	 else
	    Cmd := Word;
	 end if;
      elsif not Exist_Word (Line) then	 
	 Cmd := Cmd_Name'Value(To_String(Line));
      else
	 Cmd := Word;
      end if;
      return Cmd;
   end Cmd_Value;
   
   
   
   function Id (Name : in Tag_Name) return Abstracted_Access is
   begin
      
      if Name = Animal then
   	 return new Animal_Class;
      elsif Name = Deal then
   	 return new Deal_Class;
      elsif Name = car then
   	 return new car_Class;	 
      elsif Name = House then
   	 return new House_Class;
      elsif Name = Plan then
   	 return new Plan_Class;
      elsif Name = Planning then
   	 return new Planning_Class;
      elsif Name = Activity then
   	 return new Activity_Class;
      elsif Name = Content then
   	 return new Content_Class;
      elsif Name = Universe then
   	 return new Universe_Class;
      elsif Name = contact then
   	 return new Contact_Class;
      elsif Name = Event then
   	 return new Event_Class;
      elsif Name = Note then
   	 return new Note_Class;
      elsif Name = Acc_line then
   	 return new Acc_line_Class;
      elsif Name = Saved_ac then
   	 return new Saving_account_Class;
      elsif Name = Perso_ac then
   	 return new Personal_Account_Class;
      elsif Name = Entep_ac then
   	 return new Enteprise_Account_Class;
      elsif Name = Def_class then
	 return new Define_Class;
      end if;
	return null;
   end Id;            
   
   -----------------------------------------------------------------------------
   --                     Speific function
   function Genre_Value(Line : in Wide_String) return Genre_Type is
      
      Genre : Genre_type := Female;
      Index : Natural := Wide_Fixed.Index(Line, " ");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " ");
   begin
      
      if Next /= 0 then
   	 Genre := Genre_Type'Value
   	   (To_String(Line(Next+1..Wide_Fixed.Index(Line(next+1..Line'Last), " ")-1)));
      end if;      
      return Genre;
   exception
      when others =>
   	 return Genre;
   end Genre_Value;
   
   function Name_Value(Line : in Wide_String) return Name_Type is
      Name : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
   begin
      if Last /= 0 then
   	 Wide_Fixed.Move(Line(last+1..Line'last), Name);
      end if;      
      return Name;
   exception
      when others =>
   	 return Name;
   end Name_Value;
   
     
   function Period_Value(Line : in Wide_String) return Duration is
      Period : Duration := 0.0;
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
      
      Back_Last : Natural := Wide_Fixed.Index(Line(Last..Line'Last), """", backward);
      Back_next : Natural := Wide_Fixed.Index(Line(last..Back_Last-1), """");
      
   begin
      if Back_next /= 0 then
   	 Period := Duration'value(To_String(Line(last+20..Back_next-1)));
      end if;      
      return period;
   exception
      when others =>
   	 return period;
   end Period_Value;
   
   
   function Plan_description_Value(Line : in Wide_String) return Wstring_64 is
      Desc : Wstring_64 := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
      
      Back_Last : Natural := Wide_Fixed.Index(Line(Last..Line'Last), """", backward);
      Back_next : Natural := Wide_Fixed.Index(Line(last..Back_Last-1), """");
      
   begin
      if Back_Next /= 0 then
   	 Wide_Fixed.Move(Line(Back_Next+1..Back_Last-1), desc);
      end if;      
      return Desc;
   exception
      when others =>
   	 return Desc;
   end Plan_description_Value;
   
   
     
   function Object_Name(Line : in Wide_String) return Name_Type is
      Name : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
            
   begin
      if Line'Last /= 0 then
   	 Wide_Fixed.Move(Line(Index+1..Line'last), Name);
      end if;      
      return Name;
   exception
      when others =>
   	 return Name;
   end Object_Name;
   
   
   function Note_Value(Line : in Wide_String) return Name_Type is
      Name : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
   begin
      if Next /= 0 then
   	 Wide_Fixed.Move(Line(Next+1..Last), Name);
      end if;      
      return Name;
   exception
      when others =>
   	 return Name;
   end Note_Value;
   
   
   function Line_Name_Value(Line : in Wide_String) return Name_Type is
      Name : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
   begin
      if Last /= 0 then
   	 Wide_Fixed.Move(Line(next+1..Last-1), Name);
      end if;      
      return Name;
   exception
      when others =>
   	 return Name;
   end Line_Name_Value;
   
   
   
   function Designation_Value(Line : in Wide_String) return Designation_Line is
      Design : Designation_Line := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
   begin
      if Next /= 0 then
   	 Wide_Fixed.Move(Line(Last+1..Last_2-1), design);
      end if;      
      return design;
   exception
      when others =>
   	 return design;
   end designation_Value;
   
   
   
   
   function Mark_Value(Line : in Wide_String) return Name_Type;
   function surface_Value(Line : in Wide_String) return Name_Type;
     
   function Mark_Value(Line : in Wide_String) return Name_type is
      Mark : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
   begin
      if Next /= 0 then
   	 Wide_Fixed.Move(Line(Last+1..Last_2-1), Mark);
      end if;      
      return Mark;
   exception
      when others =>
   	 return Mark;
   end Mark_Value;
   
   
   
   
   function surface_Value(Line : in Wide_String) return Name_Type is
      
      surface : Name_type := (others => Wide_Character'Val(32));
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
   begin
      if Next /= 0 then
   	 Wide_Fixed.Move(Line(Last+1..Last_2-1), surface);
      end if;      
      return surface;
   exception
      when others =>
   	 return surface;
   end Surface_Value;
   
   
   
   function address_Value(Line : in Wide_String) return Address_Type is
      Address : Address_type := (others => Wide_Character'Val(32));
      
      
      Index : Natural := Wide_Fixed.Index(Line(Line'First..Line'Last-1), """", backward); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Line'first..Index-1), """", backward); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Line'first..Next-1), """", backward);
            
   begin
      if Next /= 0 then
   	 Wide_Fixed.Move(Line(Last+1..next-1), address);
      end if;      
      return address;
   exception
      when others =>
   	 return address;
   end address_Value;
   

   
   
   function Car_genre_Value(Line : in Wide_String) return Name_Type is
   
      
      genre : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
      
      Next_2 :  Natural := Wide_Fixed.Index(Line(Last_2+1..Line'Last), " ");
      
   begin
      if Next /= 0 then
   	 Wide_Fixed.Move(Line(Last_2+1..Next_2-1), genre);
      end if;      
      return genre;
   exception
      when others =>
   	 return genre;
   end Car_genre_Value;
   
   
   
   
   function Delays_Value(Line : in Wide_String) return Days_delay is
      delays : Days_delay := 0;
      
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Line'first..Line'Last), " ", backward); 
      
      
   begin
      if Last_2 /= 0 then
   	 Delays := Days_Delay'Value(To_String(Line(Last_2+1..Line'last)));
      end if;      
      return delays;
   exception
      when others =>
   	 return delays;
   end Delays_Value;
   
   
   
   function Car_immat_Value(Line : in Wide_String) return Name_type is
      Immat : Name_type := (others => Wide_Character'Val(32));
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Line'first..Line'Last), " ", backward); 
      
   begin
      if Last_2 /= 0 then
   	 Wide_Fixed.Move(Line(Last_2+1 .. Line'last), immat);
      end if;      
      return immat;
   exception
      when others =>
   	 return immat;
   end Car_immat_Value;
   
   
   function City_name_Value(Line : in Wide_String) return Address_Type is
      city : Address_type := (others => Wide_Character'Val(32));
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Line'first..Line'Last-1), """", backward); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Line'first..Last_2-1), " ", backward); 
      
   begin
      if Last_2 /= 0 then
   	 Wide_Fixed.Move(Line(Last+2 .. Line'Last-1), city);
      end if;      
      return city;
   exception
      when others =>
   	 return city;
   end City_name_Value;
   
   function City_code_Value(Line : in Wide_String) return Name_type is
      code : Name_type := (others => Wide_Character'Val(32));
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Line'first..Line'Last-1), """", backward); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Line'first..Last_2-2), " ", backward); 
      
      --prev  : Natural := Wide_Fixed.Index(Line(Line'first..Last-1), " ", backward); 
      
   begin
      if Last_2 /= 0 then
   	 Wide_Fixed.Move(Line(Last+1 .. Last_2-2), code);
      end if;      
      return code;
   exception
      when others =>
   	 return code;
   end City_code_Value;
   

   
   
   
   
   function Price_Value(Line : in Wide_String) return Price_type is
      Price : Price_Type := 0.0;
      
      next  : Natural := Wide_Fixed.Index(Line(Line'first..Line'Last), " "); 
      
      Next_2  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next_2+1..Line'last), " "); 
      
      Last_2  : Natural := Wide_Fixed.Index(Line(last+1..Line'last), " "); 
      
   begin
      if Last /= 0 then
   	 Price := Price_type'Value(To_String(Line(last+1..Last_2-1)));
      end if;      
      return Price;
   exception
      when others =>
   	 return Price;
   end Price_Value;
   
   
   
   function sum_Value(Line : in Wide_String) return Fixed_Sum is
      Sum   : Fixed_Sum := 0.0;
      
      Last_2  : Natural := Wide_Fixed.Index(Line(Line'first..Line'Last), " ", backward); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Line'first..Last_2-1), " ", backward); 
      
   begin
      if Last_2 /= 0 then
   	 Sum := Fixed_Sum'Value(To_String(Line(Last+1..Last_2-1)));
      end if;      
      return sum;
   exception
      when others =>
   	 return sum;
   end sum_Value;
   
   
   
   
   
   function Line_value(Line : in Wide_String) return Note_Line is
      note : Note_Line := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(next+1..Line'Last), " "); 
   begin
      if Next /= 0 then
   	 Wide_Fixed.Move(Wide_String(Line(Last+1..Line'last)), Wide_String(Note));
      end if;      
      return note;
   exception
      when others =>
   	 return note;
   end Line_value;
   
   function Account_name(Line : in Wide_String) return Wide_string is
      Name : Wide_String(1..Name_Type'length) := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
            
   begin
      if Next /= 0 then
   	 Wide_Fixed.Move(Line(next+1..Line'last), Name);
      end if;      
      return Name;
   exception
      when others =>
   	 return Name;
   end Account_name;
   
   
   
   
   
   
   
   
   function Event_Value(Line : in Wide_String) return Name_Type is
      Name : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
   begin
      if Last /= 0 then
   	 Wide_Fixed.Move(Line(next+1..Last-1), Name);
      end if;      
      return Name;
   exception
      when others =>
   	 return Name;
   end Event_Value;
   
   
     
     
     function contact_Value(Line : in Wide_String) return Name_Type is
      Name : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
   begin
      if Last /= 0 then
   	 Wide_Fixed.Move(Line(next+1..Last-1), Name);
      end if;      
      return Name;
   exception
      when others =>
   	 return Name;
   end contact_Value;
         
   
   
   function Tel_num_Value(Line : in Wide_String) return Tel_num_type is
      
      Tel_num : Tel_num_type := (others => Wide_Character'Val(32));
      Index : Natural := Wide_Fixed.Index(Line, " ");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " ");      
      Next_2  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");            
      
   begin
      
      if Next_2 /= 0 then
   	 Wide_Fixed.Move(Line(Next_2+1..Line'last), Tel_Num);
      end if;      
      return Tel_num;
   exception
      when others =>
   	 return Tel_Num;
   end Tel_num_Value;
   
   
   
   
   function description_Value(Line : in Wide_String) return Description_type is
      
      descrip : Description_type := (others => Wide_Character'Val(32));
      Index : Natural := Wide_Fixed.Index(Line, " ");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " ");      
      Next_2  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
      Last  : Natural := Wide_Fixed.Index(Line(Next_2+1..Line'Last), " ");      
      
      
   begin
      
      if Last /= 0 then
   	 Wide_Fixed.Move(Line(Last+1..Line'last), Descrip);
      end if;      
      return Descrip;
   exception
      when others =>
   	 return Descrip;
   end description_Value;
   
   function Date_Value(Line : in Wide_String) return Date_Wstring is
      
      Date  : Date_Wstring := (others => Wide_Character'Val(32));
      Index : Natural := Wide_Fixed.Index(Line, " ");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " ");      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
   begin
      
      if Last /= 0 then
   	 Wide_Fixed.Move(Line(last+1..Line'last), Date);
      end if;      
      return Date;
   exception
      when others =>
   	 return Date;
   end Date_Value;
   
   
   function Get_Date_from(Line : in Wide_String) return time is
      
      Date  : Time := Clock;
      Index : Natural := Wide_Fixed.Index(Line, """");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), """");
      Last  : Natural := Wide_Fixed.Index(Line(Next..Line'Last), " "); 
   begin
      
      if Last /= 0 then
   	 Date := Formatting.Value(To_String(Line(last+1..Last+19)));
      end if;      
      return Date;
   exception
      when others =>
   	 return Date;
   end Get_Date_from;
   
   function Get_Date_To(Line : in Wide_String) return time is
	 
      Date  : Time := Clock;
      Index : Natural := Wide_Fixed.Index(Line, """");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), """");
      Last  : Natural := Wide_Fixed.Index(Line(Next..Line'Last), " "); 
   begin
      
      if Last /= 0 then
   	 Date := Formatting.Value(To_String(Line(last+21..Last+39)));
      end if;      
      return Date;
   exception
      when others =>
   	 return Date;
   end Get_Date_To;
   
   
   
   
   
     
   function Arity_Value(Line : in Wide_String) return Arity_Range is
      
      arity : Arity_Range := 3;
      Index : Natural := Wide_Fixed.Index(Line, " ");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " ");
   begin
      
      if Next /= 0 then
   	 Arity := Arity_Range'Value(To_String(Line(Next+1..Line'last)));
      end if;      
      return Arity;
   exception
      when others =>
   	 return Arity;
   end Arity_Value;
   
   function Num_Value(Line : in Wide_String) return Abstracted_Index is
      
      num : Abstracted_Index := 1;
      Index : Natural := Wide_Fixed.Index(Line, " ");      
   begin
      
      if Index /= 0 then
   	 Num := positive'Value(To_String(Line(Index+1..Line'last)));
   	 return Num;
      else
   	 raise Spec_Error;
      end if;
      
   end Num_Value;
   
   
   
   
   function Raison_Value(Line : in Wide_String) return Wstring_38 is
      
      Raison : Wstring_38 := (others => ' ');
      
      
      Index : Natural := Wide_Fixed.Index(Line, """");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), """");
   begin
      
      if Next /= 0 then
   	 Wide_Fixed.Move( (Line(index+1..Next-1)), Raison);
   	 return Raison;
      end if;
      return raison;
   exception
      when others =>
   	 return raison;
   end Raison_Value;
   
   
     
   function Full_address_Value(Line : in Wide_String) return Wstring_38 is
      
      
      Address : Wstring_38 := (others => ' ');
      
      Index : Natural := Wide_Fixed.Index(Line, """", backward);
      Next  : Natural := Wide_Fixed.Index(Line(Line'first..Index-1), """", backward);
      
      
   begin
      
      if Next /= 0 then
   	 Wide_Fixed.Move((Line(Next+1..index-1)), Address);
   	 return Address;
      end if;
      return address;
   exception
      when others =>
   	 return address;
   end Full_address_Value;
   
   function Ste_Type_Value(Line : in Wide_String) return Wstring_24 is
      
      Ste_Type : Wstring_24 := (others => ' ');
      
      Last  : Natural := Wide_Fixed.Index(Line, " ", backward);
      Index : Natural := Wide_Fixed.Index(Line(Line'First..Last-1), " ", backward);
      Next  : Natural := Wide_Fixed.Index(Line(Line'first..Index-1), " ", backward);
      
   begin
      
      if Next /= 0 then
   	 Wide_Fixed.Move( (Line(next+1..index-1)), Ste_Type);
   	 return Ste_Type;
      end if;
      return Ste_type;
   exception
      when others =>
   	 return Ste_type;
   end Ste_Type_Value;
   
   function Fiscal_Value(Line : in Wide_String) return Wstring_24 is
      
      
      Fiscal : Wstring_24 := (others => ' ');
      
      Last  : Natural := Wide_Fixed.Index(Line, " ", backward);
      Index : Natural := Wide_Fixed.Index(Line(Line'First..Last-1), " ", backward);
      
      
   begin
      
      if last /= 0 then
   	 Wide_Fixed.Move( (Line(index+1..last-1)), Fiscal);
   	 return Fiscal;
      end if;
      return fiscal;
   exception
      when others =>
   	 return fiscal;
   end Fiscal_Value;
   
   
   function Affilia_Value(Line : in Wide_String) return Wstring_24 is
      
      
      Affilia : Wstring_24 := (others => ' ');
      
      Last  : Natural := Wide_Fixed.Index(Line, " ", backward);      
      
      
   begin
      
      if last /= 0 then
   	 Wide_Fixed.Move((Line(Last+1..Line'last)), Affilia);
   	 return Affilia;
      end if;
      return Affilia;
   exception
      when others =>
   	 return affilia;
   end Affilia_Value;
   
   
   
   
   function Acc_name_Value(Line : in Wide_String) return Name_type is
      Name : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
            
   begin
      if Next /= 0 then
   	 Wide_Fixed.Move(Line(next+1..Last-1), name);
      end if;      
      return name;
   exception
      when others =>
   	 return name;
   end Acc_name_Value;
   
   function denom_Value(Line : in Wide_String) return Wstring_16 is
      Description : Wstring_16 := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2 : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), """");
      Last_3 : Natural := Wide_Fixed.Index(Line(Last_2+1..Line'Last), """");
      
   begin
      if Next /= 0 then
   	 Wide_Fixed.Move(Line(Last_2+1..Last_3-1), Description);
      end if;      
      return Description;
   exception
      when others =>
   	 return Description;
   end Denom_Value;
   
   
   function ressources_Value(Line : in Wide_String) return Wstring_32 is
      Description : Wstring_32 := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2 : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), """");
      Last_3 : Natural := Wide_Fixed.Index(Line(Last_2+1..Line'Last), """");
      
   begin
      if Next /= 0 then
   	 Wide_Fixed.Move(Line(Last_2+1..Last_3-1), Description);
      end if;      
      return Description;
   exception
      when others =>
   	 return Description;
   end ressources_Value;
   
   
   
   function Peer_name(Line : in Wide_String) return Wstring_16 is
      Peer: Wstring_16 := (others => Wide_Character'Val(32));
      
      
      Last_2 : Natural := Wide_Fixed.Index(Line, """", backward);
      Last_3 : Natural := Wide_Fixed.Index(Line(Line'first..Last_2-1), """", backward);
      
   begin
      if Last_3 /= 0 then
   	 Wide_Fixed.Move(Line(Last_3+1..Last_2-1), Peer);
      end if;      
      return Peer;
   exception
      when others =>
   	 return Peer;
   end Peer_name;
   
   
   function Account_num_value(Line : in Wide_String) return Account_Num_range is
      Acc_Num : Account_Num_range := 10;
      
      Index : Natural := Wide_Fixed.Index(Line, """"); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), """"); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2 : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
      
      
   begin
      if Last_2 /= 0 then
   	 Acc_Num := Account_Num_Range'Value(To_String(Line(Last+1..Last_2-1)));
      end if;      
      return Acc_num;
   exception
      when others =>
   	 return Acc_num;
   end Account_Num_value;
   
      
   
   
   function quantity_value(Line : in Wide_String) return quantity_range is
      Acc_Num : quantity_range := 1;
      
      Index : Natural := Wide_Fixed.Index(Line, """"); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), """"); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2 : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
      Last_3 : Natural := Wide_Fixed.Index(Line(Last_2+1..Line'Last), " ");
      Last_4 : Natural := Wide_Fixed.Index(Line(Last_3+1..Line'Last), " ");
      Last_5 : Natural := Wide_Fixed.Index(Line(Last_4+1..Line'Last), " ");
   begin
      if Last_5 /= 0 then
   	 Acc_Num := Account_Num_Range'Value(To_String(Line(Last_4+1..Last_5-1)));
      end if;      
      return Acc_num;
   exception
      when others =>
   	 return Acc_num;
   end quantity_value;
   
   function Payment_Delays_Value(Line : in Wide_String) return Payment_delay is
      delays : Payment_delay := 0;
      
      Index : Natural := Wide_Fixed.Index(Line, """", backward); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Line'First..Index-1), """", backward); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Line'first..Next-2), " ", backward);
            
   begin
      if Last /= 0 then
   	 delays := Payment_delay'Value(To_String(Line(Last+1..next-2)));
      end if;      
      return delays;
   exception
      when others =>
   	 return delays;
   end Payment_Delays_Value;
   
   
   function U_Ht_value(Line : in Wide_String) return Fixed_Unit_ht is
      Price : Fixed_Unit_HT := 0.0;
      
      Index : Natural := Wide_Fixed.Index(Line, """"); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), """"); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2 : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
      Last_3 : Natural := Wide_Fixed.Index(Line(Last_2+1..Line'Last), " ");
      
   begin
      if Last_2 /= 0 then
   	 Price := Fixed_Unit_HT'Value(To_String(Line(Last_2+1..Last_3-1)));
      end if;      
      return Price;
   exception
      when others =>
   	 return Price;
   end U_HT_value;
   
   
   function TVA_value(Line : in Wide_String) return Fixed_factor is
      Factor : Fixed_factor:= 0.0;
      
      Index : Natural := Wide_Fixed.Index(Line, """"); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), """"); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");
      
      Last_2 : Natural := Wide_Fixed.Index(Line(Last+1..Line'Last), " ");
      Last_3 : Natural := Wide_Fixed.Index(Line(Last_2+1..Line'Last), " ");
      Last_4 : Natural := Wide_Fixed.Index(Line(Last_3+1..Line'Last), " ");
      
   begin
      if Last_4 /= 0 then
   	 Factor := Fixed_factor'Value(To_String(Line(Last_3+1..Last_4-1)));
      end if;      
      return Factor;
   exception
      when others =>
   	 return Factor;
   end TVA_value;
   
   
   --
   -----------------------------------------------------------------------------
   

end El.Intell ; 
