-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with Ada.Containers.Vectors;
use Ada.Containers;
with Ada.Calendar;
use Ada.Calendar;
with El.Attrib;
with El.Strings;
with Ada.Wide_Text_Io;
with Windows_Console;
with Ansi_Console;
generic
   Lines_Left : Positive;
   Ptr_Max    : Positive := 2048;
   with package windows is new Windows_Console (<>);

package El.Classe is
   package W_Io renames Ada.Wide_Text_Io;
   use W_Io;
   use Attrib ;
   use Strings;
   use Windows;
   use Ansi_Console;
   
   subtype Wstring_24 is Wide_String(1..24);
   subtype Wstring_32 is Wide_String(1..32);
   subtype Wstring_38 is Wide_String(1..38);
   subtype Wstring_48 is Wide_String(1..48);
   subtype Wstring_64 is Wide_String(1..64);

   
   Lines : Line_Range := Windows.Term_Lines_Max;
   Cols  : Column_Range := Windows.Term_Columns_Max;
   
   subtype Index_Line_Range is Positive range 1..Lines_Left-2;
   
   type Accounting_Windows_Type
     (L : Line_Range;
      C : Column_Range) is tagged
      record
	 
	 Tags_Win : Window_Type := (L+2, C, Lines_Left-2, 24,  
				    Single_Line_Frame, Cyan, Red);
	 Acc_Num_Win : Window_Type := (L+2, C+24, Lines_Left-2, 8,  
				       Single_Line_Frame, Cyan, Red);
	 Unit_Ht_Price_Win : Window_Type := (L+2, C+32, Lines_Left-2, 16,  
					     Single_Line_Frame, Cyan, Red);
	 TVA_Factor_Win : Window_Type := (L+2, C+48, Lines_Left-2, 8,  
					  Single_Line_Frame, Cyan, Red);
	 Qt_Win : Window_Type := (L+2, C+56, Lines_Left-2, 8,  
				  Single_Line_Frame, Cyan, Red);
	 Total_Ht_Win : Window_Type := (L+2, C+64, Lines_Left-2, 16,  
					Single_Line_Frame, Cyan, Red);
	 Total_TTC_Win : Window_Type := (L+2, C+80, Lines_Left-2, 16,  
					 Single_Line_Frame, Cyan, Red);
	 
	 Peer_Win : Window_Type := (L+2, C+96, Lines_Left-2, Cols-(C+95+2),  
				    Single_Line_Frame, Cyan, Red);	 
	 
      end record;   
   

   
   
   type vector_type is delta 0.00001 range 0.0..0.99999;
   subtype Duration_type is Long_Float range 0.0..Long_Float'Last;
   type Space_Array is array (Positive range <>) of Vector_Type;
   subtype Arity_Range is Positive range 1..3;
   
   
   
   Arity       : constant Arity_Range := 3;
   
   type Coordonate_Type(Arity : Arity_Range) is tagged
      record
	 space  : Space_Array(1..Arity)  := (others => 0.0);
	 Date   : Duration_Type := 0.0;
      end record;
   
   function Arity_Value(Line : in Wide_String) return Arity_Range;
   
   
   
   
   subtype Abstracted_Index is Positive range 1..Ptr_Max;
                        
   type Abstracted_Class(Tag : Tag_Name);
   type Abstracted_Access is access all Abstracted_Class'Class;
   function Equal(Left, Right : in Abstracted_Access) return Boolean;
   
   
   
   package Abstracted_Vectors is new Vectors(Abstracted_Index, Abstracted_Access, Equal);
   use Abstracted_Vectors;   
   subtype Objects_vector is Abstracted_Vectors.Vector;
   
   type Abstracted_Class(Tag : Tag_Name) is abstract new Coordonate_Type(3) with
      record
	 Index       : Abstracted_Index := 1;
	 Name        : Name_Type := (others => Wide_Character'Val(32));
	 Vector      : Objects_Vector;
	 Create_Date : Time := Clock;
	 Def         : Attrib.Attributs(4);	 
	 Ucost       : Float := 0.0;
	 Hcost       : Float := 0.0;
	 Path        : String_Access := new String ' ("");
      end record;
   
   
   
   procedure Write (O : in Abstracted_Class;File : in W_Io.File_Type) is abstract;
   procedure Read (O : in out Abstracted_Class;File : in W_Io.File_Type) is abstract;
   procedure Random (O : in out Abstracted_Class) is abstract;

end El.Classe ; 
