-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with ANSI_Console;
use ANSI_Console;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Wide_Fixed;
use Ada.Strings;
with Ada.Integer_Text_Io;
use Ada;
with El.Strings;

package body El.Classe.Universe_class is
   
   use Strings;
   -----------------------------------------------------------------------------
   --                    Universe
   procedure Print (Object : Universe_Class'class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name : out Name_Type) is
      
      Check_Point : natural := Wide_Character'Pos('z') - Arity;
      Index       : Natural := 0;
   begin
      Draw(Win, Win_Index+1, 3, Cyan, "Index   : " &
	     To_Wide_String(Abstracted_Index'Image(Object.Index)));
      Draw(Win, Win_Index+2, 3, Cyan, "Created : " &
	     To_Wide_String(Image(Object.Create_Date)));
      Draw(Win, Win_Index+3, 3, Cyan, "Name    : " & Object.Name);
      Draw(Win, Win_Index+4, 3, Cyan, "Arity   : " &
	     To_Wide_String(Natural'Image(Arity)));
      Draw(Win, Win_Index+5, 3, Cyan, "Old     : " &
	     To_Wide_String(Long_Float'Image(Object.Old)));      	 
      Draw(Win, Win_Index+6, 3, Cyan, "Origine : ");
      for V_Index in Check_point..Check_Point+Arity-1 loop	 
	 Draw(Win, Win_Index+7+index, 3, Cyan, Wide_Character'Val(V_Index) &
		" => " & To_Wide_String
		(Vector_Type'Image(Object.Origine.Space(Index+1))));
	 Index := Index + 1;
      end loop;
      
      Draw(Win, Win_Index+7+Index, 3, Cyan, "T => " &
	     To_Wide_String(Duration_Type'image(Object.Origine.date)));

      Win_Index := Win_Index + 7 + index;
      
      Draw(Win, Win_Index+1, 3, Cyan, "Definition " & Object.Name);
      Win_Index := Win_Index + 1;
      for I in 1..Object.Def.Index loop
	 Draw(Win, Win_Index+1, 3, Cyan, "Attr " & To_Wide_String(Natural'Image(I)) & " : " &
		To_Wide_String(Object.Def.List(I).Names) & '=' & To_Wide_String(Object.Def.List(I).Image));
	 Win_Index := Win_Index + 1;
      end loop;
      
      
      Name := Object.Name;
   end Print;
   
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Name : in Name_Type) return Abstracted_Access is
      O : Abstracted_Access := new Universe_Class;
   begin
      if O /= null then
	 Wide_Fixed.Move(Name, O.Name, Error, Left, ' ');
	 Draw(Win, Win_Index+1, 3, Cyan, "Created : " &
		To_Wide_String(Image(Universe_Class(O.all).Create_Date)));
	 Draw(Win, Win_Index+2, 3, Cyan, "Name    : " &
		Universe_Class(O.all).Name);
	 Draw(Win, Win_Index+3, 3, Cyan, "Arity   : " & 
		To_Wide_String(Natural'Image(Arity)));
	 return O;
      else
	 return null;
      end if;
   end Create;
   
   procedure Help(Universe    : in out Universe_Class'Class;
		  Win       : in Window_Type;
		  Win_Index : in out Positive;
		  Name      : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Red, "create Universe : help");
      Draw(Win, Win_Index+2, 3, Cyan, "create Universe");
      Win_Index := Win_Index + 3;
      Wide_Fixed.Move("help", Name, Error, Left, ' ');
   end Help;
   
   procedure Write (O : in Universe_Class;File : in W_Io.File_Type) is
   begin
      
      W_Io.Put_Line(File, To_Wide_String(Tag_Name'Image(Abstracted_Class(O).Tag)));      
      W_Io.Put_Line(File, To_Wide_String(Abstracted_Index'Image(O.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Create_Date)));
      W_Io.Put_Line(File, O.Name);
      
      
      for I in 1..Arity loop
	 W_Io.Put_Line(File, To_Wide_String(Vector_Type'Image(O.Origine.Space(I))));
      end loop;
      W_Io.Put_Line(File, To_Wide_String(Duration_Type'Image(O.Origine.Date)));
      W_Io.Put_Line(File, To_Wide_String(Long_Float'Image(O.Old)));
      
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Def.Index)));
      for I in 1..O.Def.Index loop
	 W_Io.Put_Line(File, To_Wide_String(O.Def.List(I).Names) & '=' & To_Wide_String(O.Def.List(I).Image));
      end loop;
      
      
   end Write;
   
   procedure Read (O : in out Universe_Class;File : in W_Io.File_Type) is
      Name_Last : Natural := 0;
      
      Tmp : Abstracted_Access;
      
      
      Att_Index : Natural := 0;
   begin
            
      -- obscure blank line            
      
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);	 
	 Index : Wide_String := W_Io.Get_Line(File);
      begin
	 
	 O.Index := Abstracted_index'Value(To_String(Index));
      end;
      
      
      O.Create_Date := Formatting.Value(To_String(W_Io.Get_Line(File)));
      
      W_Io.Get_Line(File, O.Name, Name_last);      
      
      
      
      
      -- obscure blank line
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);

      begin
	 
	 null;
      end;
      
      Tmp := new Universe_Class;
      Tmp.Index := O.Index;
      Tmp.Create_Date := O.Create_Date;
      Tmp.Name := O.Name;
      
      for I in 1..Arity loop
	 
	 Universe_Class(Tmp.all).Origine.Space(I) := Vector_Type'Value(To_String(W_Io.Get_Line(File)));

      end loop;
      
      Universe_Class(Tmp.all).Origine.Date := Duration_Type'Value(To_String(W_Io.Get_Line(File)));
      
      Universe_Class(Tmp.all).Old := Long_Float'Value(To_String(W_Io.Get_Line(File)));
      
      O := Universe_Class(Tmp.all);
      
      Att_Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      
      for I in 1..Att_Index loop
	 declare
	    Tags      : String_Access;
	    Image     : String_Access;
	 begin
	    Parse(W_Io.Get_Line(File), Tags, Image);
	    O.Def.List(I) := Make (Tags.all, Image.all);
	    O.Def.Index := O.Def.Index + 1;
	 end;
      end loop;
      

      
   end Read;
   
   procedure Random (O : in out Universe_Class) is
   begin
      null;
   end Random;
   --
   -----------------------------------------------------------------------------

end El.Classe.Universe_class ; 
