-- elhoim is full object organizer with editor and command interpreter.
-- Elhoim is Copyright (C) 2023 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2023-05-26 17:40:38"
-- Version := "0.6.6b"
with ANSI_Console;
use ANSI_Console;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Wide_Fixed;
use Ada.Strings;

package body El.Classe.Contacts_class is
   
   function contact_Value(Line : in Wide_String) return Name_Type is
      Name : Name_type := (others => Wide_Character'Val(32));
      
      Index : Natural := Wide_Fixed.Index(Line, " "); 
      
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " "); 
      
      Last  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");      
   begin
      if Last /= 0 then
	 Wide_Fixed.Move(Line(next+1..Last-1), Name);
      end if;      
      return Name;
   exception
      when others =>
	 return Name;
   end contact_Value;
         
   
   
   function Tel_num_Value(Line : in Wide_String) return Tel_num_type is
      
      Tel_num : Tel_num_type := (others => Wide_Character'Val(32));
      Index : Natural := Wide_Fixed.Index(Line, " ");
      Next  : Natural := Wide_Fixed.Index(Line(Index+1..Line'Last), " ");      
      Next_2  : Natural := Wide_Fixed.Index(Line(Next+1..Line'Last), " ");            
      
   begin
      
      if Next_2 /= 0 then
	 Wide_Fixed.Move(Line(Next_2+1..Line'last), Tel_Num);
      end if;      
      return Tel_num;
   exception
      when others =>
	 return Tel_Num;
   end Tel_num_Value;
   
   -----------------------------------------------------------------------------
   --                   Contact
   function Create(Win       : in Window_Type;
		   Win_Index : in out Positive;
		   Tel       : in Tel_Num_Type;
		   Name      : in Name_Type) return Abstracted_Access is
      O : Abstracted_Access := new Contact_Class;
   begin
      if O /= null then
	 Wide_Fixed.Move(Name, O.Name, Error, Left, ' ');
	 Wide_Fixed.Move(tel, Contact_Class(O.all).tel, Error, Left, ' ');
	 	 
	 Draw(Win, Win_Index+1, 3, Cyan, "Created : " &
		To_Wide_String(Image(Contact_Class(O.all).Create_Date)));
	 Draw(Win, Win_Index+2, 3, Cyan, "Name    : " &
		Contact_Class(O.all).Name);
	 Draw(Win, Win_Index+3, 3, Cyan, "Tel     : " & 
		Contact_Class(O.all).Tel);
	 return O;
      else
	 return null;
      end if;
   end Create;
      
   
   
   procedure Print (Object    : in Contact_Class'Class;
		    Win       : in Window_Type;
		    Win_Index : in out Positive;
		    Name      : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Cyan, "Index   : " &
	     To_Wide_String(Abstracted_Index'Image(Object.Index)));
      Draw(Win, Win_Index+2, 3, Cyan, "Created : "
	     & To_Wide_String(Image(Object.Create_Date)));            
      Draw(Win, Win_Index+3, 3, Cyan, "Name    : " & Object.Name);
      Draw(Win, Win_Index+4, 3, Cyan, "Tel     : "
	     & Object.tel);
      Win_Index := Win_Index + 4;
      
      Draw(Win, Win_Index+1, 3, Cyan, "Definition " & Object.Name);
      Win_Index := Win_Index + 1;
      for I in 1..Object.Def.Index loop
	 Draw(Win, Win_Index+1, 3, Cyan, "Attr " & To_Wide_String(Natural'Image(I)) & " : " &
		To_Wide_String(Object.Def.List(I).Names) & '=' & To_Wide_String(Object.Def.List(I).Image));
	 Win_Index := Win_Index + 1;
      end loop;
      
      Name := Object.Name;
   end Print;
   
   procedure Help(Contact    : in out Contact_Class'Class;
		  Win        : in Window_Type;
		  Win_Index  : in out Positive;
		  Name       : out Name_Type) is
   begin
      Draw(Win, Win_Index+1, 3, Red, "create contact : help");
      
      Draw(Win, Win_Index+2, 3, Cyan, "Name is string.");
      Draw(Win, Win_Index+3, 3, Cyan, "create contact NAME TEL_NUM");
      Win_Index := Win_Index + 3;
      Wide_Fixed.Move("help", Name, Error, Left, ' ');
   end Help;
   
   procedure Write (O : in Contact_Class;File : in W_Io.File_Type) is
   begin
      W_Io.Put_Line(File, To_Wide_String(Tag_Name'Image(Abstracted_Class(O).Tag)));
      W_Io.Put_Line(File, To_Wide_String(Abstracted_Index'Image(O.Index)));
      W_Io.Put_Line(File, To_Wide_String(Image(O.Create_Date)));
      W_Io.Put_Line(File, O.Name);
      W_Io.Put_Line(File, O.Tel);
      
      W_Io.Put_Line(File, To_Wide_String(Natural'Image(O.Def.Index)));
      for I in 1..O.Def.Index loop
	 W_Io.Put_Line(File, To_Wide_String(O.Def.List(I).Names) & '=' & To_Wide_String(O.Def.List(I).Image));
      end loop;
      
   end Write;
     
   procedure Read (O : in out Contact_Class;File : in W_Io.File_Type) is
      Name_Last : Natural := 0;
      Tel_Last : Natural := 0;
      
      Empty : Wide_String(1..80);
      Empty_Last : Natural := 0;
      
      Att_Index : Natural := 0;
   begin

      O.Index := Integer'Value(To_String(W_Io.Get_Line(File)));

      O.Create_Date := Value(To_String(W_Io.Get_Line(File)));

      W_Io.Get_Line(File, O.Name, Name_last);      

      W_Io.Get_Line(File, Empty, Empty_Last); 
      -- obscure blank line      
      
      W_Io.Get_Line(File, O.Tel, Tel_Last);
      
      declare
	 Empty_1 : Wide_String := W_Io.Get_Line(File);
      begin
	 null;
      end;
      
      Att_Index := Natural'Value(To_String(W_Io.Get_Line(File)));
      for I in 1..Att_Index loop
	 declare
	    Tags      : String_Access;
	    Image     : String_Access;
	 begin
	    Parse(W_Io.Get_Line(File), Tags, Image);
	    O.Def.List(I) := Make (Tags.all, Image.all);
	    O.Def.Index := O.Def.Index + 1;
	 end;
      end loop;

      
   end Read;
   
   procedure Random (O : in out Contact_Class) is
   begin
      null;
   end Random;
   --                     End contact
   -----------------------------------------------------------------------------   

end El.Classe.Contacts_class ; 
